<?php

use Illuminate\Support\Facades\DB;
use App\Mail\SubscriptionMail;

function image_input_show($name, $width=null, $height=null, $already_image_src=null) {

    // $name=input_name, $already_image_src=db_image, 
    // $width=..px/%, $height=..px/%

    echo '<div class="fileinput fileinput-new" data-provides="fileinput">
            <div class="fileinput-new img-thumbnail" style="width: '.($width?$width:'120px').'; height: '.($height?$height:'120px').';">
                <img src="'.$already_image_src.'" alt="image" />
            </div>
            <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: '.($width?$width:'120px').'; max-height: '.($height?$height:'120px').';"></div>
            <div>
                <span class="btn btn-sm btn-info btn-outline-secondary btn-file">
                    <span class="fileinput-new">Select New Image</span>
                    <span class="fileinput-exists">Change</span>
                    <input type="file" name="'.$name.'" accept="image/*" />
                </span>
                <a href="#" class="btn btn-sm btn-danger btn-outline-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
            </div>
        </div>';
}

function filterEditorContent($text)
{
    $text = str_replace("'", '', $text);
    $text = str_replace("`", '', $text);
    // Should use some proper HTML filtering here.
    $allowedTags='<p><strong><em><u><h1><h2><h3><h4><h5><h6><img>';
    $allowedTags.='<li><ol><ul><span><div><br><ins><del>';

    $content = strip_tags(stripslashes($text),$allowedTags);

    return $content;
}

function getSlugFromString($string)
{
	$string = str_replace(' ', '-', $string);
    $string = strtolower($string);

    return $string;
}

function show_image($image)
{

    $image_path = url('public') . $image;

    return $image_path;
}

function image_if_exists($image, $path)
{
    if($image && file_exists(public_path().$path)){

        $image_path = url('public').$path.$image;
    }else{

        $image_path = url('public').'/upload/default.jpg';
    }

    return $image_path;
}

function image_exists_or_default($image)
{
    $image_path = "";

    $file_path = public_path().'/'.$image;

    $file_path = str_replace('/', '\\', $file_path);

    // stream_resolve_include_path() is the fastest function than file_exists()

    if (false !== stream_resolve_include_path($file_path)) {

         $image_path = url('public').'/'.$image;
    }else{

        $image_path = url('public').'/upload/default.jpg';
    }

    // if( $image && file_exists($file_path) ){

    //     $image_path = url('public').'/'.$image;
    // }else{

    //     $image_path = url('public').'/upload/default.jpg';
    // }

    return $image_path;
}

function moduleExist($role_permissions, $module)
{
    $status = false;
    foreach ($role_permissions as $key => $value) {
        if ($value['permi_module'] == $module) {
            $status = true;
            break;
        }
    }

    return $status;
}

function actionExist($role_permissions, $module, $action)
{
    $status = false;
    foreach ($role_permissions as $key => $value) {
        if ( $value['permi_module'] == $module) {
            if ( strpos($value['permi_desc'], $action) !== false ) {
                $status = true;
                break;
            }
        }
    }
    return $status;
}

function emailQueue($email, $message_text, $subject, $sender_name='Company', $sender_email='company@gmail.com')
{
    $multiple_email = explode(',', $email);

    $data = [
            'sender_name'    => $sender_name,
            'sender_email'   => $sender_email,
            'subject'        => $sender_email,
            'message_text'   => $message_text,
        ];

    if(count($multiple_email) == 1){

        $email = $data['receiver_email'] = $multiple_email[0];
        $email = trim( filter_var($email, FILTER_SANITIZE_EMAIL) );
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {                
            Mail::queue(new SubscriptionMail($data));
        }

    }elseif (count($multiple_email) > 1) {

        $email = $data['receiver_email'] = $multiple_email[0];
        $email = trim( filter_var($email, FILTER_SANITIZE_EMAIL) );
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {                
            Mail::queue(new SubscriptionMail($data));
        }

        $email = $data['receiver_email'] = $multiple_email[1];
        $email = trim( filter_var($email, FILTER_SANITIZE_EMAIL) );
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {                
            Mail::queue(new SubscriptionMail($data));
        }
    }
}

// function convert_number_to_words($number) {

//     $hyphen      = '-';
//     $conjunction = '  ';
//     $separator   = ' ';
//     $negative    = 'negative ';
//     $decimal     = ' point ';
//     $dictionary  = array(
//         0                   => 'Zero',
//         1                   => 'One',
//         2                   => 'Two',
//         3                   => 'Three',
//         4                   => 'Four',
//         5                   => 'Five',
//         6                   => 'Six',
//         7                   => 'Seven',
//         8                   => 'Eight',
//         9                   => 'Nine',
//         10                  => 'Ten',
//         11                  => 'Eleven',
//         12                  => 'Twelve',
//         13                  => 'Thirteen',
//         14                  => 'Fourteen',
//         15                  => 'Fifteen',
//         16                  => 'Sixteen',
//         17                  => 'Seventeen',
//         18                  => 'Eighteen',
//         19                  => 'Nineteen',
//         20                  => 'Twenty',
//         30                  => 'Thirty',
//         40                  => 'Fourty',
//         50                  => 'Fifty',
//         60                  => 'Sixty',
//         70                  => 'Seventy',
//         80                  => 'Eighty',
//         90                  => 'Ninety',
//         100                 => 'Hundred',
//         1000                => 'Thousand',
//         1000000             => 'Million',
//         1000000000          => 'Billion',
//         1000000000000       => 'Trillion',
//         1000000000000000    => 'Quadrillion',
//         1000000000000000000 => 'Quintillion'
//     );
   
//     if (!is_numeric($number)) {
//         return false;
//     }
   
//     if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
//         // overflow
//         trigger_error(
//             'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
//             E_USER_WARNING
//         );
//         return false;
//     }
 
//     if ($number < 0) {
//         return $negative . convert_number_to_words(abs($number));
//     }
   
//     $string = $fraction = null;
   
//     if (strpos($number, '.') !== false) {
//         list($number, $fraction) = explode('.', $number);
//     }
   
//     switch (true) {
//         case $number < 21:
//             $string = $dictionary[$number];
//             break;
//         case $number < 100:
//             $tens   = ((int) ($number / 10)) * 10;
//             $units  = $number % 10;
//             $string = $dictionary[$tens];
//             if ($units) {
//                 $string .= $hyphen . $dictionary[$units];
//             }
//             break;
//         case $number < 1000:
//             $hundreds  = $number / 100;
//             $remainder = $number % 100;
//             $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
//             if ($remainder) {
//                 $string .= $conjunction . convert_number_to_words($remainder);
//             }
//             break;
//         default:
//             $baseUnit = pow(1000, floor(log($number, 1000)));
//             $numBaseUnits = (int) ($number / $baseUnit);
//             $remainder = $number % $baseUnit;
//             $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
//             if ($remainder) {
//                 $string .= $remainder < 100 ? $conjunction : $separator;
//                 $string .= convert_number_to_words($remainder);
//             }
//             break;
//     }
   
//     if (null !== $fraction && is_numeric($fraction)) {
//         $string .= $decimal;
//         $words = array();
//         foreach (str_split((string) $fraction) as $number) {
//             $words[] = $dictionary[$number];
//         }
//         $string .= implode(' ', $words);
//     }
   
//     return $string;
// }

?>