<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Controllers\Controller;
use App\Model\Admission;
use Image;

class AdmissionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = Admission::latest()->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editAdmission">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deleteAdmission">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        return view('backend.admission.index' );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation = [
            'title' => 'required',
        ];

        if ( ! $request->Admission_id || $request->admission_file) {
            $validation['admission_file'] = 'required|mimes:doc,docx,xls,xlsx,pdf,jpg,jpeg,png|max:10240';
        }

        $request->validate($validation);

    	$requests = [
        	'title' => $request->title,
        	'description' => $request->description,
        	'authored_by' => \Auth::user()->id,
        ];

        $image_title = getSlugFromString($requests['title']);

    	if(request()->hasFile('admission_file')){


            $uploadDir = '/upload/admission_file/';
            $file_name = $request->title.'-'.time().'.'.$request->admission_file->extension();  
     
            $request->admission_file->move(public_path($uploadDir), $file_name);

            $requests['admission_file'] = $uploadDir. $file_name;
        }

        Admission::updateOrCreate(
            ['id' => $request->Admission_id],

            $requests
        );

        return response()->json(['success'=>'Admission saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $admission = Admission::find($id);
        return response()->json($admission);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Admission::find($id)->delete();

       return response()->json(['success'=>'Admission deleted successfully.']);
    }

}