<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Controllers\Controller;
use App\Model\Category;
use App\Model\SubCategory;
use App\Model\Folder;
use Image;
use DB;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = Category::latest()->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editCategory">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deleteCategory">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        return view('backend.category.index' );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation = [
            'name' => 'required',
        ];

        $request->validate($validation);

    	$requests = [
        	'name' => $request->name,
            'slug' => getSlugFromString($request->name),
        	'description' => $request->description,
        	'authored_by' => \Auth::user()->id,
        ];

        Category::updateOrCreate(
            ['id' => $request->Category_id],

            $requests
        );

        return response()->json(['success'=>'Category saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $category = Category::find($id);
        return response()->json($category);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Category::find($id)->delete();

       return response()->json(['success'=>'Category deleted successfully.']);
    }

    public function files_auto_listing(Request $request)
    {
        return view('backend.files.files_auto_listing');
    }
    public function files_auto_listing_run(Request $request)
    {
        $request->drive_host = (strpos($request->drive_host, 'http') === false) ? 'http://'.$request->drive_host : $request->drive_host;

        $auth_user_id = \Auth::user()->id;

        // if ($_SERVER['HTTP_HOST']=='localhost' && $request->isMethod('post')) {
            
        $drive = strtoupper($request->drive_letter).':/';

        $ddd = $this->dirToArray($drive, $request);

        $drive_char = substr($drive, 0, 1);

        // empty drive listing
        $categories = Category::where(['drive'=>$drive_char])->get();

        foreach ($categories as $key1 => $value1) {

            $sub_cat = SubCategory::where(['category_id'=>$value1->id])->get();
            
            foreach ($sub_cat as $key => $value) {

                Folder::where(['sub_category_id'=>$value->id])->delete();

                $value->delete();
            }
        }
        Category::where(['drive'=>$drive_char])->delete();
        // empty drive listing ends

        foreach ($ddd as $key => $value) {

            if ( is_numeric($key) ) {

                continue;
            }

            try{

                DB::beginTransaction();

                $category = Category::create([
                    'type' => $request->file_type,
                    'drive' => $drive_char,
                    // check
                    'drive_host' => $request->drive_host,
                    'name' => $key,
                    'slug' => getSlugFromString($key),
                    'authored_by' => $auth_user_id,
                ]);

                if ( is_array($value)) {

                    foreach ($value as $key2 => $value2) {

                        $sub_category= SubCategory::create([
                            'category_id' => $category->id,
                            'title' => $key2,
                            'slug' => getSlugFromString($key2),
                            'authored_by' => $auth_user_id,
                        ]);

                        if ( is_array($value2)) {
                            foreach ($value2 as $key3 => $value3) {
                                if ( is_array($value3)) {

                                    $folder = Folder::create([
                                        'sub_category_id' => $sub_category->id,
                                        'video_folder_name' => $key3,
                                        'video_url' => $this->getFileUrl($value3, $request->file_type),
                                        'thumbnail_url' => $this->getThumbnailUrl($value3),
                                        //check
                                        'year' => $key2,
                                        'authored_by' => $auth_user_id,
                                    ]);
                                }
                            }
                        }
                    }
                }

                DB::commit();

            }catch(\Exception $e){
                DB::rollBack();

                return response()->json(['status'=>'error', 'message'=>'Files synced failed! '.
                     substr($e->getMessage(), 0).'...'] );
            }
        }

        return response()->json(['status'=>'success', 'message'=>'Files synced successfully!'], 200);
    }
    public function dirToArray($dir, $request){
        
        $result = array();

        $cdir = scandir($dir);

        foreach ($cdir as $key => $value)
        {
            if ( 
                strpos($value, '.BIN') !== false ||
                strpos($value, '.tmp') !== false ||
                strpos($value, 'Thumbs.db') !== false ||
                strpos($value, 'System Volume Information') !== false

            ) {
                continue;
            }

            if (!in_array($value,array(".","..")) )
            {
                if (is_dir($dir . DIRECTORY_SEPARATOR . $value))
                {
                    $result[$value] = $this->dirToArray($dir . DIRECTORY_SEPARATOR . $value, $request);
                }
                else
                {
                    $result[] = $value;
                }
            }
        }
          
        return $result; 
    }
    public function getFileUrl($data, $file_type)
    {
        $file_url = "";

        foreach ($data as $key => $value) {

            if ( is_array($value) ) {

                // nested/child folder exists
                // throw new \Exception("Sorry! Folders are not associated correctly at ".$key, 1);

            }else{

                if ( $file_type == 'video' ) {

                    if ( preg_match("/(.mp4|.mkv|.avi|.flv|.wmv|.mov|.webm)/i", $value)) {

                        $file_url = $value;

                        break;
                    }

                }else if( $file_type == 'software' ){

                    if ( preg_match("/(.zip|.rar|.iso)/i", $value)) {

                        $file_url = $value;

                        break;
                    }

                }else if( $file_type == 'game' ){

                    if ( preg_match("/(.zip|.rar|.iso)/i", $value)) {

                        $file_url = $value;

                        break;
                    }
                }

            }
        }

        return $file_url;
    }

    public function getThumbnailUrl($data)
    {
        $thumbnail_url = "";

        foreach ($data as $key => $value) {

            if ( is_array($value) ) {

                // nested/child folder exists
                //throw new \Exception("Sorry! Folders are not associated correctly at ".$key, 1);

            }else{

                if ( preg_match("/(.jpg|.jpeg|.png|.gif)/i", $value)) {

                    $thumbnail_url = $value;

                    break;
                }
            }
        }

        return $thumbnail_url;
    }

}
