<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Model\Department;
use App\Model\Program;
use Image;

class DepartmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = Department::leftJoin('programs', 'programs.id', '=', 'departments.program_id')->latest('departments.id')->selectRaw('departments.*, programs.name as program_name')->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editDepartment">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deleteDepartment">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        $data['programs'] = Program::all();

        return view('backend.department.index', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    	$requests = [
        	'title' => $request->title,
        	'slug' => getSlugFromString($request->title),
            'program_id' => $request->program_id,
            'body' => filterEditorContent($request->body),
        	'remarks' => $request->remarks,
        	'authored_by' => \Auth::user()->id,
        ];

        $image_title = getSlugFromString($requests['title']);

    	if(request()->hasFile('image')){
            $image = request()->file('image');
            $extension = $image->getClientOriginalExtension();
            $uploadDir = '/upload/department_image/';
            $destinationPath = public_path($uploadDir);
            $img_name = $image_title.'-'.time().'.'.$extension;
            $img = Image::make($image->getRealPath());
            $img->resize(1024, 380)->save($destinationPath.'/'. $img_name );
            $requests['image'] = $uploadDir . $img_name;
        }

        Department::updateOrCreate(['id' => $request->Department_id],

            $requests
        );

        return response()->json(['success'=>'Department saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $department = Department::find($id);
        return response()->json($department);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Department::find($id)->delete();

       return response()->json(['success'=>'Department deleted successfully.']);
    }

}