<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Controllers\Controller;
use App\Model\FacultyMember;
use Image;

class FacultyMemberController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = FacultyMember::latest()->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editFacultyMember">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deleteFacultyMember">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        return view('backend.faculty_member.index' );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    	$requests = [
        	'name' => $request->name,
            'designation' => $request->designation,
        	'description' => $request->description,
        	'authored_by' => \Auth::user()->id,
        ];

        $image_title = getSlugFromString($requests['name']);

    	if(request()->hasFile('image')){
            $image = request()->file('image');
            $extension = $image->getClientOriginalExtension();
            $uploadDir = '/upload/faculty_member_image/';
            $destinationPath = public_path($uploadDir);
            $img_name = $image_title.'-'.time().'.'.$extension;
            $img = Image::make($image->getRealPath());
            $img->resize(768, 550)->save($destinationPath.'/'. $img_name );
            $requests['image'] = $uploadDir . $img_name;
        }

        FacultyMember::updateOrCreate(['id' => $request->faculty_member_id],

            $requests
        );

        return response()->json(['success'=>'Faculty Member saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $faculty_member = FacultyMember::find($id);
        return response()->json($faculty_member);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       FacultyMember::find($id)->delete();

       return response()->json(['success'=>'Faculty Member deleted successfully.']);
    }

}