<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Controllers\Controller;
use App\Model\Gallery;
use Image;

class GalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = Gallery::latest()->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editGallery">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deleteGallery">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        return view('backend.gallery.index' );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    	$requests = [
        	'title' => $request->title,
        	'description' => $request->description,
        	'link' => $request->link,
        	'authored_by' => \Auth::user()->id,
        ];

        $image_title = getSlugFromString($requests['title']);

    	if(request()->hasFile('gallery_image')){
            $gallery_image = request()->file('gallery_image');
            $extension = $gallery_image->getClientOriginalExtension();
            $uploadDir = '/upload/gallery_image/';
            $destinationPath = public_path($uploadDir);
            $img_name = $image_title.'-'.time().'.'.$extension;
            $img = Image::make($gallery_image->getRealPath());
            $img->resize(768, 550)->save($destinationPath.'/'. $img_name );
            $requests['gallery_image'] = $uploadDir . $img_name;
        }

        Gallery::updateOrCreate(['id' => $request->Gallery_id],

            $requests
        );

        return response()->json(['success'=>'Gallery saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $gallery = Gallery::find($id);
        return response()->json($gallery);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Gallery::find($id)->delete();

       return response()->json(['success'=>'Gallery deleted successfully.']);
    }

}