<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Controllers\Controller;
use App\Model\Notice;
use Image;

class NoticeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = Notice::latest()->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editNotice">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deleteNotice">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        return view('backend.notice.index' );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation = [
            'title' => 'required',
        ];

        if ( ! $request->Notice_id || $request->notice_file) {
            $validation['notice_file'] = 'required|mimes:doc,docx,xls,xlsx,pdf,jpg,jpeg,png|max:10240';
        }

        $request->validate($validation);

    	$requests = [
        	'title' => $request->title,
        	'description' => $request->description,
        	'authored_by' => \Auth::user()->id,
        ];

        $image_title = getSlugFromString($requests['title']);

    	if(request()->hasFile('notice_file')){


            $uploadDir = '/upload/notice_file/';
            $file_name = $request->title.'-'.time().'.'.$request->notice_file->extension();  
     
            $request->notice_file->move(public_path($uploadDir), $file_name);

            $requests['notice_file'] = $uploadDir. $file_name;
        }

        Notice::updateOrCreate(
            ['id' => $request->Notice_id],

            $requests
        );

        return response()->json(['success'=>'Notice saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $notice = Notice::find($id);
        return response()->json($notice);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Notice::find($id)->delete();

       return response()->json(['success'=>'Notice deleted successfully.']);
    }

}