<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Model\Page;
use Image;

class PageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = Page::latest()->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editPage">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deletePage">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        return view('backend.page.index' );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    	$requests = [
        	'title' => $request->title,
        	'description' => filterEditorContent( $request->description ),
        	'slug' => getSlugFromString($request->title),
        	'authored_by' => \Auth::user()->id,
        ];

        $image_title = getSlugFromString($requests['title']);

    	if(request()->hasFile('page_image')){
            $page_image = request()->file('page_image');
            $extension = $page_image->getClientOriginalExtension();
            $uploadDir = '/upload/page_image/';
            $destinationPath = public_path($uploadDir);
            $img_name = $image_title.'-'.time().'.'.$extension;
            $img = Image::make($page_image->getRealPath());
            $img->resize(422, 315)->save($destinationPath.'/'. $img_name );
            $requests['page_image'] = $uploadDir . $img_name;
        }

        Page::updateOrCreate(['id' => $request->Page_id],

            $requests
        );

        return response()->json(['success'=>'Page saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page = Page::find($id);
        return response()->json($page);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Page::find($id)->delete();

       return response()->json(['success'=>'Page deleted successfully.']);
    }

}