<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Controllers\Controller;
use App\Model\Result;
use Image;

class ResultController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = Result::latest()->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editResult">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deleteResult">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        return view('backend.result.index' );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation = [
            'title' => 'required',
        ];

        if ( ! $request->Result_id || $request->result_file) {
            $validation['result_file'] = 'required|mimes:doc,docx,xls,xlsx,pdf,jpg,jpeg,png|max:10240';
        }

        $request->validate($validation);

    	$requests = [
        	'title' => $request->title,
        	'description' => $request->description,
        	'authored_by' => \Auth::user()->id,
        ];

        $image_title = getSlugFromString($requests['title']);

    	if(request()->hasFile('result_file')){


            $uploadDir = '/upload/result_file/';
            $file_name = $request->title.'-'.time().'.'.$request->result_file->extension();  
     
            $request->result_file->move(public_path($uploadDir), $file_name);

            $requests['result_file'] = $uploadDir. $file_name;
        }

        Result::updateOrCreate(
            ['id' => $request->Result_id],

            $requests
        );

        return response()->json(['success'=>'Result saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $result = Result::find($id);
        return response()->json($result);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Result::find($id)->delete();

       return response()->json(['success'=>'Result deleted successfully.']);
    }

}