<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Controllers\Controller;
use App\Model\VideoGallery;
use Image;

class VideoGalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = VideoGallery::latest()->get();

            return Datatables::of($data)

                    ->addIndexColumn()

                    ->addColumn('action', function($row){

                           $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Edit" class="edit btn btn-primary btn-xs editVideoGallery">Edit</a>';

                           $btn = $btn.' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="'.$row['id'].'" data-original-title="Delete" class="btn btn-danger btn-xs deleteVideoGallery">Delete</a>';

                            return $btn;
                    })

                    ->rawColumns(['action'])

                    ->make(true);
        }

        return view('backend.video_gallery.index' );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation = [
            'title' => 'required',
            'link' => 'required',
        ];
        // https://www.youtube.com/watch?v=QecqyznB7_U
        //https://youtu.be/QecqyznB7_U
        // <iframe width="1263" height="480" src="https://www.youtube.com/embed/QecqyznB7_U" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

        $request->validate($validation);

    	$requests = [
        	'title' => $request->title,
        	'description' => $request->description,
        	'link' => $request->link,
        	'authored_by' => \Auth::user()->id,
        ];

        VideoGallery::updateOrCreate(['id' => $request->gallery_id],

            $requests
        );

        return response()->json(['success'=>'VideoGallery saved successfully.']);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $gallery = VideoGallery::find($id);
        return response()->json($gallery);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       VideoGallery::find($id)->delete();

       return response()->json(['success'=>'VideoGallery deleted successfully.']);
    }

}