<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Model\Folder;
use DB;
use Response;
use Illuminate\Support\Str;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;

class FolderController extends Controller
{
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function movies(Request $request)
    {
        $movies = DB::table('folder_details')->where('type', 'video');
        
        if ($request->search) {

            $movies = $movies->where('video_folder_name', 'like', '%'.$request->search.'%');
        }

        if ($request->category_slug) {

            $movies = $movies->where('category_slug', '=', $request->category_slug);
        }

        if ($request->sub_category_slug) {

            $movies = $movies->where('sub_category_slug', '=', $request->sub_category_slug);
        }

        $data['movies'] = $movies->orderBy('id', 'desc')->paginate(12);

        return view('frontend.movies', $data);
    }

    public function softwares(Request $request)
    {
        $softwares = DB::table('folder_details')->where('type', 'software');
        
        if ($request->search) {

            $softwares = $softwares->where('video_folder_name', 'like', '%'.$request->search.'%');
        }

        if ($request->category_slug) {

            $softwares = $softwares->where('category_slug', '=', $request->category_slug);
        }

        if ($request->sub_category_slug) {

            $softwares = $softwares->where('sub_category_slug', '=', $request->sub_category_slug);
        }

        $data['softwares'] = $softwares->orderBy('id', 'desc')->paginate(12);

        return view('frontend.files.softwares', $data);
    }

    public function search_movies(Request $request)
    {
        $movies = DB::table('folder_details')->where('type', 'video');
        
        if ($request['query']) {

            $where = "video_folder_name like '%".$request['query']."%'";

            $movies = $movies->whereRaw($where);
        }

        $data['movies'] = $movies->limit(12)->orderBy('id', 'desc')->get();

        return response()->json(['status'=>'success', 'data'=> $data['movies'] ]);
    }

    public function details($folder_id )
    {
        $data['folder'] = DB::table('folder_details')->find($folder_id);

        $data['related_videos'] = DB::table('folder_details')->whereRaw(" id != ".$data['folder']->id." and category_name = '".$data['folder']->category_name."' ")->orderBy('id', 'desc')->limit(8)->get();

        return view('frontend.folder', $data);
    }

    public function software_details($folder_id )
    {
        $data['folder'] = DB::table('folder_details')->find($folder_id);

        $data['related_videos'] = DB::table('folder_details')->whereRaw(" id != ".$data['folder']->id." and category_name = '".$data['folder']->category_name."' ")->orderBy('id', 'desc')->limit(8)->get();

        return view('frontend.files.software_folder', $data);
    }

    public function download_file($id)
    {


        try {
            
            $video_folder = DB::table('folder_details')->find($id);

            $remoteURL = $video_folder->drive_host.'/'.$video_folder->category_name.'/'.$video_folder->sub_category_title.'/'.$video_folder->video_folder_name.'/'.$video_folder->video_url;
            
            if (strpos($remoteURL, ' ') !== false) {

                //downloading doesn't not work containing space in url so redirect only
                return redirect($remoteURL);

            }else{

                //Streamed Downloads
                //Sometimes you may wish to turn the string response of a given operation into a downloadable response without having to write the contents of the operation to disk. You may use the streamDownload method in this scenario. This method accepts a callback, file name, and an optional array of headers as its arguments:

                return response()->streamDownload(function() use($remoteURL) {

                    echo file_get_contents($remoteURL);

                }, basename($remoteURL) );
            }

            // Another method works
            // Remote download URL
            // Force download
            // header('Content-type: application/x-file-to-save'); 
            // header('Content-Transfer-Encoding: binary');
            // header('Content-Disposition: attachment; filename="'.basename($remoteURL).'"');
            // ob_end_clean();
            // readfile($remoteURL);
            // exit;

        } catch (\Exception $e) {

            echo '<pre>'; dd($e->getMessage()); echo '</pre>';
            // return abort(404);
        }
    }

    

    
}
