<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Model\Gallery;
use App\Model\Notice;
use App\Model\Page;
use App\Model\VideoGallery;
use App\Model\Folder;
use App\Model\Category;
use DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    // public function __construct()
    // {
    //     $this->middleware('auth');
    // }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        $array4 = ['Dhallywood (Bangladeshi)', 'Bollywood (Hindi)', 'Kollywood (Tamil)', 'Hollywood (English)', 'Hallywood (Korean)'];
        $array5 = ['Dhallywood (Bangladeshi)', 'Bollywood (Hindi)', 'Kollywood (Tamil)', 'Hollywood (English)', 'Hallywood (Korean)'];

        $data['all_categories'] = Category::where('type', 'video')->whereIn('name', $array4)->get();
        $data['categories'] = Category::where('type', 'video')->whereIn('name', $array5)->limit(5)->get();

        $data['category_folders'] = [];

        foreach ($data['categories'] as $key => $value) {

            $data['category_folders'][$value->name] = DB::table('folder_details')->whereRaw("category_name = '".$value->name."' and type='video' ")->orderBy('id', 'desc')->limit(8)->get();
        }

        $data['folder_details_for_slide'] = [];

        foreach ($data['all_categories'] as $key => $value) {

            foreach ($array4 as $key1 => $value1) {

                if ( strpos($value->name, $value1) !== false) {

                    $data['folder_details_for_slide'][] = DB::table('folder_details')->whereRaw(" thumbnail_url != '' && category_name = '".$value->name."' and type='video' ")->orderBy('id', 'desc')->limit(2)->get();
                }
            }
        }

        $data['slide'] = [];

        foreach ($data['folder_details_for_slide'] as $slide){
            foreach ($slide as $folder){
                $data['slide'][] = $folder;
            }
        }

        return view('frontend.home', $data);
    }

    public function notice(Request $request)
    {
        $notices = Notice::latest();
        if ($request->search) {
            $notices->where('title', 'like', '%'.$request->search.'%');
        }
        $data['notices'] = $notices->get();

        return view('frontend.notice', $data);
    }

    public function gallery()
    {
        $data['galleries'] = Gallery::latest()->get();

        return view('frontend.gallery', $data);
    }

    public function video_gallery()
    {
        $data['video_galleries'] = VideoGallery::latest()->get();

        return view('frontend.video_gallery', $data);
    }

    public function contact()
    {
        $data = [];

        return view('frontend.contact', $data);
    }

    
}
