<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\PaymentGateway\NewPaysenz;
use App\Model\Payment;
use Illuminate\Support\Facades\Auth;
use App\User;

class PaymentApp extends Controller
{
    public function index()
    {
    	$paymentGateway = new NewPaysenz(route('payment-success'), route('payment-fail'), route('payment-cancel'), route('payment-ipn'));
        $data['access_token'] = $paymentGateway->retrieveToken();
        $data['paysenz_urls'] = $paymentGateway->paysenz_url();
        $data['paysenz_submit_url'] = $paymentGateway->submitUrl;
        $data['paysenz_user'] = $paymentGateway->paysenz_user_info();
        $data['client_id'] = $paymentGateway->clientId;

        return view('payment.index', $data);
    }

    public function success(Request $request)
    {
    	try{
            $gateway = new NewPaysenz();                

            if($request->payment_status == 'Successful'){

            	$user_id = Auth::user()->id;
		    	$user = User::where('id', $user_id)->first();

                $remarks_data = $request->remarks;
                $remarks = json_decode($remarks_data, true);

                $paymentData['tracking_id']=isset($remarks['card_no']) ? $remarks['card_no']:"";
                $paymentData['custom_2'] = $request->custom_2;
                $paymentData['mer_txnid'] = $request->mer_txnid;

                $already_paid = Payment::where([
                    'tracking_id' => $paymentData['tracking_id'],
                    'custom_2'    => $paymentData['custom_2'],
                    'mer_txnid'   => $paymentData['mer_txnid'],
                    'user_id'   => $user_id
                ])->first();

                if ($already_paid) {
                   return redirect('dashboard')->with('error', 'Already paid.');
                }
                $total_paid = $request->merchant_amount_deducted;
                $total_paid = round($total_paid);

                $paymentData['total_paid'] = $total_paid;
                $paymentData['payment_reference'] = $request->payment_type;
                $paymentData['user_id'] = $user_id;
                $paymentData['payment_method'] = 'online';

                $payment = Payment::create($paymentData);

                User::where('id', '=', $user_id)->update(['active'=>1]);

                $message_text = "Order Placed \n";
                $message_text .= 'User ID: ' . $user_id . "\n";
                $message_text .= 'Payment Amount of Tk. ' . $total_paid . " is received \n";
                $message_text .= 'Company';

                $response = $user->active_sms_sending($user->phone, $message_text);

                if (!empty($response[0]) && $response[0] ==1101) {
                    $sms_status = 'sms sent';
                }else{
                    $sms_status = 'sms not sent [sms server: '.$response['message'].']';
                }

                try{
                    $email = isset($user->email)?$user->email:'';
                    emailQueue('sender---@gmail.com', $message_text, $subject='Service Confirmation');
                }catch(\Exception $e){
                    // nothing to
                }

                // Mail::raw($message_text, function ($message) use($user) {

                //      $message->to($user->email)

                //      ->subject('App Subscription Confirmation');                 
                // });

                return redirect('dashboard')->with('success', 'Payment success!');

            }

        }catch(Swift_TransportException $e){

            return redirect('dashboard')->with('success', 'Payment success!');
        
        }catch(\Exception $e){

            $message = $e->getMessage();
            // empty mail
            if (strpos($message, 'Address in mailbox') !== false) {
                $message = 'User email not found!';
            }
            return redirect('dashboard')->with('success', 'Payment success! But '.$message);
        }

        return redirect('dashboard')->with('success', 'Payment success!');
    }

    public function fail()
    {
        return redirect('dashboard')->with('error', 'Sorry Payment failled!');
    }

    public function cancel()
    {
        return redirect('dashboard')->with('error', 'Sorry Payment cancelled!');
    } 

    public function ipn()
    {
        return redirect('dashboard')->with('error', 'Sorry Payment ipned!');
    }

    public function payHistory(Request $request){
        if($request->from_date){
            $from_date = date('Y-m-d', strtotime($request->from_date));
        }else{
            $from_date = date('Y-m-d');
        }
        if($request->to_date){
            $to_date = date('Y-m-d', strtotime($request->to_date));
        }else{
            $to_date = date('Y-m-d');
        }

        $collection = Payment::whereDate('payments.created_at', '>=', $from_date)
            ->whereDate('payments.created_at', '<=', $to_date);

        if ($request->payment_method) {

            $collection->where('payments.payment_method', $request->payment_method);
        }
            
        $collection->leftJoin('users', 'users.id', 'payments.user_id');
        $collection->selectRaw('payments.*, users.name');
        $data['collections'] = $collection->get();

        return view('payment.history', $data);
    }
    
    
}
