<?php

namespace App\Http\Controllers;

use App\Model\Setting;
use Illuminate\Http\Request;
use DB;
use Image;

class SettingController extends Controller
{
    public function index(Request $request)
    {
        if ($request->isMethod('post')) {

            $requests = $request->all();
            $auth_user = \Auth::user();

            if(request()->hasFile('site_logo')){
                $site_logo = request()->file('site_logo');
                $extension = $site_logo->getClientOriginalExtension();
                $uploadDir = '/upload/misc/';
                $destinationPath = public_path($uploadDir);
                $img_name = 'site_logo'.'-'.time().'.'.$extension;
                $img = Image::make($site_logo->getRealPath());
                $img->resize(295, 65)->save($destinationPath.'/'. $img_name );
                $requests['site_logo'] = $uploadDir . $img_name;
            }

            if(request()->hasFile('site_banner')){
                $site_banner = request()->file('site_banner');
                $extension = $site_banner->getClientOriginalExtension();
                $uploadDir = '/upload/misc/';
                $destinationPath = public_path($uploadDir);
                $img_name = 'site_banner'.'-'.time().'.'.$extension;
                $img = Image::make($site_banner->getRealPath());
                $img->resize(828, 220)->save($destinationPath.'/'. $img_name );
                $requests['site_banner'] = $uploadDir . $img_name;
            }

            if(request()->hasFile('principal_photo')){
                $principal_photo = request()->file('principal_photo');
                $extension = $principal_photo->getClientOriginalExtension();
                $uploadDir = '/upload/misc/';
                $destinationPath = public_path($uploadDir);
                $img_name = 'principal_photo'.'-'.time().'.'.$extension;
                $img = Image::make($principal_photo->getRealPath());
                $img->resize(400, 200)->save($destinationPath.'/'. $img_name );
                $requests['principal_photo'] = $uploadDir . $img_name;
            }

            unset($requests['_token']);

            // Should not delete images. It should be updated only
            Setting::where([['title', '!=', 'site_logo'], ['title', '!=', 'site_banner'], ['title', '!=', 'principal_photo']])->delete();

            foreach ($requests as $key => $value) {

                if ($key=='message_from_principal' ) {
                    $value = filterEditorContent($value);
                }

                $exist = Setting::where(['title' => $key, ])->first();
                if ($exist) {
                    $exist->update(['info' => $value, 'authored_by' => $auth_user->id]);
                }else{

                    Setting::create([
                        'title' => $key, 'info' => $value, 'authored_by' => $auth_user->id
                    ]);
                }

            }
            
            return redirect()->route('admin.settings.index')->with('success', sprintf('Setting Saved successfully'));   
        }

        $data['settings'] = Setting::all()->pluck('info', 'title');
        
        return view('misc.settings', $data);
    }

    
}
