<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SubscriptionMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->data['sender_email'], $this->data['sender_name'])
                    ->to($this->data['receiver_email'])
                    ->subject($this->data['subject'])
                    ->view('emails.text')
                    // ->text('emails.text')
                    ->with(
                      [
                            'message_text' => $this->data['message_text'],
                      ]);

                      // ->attach(public_path('/files/images').'/1547788415.jpg', [
                      //         'as' => '1547788415.jpg',
                      //         'mime' => 'image/jpeg',
                      // ]);
    }
}
