<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Member extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'type', 'email', 'extra_remember_token', 'password', 'phone', 'image', 'active', 'last_login_at', 'last_login_ip', 'logged_course',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function active_sms_sending($number, $text){

        // API Response Code
        $statuses = [
            '1000' => 'Invalid user or Password',
            '1002' => 'Empty Number',
            '1003' => 'Invalid message or empty message',
            '1004' => 'Invalid number',
            '1005' => 'All Number is Invalid ',
            '1006' => 'insufficient Balance ',
            '1009' => 'Inactive Account',
            '1010' => 'Max number limit exceeded',
            '1101' => 'Success',
        ];

        $response = array();

        $messageEnable = env('MESSAGE_SEND_ENABLE');
        if($messageEnable){
            $data = array(
                'username'=>'',
                'password'=>'', 
            );

            if(strlen($number) == '11'){
                $number = '88'.$number;
            }else{
                $number = $number;
            }    

            $data['number'] = $number;
            $data['message'] = $text;

            $url = "http://66.45.237.70/api.php";    

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,$url);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $smsresult = curl_exec($ch);
            $response = explode("|",$smsresult);
            $sendstatus = $response[0];

            // DB::table('sms_histories')->insert([
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'mobile_numbers' => $number,
            //     'message' => $text,
            //     'response_code' => $response[0],
            //     'status' => strtolower($statuses[$response[0]]),
            //     'gateway_user' => $data['username'],
            // ]);
        }

        $response['message'] = !empty($response[0]) ? $statuses[$response[0]] : 'message inactive!';

        return $response;
    }

}
 