<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use File;

class Setting extends Model
{

    protected $fillable = ['title', 'info', 'authored_by' ];

    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function boot()
    {
        parent::boot();

        static::saved(function () {

            $settings           = static::pluck('info', 'title')->toArray();

            $stringify_settings = var_export($settings, true);

            $content            = "<?php return {$stringify_settings};";

            File::put(config_path('app_settings.php'), $content);
        });
    }

}
