<?php

namespace App\PaymentGateway;

class NewPaysenz {

    public $baseUrl = url('/').'/pay/';

    // make dynamic
    // public $onlinePaymentMethodId = 3;

    /*
     * Paysenz Application URL
     */
    protected $appUrl = 'https://gopaysenz.com/';
    public $submitUrl;
    protected $tokenUrl;
    protected $verfiyUrl;

    public $successUrl;
    public $failUrl;
    public $cancelUrl;
    public $ipnUrl;

    public $grantType = 'password';
    public $clientId = 67;  // Required
    protected $clientSecret = 'qj8dBi2XxU2o9Mc7PKGa9CFnMKE9bXdYepUBuWh1'; // Required
    protected $clientUserName = ''; // Required
    protected $clientPassword = ''; // Required
    protected $clientScope = '*';
    protected $orderPrefix = ''; //


    public function __construct($successUrl = null, $failUrl = null, $cancelUrl = null, $ipnUrl = null){
        $this->submitUrl = $this->appUrl.'api/v1.0/pay';
        $this->tokenUrl = $this->appUrl.'oauth/token';
        $this->verfiyUrl = $this->appUrl.'api/v1.0/verify';

        $this->successUrl = $successUrl;
        $this->failUrl = $failUrl;
        $this->cancelUrl = $cancelUrl;
        $this->ipnUrl = $ipnUrl;
    }
    

    
    
    /**
     * @desc Get `access_token` for HTTP authorization
     * `access_token` validity is 3 months. So get the `access_token` first time, then
     * save it to Database or Application cache, so that you do not have to call this
     * methd every time.
     *
     */
    public function retrieveToken() {

        if (isset($_SESSION['paysenz_access_token'])) {
            return $_SESSION['paysenz_access_token'];
        } else {
            try {
                $requestParams = [
                    'grant_type' => $this->grantType,
                    'client_id' => $this->clientId,
                    'client_secret' => $this->clientSecret,
                    'username' => $this->clientUserName,
                    'password' => $this->clientPassword,
                    'scope' => $this->clientScope,
                ];

                $payload = json_encode($requestParams);


                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $this->tokenUrl);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLINFO_HEADER_OUT, true);
                // For certificate verification
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

                // Set HTTP Header for POST request
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json',
                        'Content-Length: ' . strlen($payload))
                );

                $response = curl_exec($ch);

                curl_close($ch);
                $content = json_decode((string) $response, true);
                $_SESSION['paysenz_access_token'] = $content['access_token'];
                return $content['access_token'];
            } catch (Exception $e) {
                return array('error' => true);
            }
        }
    }

    /**
     * @desc Verify Payment callback request
     * Re-try
     */
    public function verifyPaymentRequest($token, $post) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->verifyUrl);

        header('Content-Type: application/json');
        $post = json_encode($post); // Create JSON string from data ARRAY
        $authorization = "Authorization: Bearer " . $token; // **Prepare Autorisation Token**
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', $authorization)); // **Inject Token into Header**
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        $result = curl_exec($ch);
        curl_close($ch);
        return json_decode($result);
    }

    /// Success, Fail, Cancel URL
    public function paysenz_url() {
        $url = [
            'callback_success_url' => $this->successUrl,
            'callback_fail_url' => $this->failUrl,
            'callback_cancel_url' => $this->cancelUrl,
            'callback_ipn_url' => $this->ipnUrl
        ];
        return $url;
    }

    public function paysenz_user_info() {
        $data = [
            'grant_tyle' => $this->grantType,
            'client_id' => $this->clientId,
            'client_secret' => $this->clientSecret,
            'client_user_name' => $this->clientUserName,
            'client_password' => $this->clientPassword,
            'client_scope' => $this->clientScope,
        ];
        return $data;
    }

    public static function paysenz_payment_retry($order_id) {
        $requestParams = [
            'order_id' => $order_id,
            'client_id' => $this->clientId,
        ];
        $post = json_encode($requestParams);
        $ch = curl_init();
        $authorization = "Authorization: Bearer " . $this->retrieveToken(); // **Prepare Autorisation Token**
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', $authorization)); // **Inject Token into Header**
        curl_setopt($ch, CURLOPT_URL, $this->tokenUrl);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        // For certificate verification
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response);
    }

}
