<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use View;
use App\Model\Program;
use App\Model\Department;
use App\Model\Page;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        // don't worry inside models will load only when 
        // view 'acewebv.app' and 'frontend.home' are called
        View::composer(['acewebv.app', 'frontend.home',],  function ($view){

            $pages = Page::latest()->get();

            $view->with(['pages'=>$pages]);
        });

        // view()->composer('*', function ($view) 
        // {
          // for every view calling
        // });
    }
}
