<!doctype html>
<html class="no-js" lang="">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>@yield('head_title') {{config('app_settings.application_title')}}</title>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="{{url('public')}}/frontend/img/favicon.png">
    <!-- Normalize CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/normalize.css">
    <!-- Main CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/main.css">
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/custom.css">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/bootstrap.min.css">
    <!-- Animate CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/animate.min.css">
    <!-- Font-awesome CSS-->
    {{-- <link rel="stylesheet" href="{{url('public')}}/frontend/css/font-awesome.min.css"> --}}
    <link rel="stylesheet" href="{{ url('public') }}/ace_assets/css/font-awesome.css" />

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
    {{-- to match with old v4 --}}
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/v4-shims.css">
    <!-- Owl Caousel CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/vendor/OwlCarousel/owl.carousel.min.css">
    <link rel="stylesheet" href="{{url('public')}}/frontend/vendor/OwlCarousel/owl.theme.default.min.css">
    <!-- Main Menu CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/meanmenu.min.css">
    <!-- nivo slider CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/vendor/slider/css/nivo-slider.css" type="text/css" />
    <link rel="stylesheet" href="{{url('public')}}/frontend/vendor/slider/css/preview.css" type="text/css" media="screen" />
    <!-- Datetime Picker Style CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/jquery.datetimepicker.css">
    <!-- Magic popup CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/magnific-popup.css">
    <!-- Switch Style CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/hover-min.css">
    <!-- ReImageGrid CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/reImageGrid.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{url('public')}}/frontend/css/style.css">
    <!-- Modernizr Js -->
    <script src="{{url('public')}}/frontend/js/modernizr-2.8.3.min.js"></script>
    <script src="{{url('public')}}/frontend/js/jquery-2.2.4.min.js" type="text/javascript"></script>

    <!-- Google Map js -->
    {{-- use iframe instead --}}
    {{-- <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBtmXSwv4YmAKtcZyyad9W7D4AC08z0Rb4"></script>     --}}
    
    <style>
        nav#desktop-nav ul li .mega-menu-area > li {
            width: 230px;
            border-bottom: none;
            display: inline-block;
            margin-right: 14px;
        }
        nav#desktop-nav li.has-child-menu > ul.thired-level {
            left: 340px;
        }

        nav#desktop-nav ul li > ul {
            width: 340px;
        }

        .footer-box img {
            width: 210px;
            height: 195px;
        }

        .carousel-inner > .item > img {
            height: 490px;
        }

        .news-img-holder img {
            height: auto;
        }

        .owl-carousel .owl-item img {
            display: block;
            width: 100%;
            -webkit-transform-style: preserve-3d;
            /*height: 200px;*/
        }
        .header-top-right, .header-top-left {
            font-weight: bold;
        }

        .main-menu-area .header-search .search-form {
            background: rgba(0, 0, 0, 0.8);
            border: 2px solid #002147;
        }

        .search-result {
            text-align: left;
            position: absolute;
            bottom: -128px;
            right: 15px;
            z-index: 10;
            color: #eee;
            /*height: 50px;*/
            width: 500px;
            font-size: 18px;
            background: rgba(0, 0, 0, 0.7);
            border: 2px solid #000000;
            /*padding: 5px 18px 5px 10px;*/
            -webkit-box-shadow: inset 0px 0px 10px 5px rgba(253, 200, 0, 0.3);
            -moz-box-shadow: inset 0px 0px 10px 5px rgba(253, 200, 0, 0.3);
            box-shadow: inset 0px 0px 10px 5px rgba(253, 200, 0, 0.3);
        }

        .search-result li{
            padding-top: 5px;
            padding-bottom: 5px;
            padding-left: 15px;
            border: 1px solid #ccc;
        }

        .lecturers-content-wrapper .item-title {
            font-size: 14px;
        }
        .search-img{
            height: 50px;
            width: 70px;
        }

        nav#desktop-nav ul li > ul > li > a {
          padding: 5px 10px 5px 15px;
          font-size: 12px;
        }

        .footer-area-top {
            padding: 40px 0 0px;
        }

        @media screen and (min-width: 481px) {
            #search-button___2 {
                display: none;
            }
            #search-close{
                display: none;
            }
        }

        @media screen and (max-width: 480px) {
            #search-button___2 {
                display: block;
            }
            #slide-wrapper {
                margin-top: 7%;
            }
        }

    </style>
    <script>
        $(document).ready(function() {
            
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log("errorThrown", errorThrown);
                    console.log("textStatus", textStatus);
                    console.log("jqXHR", jqXHR);
                    if (jqXHR.status==419) {
                        $.notify('Session Expired! Refreshing...', 'error');
                        setTimeout(function() {

                            location.reload();
                        }, 1000);
                    }
                    if (jqXHR.status==401) {
                        $.notify('Unauthenticated! Refreshing...', 'error');
                        setTimeout(function() {

                            location.reload();
                        }, 1000);
                    }
                    
                }
            });

        });
    </script>
</head>

<body>
    <div id="wrapper">
        <!-- Header Area Start Here -->
        <header>
            <div id="header2" class="header2-area">
                <div class="header-top-area">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="header-top-left">
                                    <ul>
                                        <li><i class="fa fa-phone" aria-hidden="true"></i><a href="Tel:+1234567890"> {{ config('app_settings.site_phone') }} </a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="header-top-right">
                                    <ul>
                                        <li>
                                            <a class="login-btn-area" href="#" id="login-button"><i class="fa fa-envelope-o" aria-hidden="true"></i> {{ config('app_settings.site_email') }}</a>
                                        </li>
                                        <li>
                                            <a class="login-btn-area" target="_blank" href="{{ url('login') }}" id="login-button"><i class="fa fa-lock" aria-hidden="true"></i> Login</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="main-menu-area bg-textPrimary" id="sticker">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-2 col-md-2 col-sm-1">
                                <div class="logo-area">
                                    <a href="{{url('/')}}"><img class="img-responsive" src="{{ show_image( config('app_settings.site_logo') ) }}" alt="logo"></a>
                                </div>
                            </div>
                            <div class="col-lg-9 col-md-9 col-sm-9">
                                <nav id="desktop-nav">
                                    <ul>
                                        <li class="active"><a href="{{url('/')}}">Home</a>
                                        </li>

                                        @php
                                            $categories = App\Model\Category::where('type', 'video')->get();
                                            $sub_categories = App\Model\SubCategory::all();
                                        @endphp

                                        <li><a href="{{ url('movies/') }}">Movies</a>
                                            <ul>
                                                @foreach($categories as $key => $value)
                                                    <li class="has-child-menu"><a href="{{ url('movies/?category_slug='.$value->slug) }}">{{ $value->name }}</a>
                                                        <ul class="thired-level">
                                                            @foreach($sub_categories as $sub_key => $sub_value)
                                                                @if($value->id==$sub_value->category_id)
                                                                <li>
                                                                    <a href="{{ url('movies/?category_slug='.$value->slug.'&sub_category_slug='.$sub_value->slug) }}">{{ $sub_value->title }}</a>
                                                                </li>
                                                                @endif
                                                            @endforeach
                                                        </ul>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </li>

                                        <li>
                                            <a href="#">Movie Series</a>
                                        </li>

                                        <li>
                                            <a href="#">TV Series</a>
                                        </li>

                                        <li>
                                            <a href="{{ url('softwares/') }}?category_slug=games">Games</a>
                                        </li>

                                        <li>
                                            <a href="{{ url('softwares/') }}?category_slug=softwares">Software</a>
                                        </li>

                                        <li>
                                            <a href="#">More</a>
                                        </li>

                                        <li>
                                            <a target="_blank" href="{{ config('app_settings.live_tv_link') }}">Live TV</a>
                                        </li>

                                        <li><a href="{{url('/')}}/contact">Contact</a></li>

                                    </ul>
                                </nav>
                            </div>
                            <div class="col-lg-1 col-md-1 hidden-sm">
                                <div class="header-search">
                                    <a href="#" class="search-button___" id="search-button___" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-search" aria-hidden="true"></i></a>

                                    <form action="{{ url('movies/?') }}" method="get" class="search-form-main" style="display: none;">
                                        <input type="text" class="search-form" id="live-search" name="search" placeholder="Search...." required="">
                                                                            
                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Mobile Menu Area Start -->
            <div class="mobile-menu-area">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mobile-menu">
                                <nav id="dropdown">
                                    <ul>
                                        <li><a href="{{url('/')}}">Home</a>
                                        </li>              
                                        
                                        <li><a href="{{ url('movies/') }}">Movies</a>
                                            <ul>
                                                @foreach($categories as $key => $value)
                                                    <li class="has-child-menu"><a href="{{ url('movies/?category_slug='.$value->slug) }}">{{ $value->name }}</a>
                                                        <ul class="thired-level">
                                                            @foreach($sub_categories as $sub_key => $sub_value)
                                                                @if($value->id==$sub_value->category_id)
                                                                <li>
                                                                    <a href="{{ url('movies/?category_slug='.$value->slug.'&sub_category_slug='.$sub_value->slug) }}">{{ $sub_value->title }}</a>
                                                                </li>
                                                                @endif
                                                            @endforeach
                                                        </ul>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </li>

                                        <li>
                                            <a href="#">Movie Series</a>
                                        </li>

                                        <li>
                                            <a href="#">TV Series</a>
                                        </li>

                                        <li>
                                            <a href="{{ url('softwares/') }}?category_slug=games">Game</a>
                                        </li>

                                        <li>
                                            <a href="{{ url('softwares/') }}?category_slug=softwares">Software</a>
                                        </li>

                                        <li>
                                            <a href="#">More</a>
                                        </li>

                                        <li>
                                            <a target="_blank" href="{{ config('app_settings.live_tv_link') }}">Live TV</a>
                                        </li>

                                        <li><a href="{{url('/')}}/contact">Contact</a></li>

                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Mobile Menu Area End -->
        </header>
        <!-- Header Area End Here -->

        <a href="#" style="float: right;right: 7%;position: absolute;" class="search-button___" id="search-button___2" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-search" aria-hidden="true"></i></a>

        @include('layouts.notification')

        @yield('content')
        
    <footer>
      <div class="footer-area-top">
      <div class="container">
          <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                  <div class="footer-box">
                        <h3>Social Links</h3>
                        <h4>
                            <strong>
                                <a href="" class="text-default" style="color: white;">{{ config('app_settings.application_title') }}</a>
                            </strong>
                        </h4>
                        <p>{{ config('app_settings.site_slogan') }}</p>
                        <ul class="footer-social">
                              <li><a target="_blank" href="{{ config('app_settings.facebook_link') }}"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                              <li><a target="_blank" href="{{ config('app_settings.twitter_link') }}"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                              <li><a target="_blank" href="{{ config('app_settings.youtube_link') }}"><i class="fa fa-youtube" aria-hidden="true"></i></a></li>
                              <li><a target="_blank" href="{{ config('app_settings.instagram_link') }}"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                              <li><a target="_blank" href="{{ config('app_settings.linkedin_link') }}"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
                        </ul>
                  </div>
              </div>
              <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                  <div class="footer-box">
                      <h3>Our Branch Office Addresses </h3>
                      <ul class="featured-links">
                          <li>
                              <ul>
                                    @if(strlen(config('app_settings.important_link_1')) > 0)
                                        <li><a target="" href="{{ config('app_settings.important_link_1') }}">{{ config('app_settings.important_link_1_name') }}</a></li>
                                    @endif

                                    @if(strlen(config('app_settings.important_link_2')) > 0)
                                        <li><a target="" href="{{ config('app_settings.important_link_2') }}">{{ config('app_settings.important_link_2_name') }}</a></li>
                                    @endif

                                    @if(strlen(config('app_settings.important_link_3')) > 0)
                                        <li><a target="" href="{{ config('app_settings.important_link_3') }}">{{ config('app_settings.important_link_3_name') }}</a></li>
                                    @endif

                                    @if(strlen(config('app_settings.important_link_4')) > 0)
                                        <li><a target="" href="{{ config('app_settings.important_link_4') }}">{{ config('app_settings.important_link_4_name') }}</a></li>
                                    @endif

                                    @if(strlen(config('app_settings.important_link_5')) > 0)
                                        <li><a target="" href="{{ config('app_settings.important_link_5') }}">{{ config('app_settings.important_link_5_name') }}</a></li>
                                    @endif
                                  
                                    @if(strlen(config('app_settings.important_link_6')) > 0)
                                      <li><a target="" href="{{ config('app_settings.important_link_6') }}">{{ config('app_settings.important_link_6_name') }}</a></li>
                                    @endif
                                  
                              </ul>
                          </li>

                      </ul>
                  </div>
              </div>
              <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                  <div class="footer-box">
                        <h3>Information</h3>
                        <ul class="corporate-address">
                            <li>
                                <i class="fa fa-home" aria-hidden="true"></i>
                                {{ config('app_settings.site_address') }}
                            </li>
                            <li>
                                <i class="fa fa-phone" aria-hidden="true"></i>
                                <a href="Tel:{{ config('app_settings.site_phone') }}">{{ config('app_settings.site_phone') }}</a>
                            </li>
                            <li>
                                <i class="fa fa-envelope-o" ></i>
                                {{ config('app_settings.site_email') }}
                            </li>
                        </ul>

                  </div>
              </div>
              
                  </div>
              </div>
          </div>
          <div class="footer-area-bottom">
              <div class="container">
                  <div class="row">
                      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                          <p class="text-center">&copy; {{ date('Y') }} All Rights Reserved. {{ config('app_settings.application_title') }}.
                      </div>

                  </div>
              </div>
          </div>
      </footer>
      <!-- Footer Area End Here -->
  </div>
  <!-- Main Body Area End Here -->

    <!-- Scrollable modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog ">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="exampleModalLabel">
                Search Movie: <button id="search-close" type="button" class="btn btn-xs btn-secondary" style="float: right;right: 19%;position: absolute;" data-dismiss="modal"><i class="fa fa-times"></i></button>
                <input type="text" name="live-searching" style="width: 75%;display: inline;" class="form-control" id="live-searching" >
                {{-- <button type="button btn-danger" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button> --}}
            </h>
          </div>
          <div class="modal-body">
            <div class="" style="padding-left: 2%;">
                
                 <ul class="search-output">
                </ul>    
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            {{-- <button type="button" class="btn btn-primary">Save changes</button> --}}
          </div>
        </div>
      </div>
    </div>

    <script type="text/javascript">
        var base_url = '{{ url('') }}/';
        $(document).on('keyup', '#live-searching', function(event) {
            event.preventDefault();

            var query = $(this).val();
            console.log("query", query);

            $.ajax({
              data: {query: query},
              url: "{{ route('frontent.search_movies') }}",
              type: "POST",
              dataType: "JSON",
              success: function (result) {
                  // $('#exampleModal').modal('hide');
                    var lis = '';
                    if(result.status=='success'){

                        $.each(result.data, function(index, el) {
                            
                            lis += '<li style="padding-top:6px;padding-bottom:6px;">'+
                                '<img class="search-img" src="'+el.drive_host+'/'+el.category_name+'/'+el.sub_category_title+'/'+el.video_folder_name+'/'+el.thumbnail_url+'" /> &nbsp;'+
                                        '<a href="'+base_url+'video-details/'+el.id+'"> '+ el.video_folder_name +' &raquo;</a>'+
                                    '</li>';
                        });

                        $('.search-output').html(lis);
                    }
              },
              error: function (data) {
                  console.log('Error:', data);
              }
          });

        });
    </script>

  <!-- jquery-->
    <!-- Plugins js -->
    <script src="{{url('public')}}/frontend/js/plugins.js" type="text/javascript"></script>
    <!-- Bootstrap js -->
    <script src="{{url('public')}}/frontend/js/bootstrap.min.js" type="text/javascript"></script>
    <!-- WOW JS -->
    <script src="{{url('public')}}/frontend/js/wow.min.js"></script>
    <!-- Nivo slider js -->
    <script src="{{url('public')}}/frontend/vendor/slider/js/jquery.nivo.slider.js" type="text/javascript"></script>
    <script src="{{url('public')}}/frontend/vendor/slider/home.js" type="text/javascript"></script>
    <!-- Owl Cauosel JS -->
    <script src="{{url('public')}}/frontend/vendor/OwlCarousel/owl.carousel.min.js" type="text/javascript"></script>
    <!-- Meanmenu Js -->
    <script src="{{url('public')}}/frontend/js/jquery.meanmenu.min.js" type="text/javascript"></script>
    <!-- Srollup js -->
    <script src="{{url('public')}}/frontend/js/jquery.scrollUp.min.js" type="text/javascript"></script>
    <!-- jquery.counterup js -->
    <script src="{{url('public')}}/frontend/js/jquery.counterup.min.js"></script>
    <script src="{{url('public')}}/frontend/js/waypoints.min.js"></script>
    <!-- Countdown js -->
    <script src="{{url('public')}}/frontend/js/jquery.countdown.min.js" type="text/javascript"></script>
    <!-- Isotope js -->
    <script src="{{url('public')}}/frontend/js/isotope.pkgd.min.js" type="text/javascript"></script>
    <!-- Magic Popup js -->
    <script src="{{url('public')}}/frontend/js/jquery.magnific-popup.min.js" type="text/javascript"></script>
    <!-- Gridrotator js -->
    <script src="{{url('public')}}/frontend/js/jquery.gridrotator.js" type="text/javascript"></script>
    <!-- Custom Js -->
    <script src="{{url('public')}}/frontend/js/main.js" type="text/javascript"></script>
</body>

</html>
