@extends('aceclientv.app')

@section('content_title')
    <strong> Departments</strong>
@endsection

@section('content')
<style type="text/css">
  .image{
    width: 100%;
    height: 130px;
  }
</style>
<div class="inner_body">
  <div class="content">
    <div class="row">
      <div class="col-lg-12">
        <div class="panel panel-default">
          <div class="panel-heading">
            <div class="row">
              <div class="col-sm-2">
                Department Manage
              </div>
              <div class="col-sm-6 text-right-">
                <a class="btn btn-primary btn-sm" href="javascript:void(0)" id="createNewDepartment"> Create New Department <i class="fa fa-plus"></i></a>
              </div>              
            </div>
          </div>
          <div class="panel-body">
            <div class="table-responsive">
              
              <table class="table table-stripped table-bordered data-table">
                  <thead>
                      <tr>
                          <th width="5%">SL</th>
                          <th width="10%">Department Name</th>
                          <th width="8%">Slug</th>
                          <th width="12%">Program</th>
                          <th width="30%">Image</th>
                          <th width="15%">Body</th>
                          <th width="10%">Remarks</th>
                          <th width="6%">Action</th>
                      </tr>
                  </thead>
                  <tbody>
                  </tbody>
              </table>
            </div>
          </div>
          <div class="modal fade" id="ajaxModel" aria-hidden="true">
            <div class="modal-dialog modal-lg" style="width: 80%">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modelHeading"></h4>
                    </div>
                    <div class="modal-body">
                      <form id="DepartmentForm" name="DepartmentForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                          <input type="hidden" name="Department_id" id="Department_id">
                          <div class="form-group">
                              <label for="program" class="col-sm-2 control-label">Programs</label>
                              <div class="col-sm-7">
                                  <select class="form-control chosen--" id="program_id" name="program_id" style="width: 400px">
                                      <option value="">Select Program</option>
                                      @foreach($programs as $program)
                                        <option value="{{$program->id}}">{{$program->name}}</option>
                                      @endforeach
                                  </select>
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="title" class="col-sm-2 control-label">Title</label>
                              <div class="col-sm-7">
                                  <input type="text" class="form-control" id="title" name="title" placeholder="" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="image" class="col-sm-2 control-label">Image</label>
                              <div class="col-sm-10">
                                  {{ image_input_show('image', '467px', '120px') }}
                                  <div id="image_show"></div>
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="body" class="col-sm-2 control-label">Body</label>
                              <div class="col-sm-10">
                                <textarea class="form-control" id="body" name="body"></textarea>
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="ramarks" class="col-sm-2 control-label">Ramarks</label>
                              <div class="col-sm-10">
                                <input class="form-control" id="remarks" name="remarks" placeholder="" />
                              </div>
                          </div>
                          <div class="form-group">
                              <div class="col-sm-10 col-sm-offset-2">
                                  <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Save Changes</button>
                              </div>
                          </div>
                           
                        </form>
                    </div>
                </div>
            </div>
         </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

  var base_url = '{{ url('public') }}';
  $(function () {

    // WYSIWYG Editor
    $('#body').summernote();

    var table = $('.data-table').on( 'error.dt', function ( e, settings, techNote, message ) {
      if(confirm('Please reload this page and check.')){
        location.reload();
      }
    }).DataTable({
        // dom: 'Blfrtip',
        dom: 'lfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],
        processing: true,
        serverSide: true,
        ajax: "{{ route('departments.index') }}",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'title', name: 'title'},
            {data: 'slug', name: 'slug'},
            {data: 'program_name', name: 'program_name'},
            {data: 'image', name: 'image',
                render: function( data, type, full, meta ) {
                      return '<img class="image" src="'+base_url + data +'" height="50" alt="image" >';
                  }
            },
            {data: 'body', name: 'body',
                render: function( data, type, full, meta ) {

                      return '<b>'+ $("<div/>").html(data).text().slice(0, 25) + ' ...</b>';
                  }
            },
            {data: 'remarks', name: 'remarks'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],
        drawCallback: function( settings ) {
          // console.log("drawCallback settings: ", settings);
        },
    });

    $('#createNewDepartment').click(function () {
        $('#body').summernote('code', '');
        $('#saveBtn').val("create-Department");
        $('#Department_id').val('');
        $('#image_show').html('')
        $('#DepartmentForm').trigger("reset");
        $('#modelHeading').html("Create New Department");
        $('#ajaxModel').modal('show');
    });

    $('body').on('click', '.editDepartment', function () {

      var Department_id = $(this).data('id');

      $.get("{{ route('departments.index') }}" +'/' + Department_id +'/edit', function (data) {

          $('#modelHeading').html("Edit Department");
          $('#saveBtn').val("edit-user");
          $('#ajaxModel').modal('show');
          $('#Department_id').val(data.id);
          $('#program_id').val(data.program_id);
          $('#title').val(data.title);
          $('#slug').val(data.slug);
          $('#image_show').html('<img src="'+base_url+data.image+'" style="width: 467px; height: 120px" />');

          $('#body').summernote('code', data.body);
          $('#remarks').val(data.remarks);
      })

   });

    $('#DepartmentForm').submit(function(e) {
        e.preventDefault();
        // $(this).html('Sending..');
        var form_data = new FormData(this);
        $.ajax({
          data: form_data,
          url: "{{ route('departments.store') }}",
          type: "POST",
          cache: false,
          contentType: false,
          processData: false,
          success: function (data) {
              $('#DepartmentForm').trigger("reset");
              $('#ajaxModel').modal('hide');
              table.draw();
          },
          error: function (data) {
              console.log('Error:', data);
              $('#saveBtn').html('Save Changes');
          }
      });
    });

    $('body').on('click', '.deleteDepartment', function () {

        var Department_id = $(this).data("id");
        if( ! confirm("Are You sure want to delete !") ){
          return false;
        }

        $.ajax({
            type: "DELETE",
            url: "{{ route('departments.store') }}"+'/'+Department_id,
            success: function (data) {

                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });


  });

</script>

@endsection