@extends('aceclientv.app')

@section('content_title')
    <strong> Events</strong>
@endsection

@section('content')
<style type="text/css">
  .event_image{
    width: 100%;
    height: 110px;
  }
</style>
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script> --}}
<div class="inner_body">
  <div class="content">
    <div class="row">
      <div class="col-lg-12">
        <div class="panel panel-default">
          <div class="panel-heading">
            <div class="row">
              <div class="col-sm-3">
                Event Manage
              </div>
              <div class="col-sm-6 text-right-">
                <a class="btn btn-primary btn-sm" href="javascript:void(0)" id="createNewEvent"> Create New Event <i class="fa fa-plus"></i></a>
              </div>              
            </div>
          </div>
          <div class="panel-body">
            <div class="table-responsive">
              
              <table class="table table-stripped table-bordered data-table">
                  <thead>
                      <tr>
                          <th width="5%">No</th>
                          <th width="17%">Name</th>
                          <th>Image</th>
                          <th>Description</th>
                          <th width="14%">Action</th>
                      </tr>
                  </thead>
                  <tbody>
                  </tbody>
              </table>
            </div>
          </div>
          <div class="modal fade" id="ajaxModel" aria-hidden="true">
            <div class="modal-dialog modal-lg" style="width: 75%">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modelHeading"></h4>
                    </div>
                    <div class="modal-body">
                      <form id="EventForm" name="EventForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                          <input type="hidden" name="event_id" id="event_id">
                          <div class="form-group">
                              <label for="name" class="col-sm-2 control-label">Name</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="name" name="name" placeholder="Enter name" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="image" class="col-sm-2 control-label">Image</label>
                              <div class="col-sm-10">
                                  {{ image_input_show('image', '200px', '200px') }}
                                  <div id="image_show"></div>
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="description" class="col-sm-2 control-label">Description</label>
                              <div class="col-sm-10">
                                  <textarea class="form-control" id="description" name="description" ></textarea>
                              </div>
                          </div>
                          <div class="form-group">
                              <div class="col-sm-10 col-sm-offset-2">
                                  <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Save Changes</button>
                              </div>
                          </div>
                           
                        </form>
                    </div>
                </div>
            </div>
         </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

  function getBase64Image(img) {
    var canvas = document.createElement("canvas");
    canvas.width = img.width;
    canvas.height = img.height;
    var ctx = canvas.getContext("2d");
    ctx.drawImage(img, 0, 0);
    var dataURL = canvas.toDataURL("image/png");
    return dataURL;
    // return dataURL.replace(/^data:image\/(png|jpg);base64,/, "");
  }

  var base_url = '{{ url('public') }}';
  $(function () {

    $('#description').summernote();

    var table = $('.data-table').on( 'error.dt', function ( e, settings, techNote, message ) {
      if(confirm('Please reload this page and check.')){
        location.reload();
      }
    }).DataTable({
        
        // dom: 'Blfrtip',
        dom: 'lfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],

        processing: true,
        serverSide: true,
        ajax: "{{ route('events.index') }}",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name: 'name'},
            {data: 'image', name: 'image',
                render: function( data, type, full, meta ) {
                      return '<img class="image" src="'+base_url + data +'" height="100" alt="image" >';
                  }
            },
            {data: 'description', name: 'description',
                render: function( data, type, full, meta ) {
                    return $("<div/>").html(data).text().slice(0, 165) + ' ...';
                }
            },
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],

        drawCallback: function( settings ) {
          
            $(document).find('.image').each(function(index, el) {
                
                var base64 = getBase64Image(el);
                // $(el).attr('src', base64);
              
            });
        },
    });

    $('#createNewEvent').click(function () {
        $('#saveBtn').val("create-Event");
        $('#event_id').val('');
        $('#image_show').html('')
        $('#EventForm').trigger("reset");
        $('#modelHeading').html("Create New Event");
        $('#ajaxModel').modal('show');
        $('#description').summernote('code', '');
    });

    $('body').on('click', '.editEvent', function () {

      var event_id = $(this).data('id');

      $.get("{{ route('events.index') }}" +'/' + event_id +'/edit', function (data) {

          $('#modelHeading').html("Edit Event");

          $('#saveBtn').val("edit-user");

          $('#ajaxModel').modal('show');

          $('#event_id').val(data.id);

          $('#name').val(data.name);

          $('#image_show').html('<img src="'+base_url+data.image+'" style="width: 350px; height: 200px" />');

          $('#description').summernote('code', data.description);
      })

   });

    $('#EventForm').submit(function(e) {
        e.preventDefault();

        var form_data = new FormData(this);

        $.ajax({

          data: form_data,
          url: "{{ route('events.store') }}",
          type: "POST",
          cache: false,
          contentType: false,
          processData: false,

          success: function (data) {

              $('#EventForm').trigger("reset");
              $('#ajaxModel').modal('hide');
              table.draw();
          },
          error: function (data) {
              console.log('Error:', data);
              $('#saveBtn').html('Save Changes');
          }
      });
    });

    $('body').on('click', '.deleteEvent', function () {

        var event_id = $(this).data("id");
        if( ! confirm("Are You sure want to delete !") ){
          return false;
        }

        $.ajax({
            type: "DELETE",
            url: "{{ route('events.store') }}"+'/'+event_id,
            success: function (data) {

                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });


  });

</script>

@endsection