@extends('aceclientv.app')

@section('content_title')
    <strong> Files Auto Listing</strong>
@endsection

@section('content')
    <style type="text/css">
        .notifyjs-container {
            
        }
        #ProgramForm input, #ProgramForm select {
            width: 60%;
        }

    </style>

    <div class="inner_body">
        <div class="content">
            <div class="row">
                <div class="col-lg-10">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row">
                                <div class="col-sm-2">
                                    Files Auto Listing
                                </div>
                            </div>
                        </div>
                        <div class="panel-body">
                            <form id="ProgramForm" name="ProgramForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                                <div class="form-group">
                                    <label for="file_type" class="col-sm-2 control-label">Drive Letter: </label>
                                    <div class="col-sm-10">
                                        <select class="form-control" id="file_type" name="file_type" required="">
                                            <option value="">Select</option>
                                            <option value="video">Video</option>
                                            <option value="software">Software(softwares, games etc.)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="drive_letter" class="col-sm-2 control-label">Drive Letter: </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="drive_letter" name="drive_letter" placeholder="Enter drive letter" >
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="drive_host" class="col-sm-2 control-label">Drive Host IP: </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="drive_host" name="drive_host" placeholder="Enter drive host" >
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="col-sm-10 col-sm-offset-2">
                                        <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Sync Files</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="modal fade" id="ajaxModel" aria-hidden="true">
                            <div class="modal-dialog modal-lg-" style="width-: 85%">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title" id="modelHeading"></h4>
                                    </div>
                                    <div class="modal-body">
                                        <form id="ProgramForm" name="ProgramForm" class="form-horizontal" method="POST"
                                            action="" enctype="multipart/form-data">
                                            <input type="hidden" name="Program_id" id="Program_id">
                                            <div class="form-group">
                                                <label for="name" class="col-sm-2 control-label">Program Name</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" id="name" name="name"
                                                        placeholder="">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="description"
                                                    class="col-sm-2 control-label">Description<br />(optional)</label>
                                                <div class="col-sm-10">
                                                    <textarea class="form-control" id="description"
                                                        name="description"></textarea>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-sm-10 col-sm-offset-2">
                                                    <button type="submit" class="btn btn-primary" id="saveBtn"
                                                        value="create">Save Changes</button>
                                                </div>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var base_url = '{{ url('public') }}';
        $(function() {

            $('#ProgramForm').submit(function(e) {
                e.preventDefault();
                // $(this).html('Sending..');
                var form_data = $(this).serialize();
                // console.log(form_data);return false;
                $.ajax({
                    data: form_data,
                    url: "{{ route('files_auto_listing_run') }}",
                    type: "POST",
                    success: function(result) {
                        console.log(result);
                        $.notify(result.message, result.status);
                        // $.notify({message: result.message}, {type: result.status, maxWidth: '50%', allow_dismiss: true,});
                        // alert(result.message);
                    },
                    error: function(result) {
                        console.log('Error:', result);
                    }
                });
            });

        });
    </script>

@endsection
{{-- <div style="top: 0px; right: 0px;" class="notifyjs-corner">
    <div class="notifyjs-wrapper notifyjs-hidable">
        <div class="notifyjs-arrow" style=""></div>
        <div class="notifyjs-container" style="">
            <div class="notifyjs-bootstrap-base notifyjs-bootstrap-error">
                <span data-notify-text=""></span>
            </div>
        </div>
    </div>
</div> --}}
