@extends('aceclientv.app')

@section('content_title')
    <strong> Galleries</strong>
@endsection

@section('content')
<style type="text/css">
  .gallery_image{
    width: 100%;
    height: 110px;
  }
</style>
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script> --}}
<div class="inner_body">
  <div class="content">
    <div class="row">
      <div class="col-lg-12">
        <div class="panel panel-default">
          <div class="panel-heading">
            <div class="row">
              <div class="col-sm-2">
                Gallery Manage
              </div>
              <div class="col-sm-6 text-right-">
                <a class="btn btn-primary btn-sm" href="javascript:void(0)" id="createNewGallery"> Create New Gallery <i class="fa fa-plus"></i></a>
              </div>              
            </div>
          </div>
          <div class="panel-body">
            <div class="table-responsive">
              
              <table class="table table-stripped table-bordered data-table">
                  <thead>
                      <tr>
                          <th width="5%">No</th>
                          <th width="20%">Image</th>
                          <th>Title</th>
                          <th>Description</th>
                          <th>Link</th>
                          <th width="12%">Action</th>
                      </tr>
                  </thead>
                  <tbody>
                  </tbody>
              </table>
            </div>
          </div>
          <div class="modal fade" id="ajaxModel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modelHeading"></h4>
                    </div>
                    <div class="modal-body">
                      <form id="GalleryForm" name="GalleryForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                          <input type="hidden" name="Gallery_id" id="Gallery_id">
                          <div class="form-group">
                              <label for="gallery_image" class="col-sm-2 control-label">Image</label>
                              <div class="col-sm-10">
                                  {{ image_input_show('gallery_image', '200px', '200px') }}
                                  <div id="gallery_image_show"></div>
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="title" class="col-sm-2 control-label">Title</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="description" class="col-sm-2 control-label">Description</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="description" name="description" placeholder="Enter description" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="link" class="col-sm-2 control-label">Link(optional)</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="link" name="link" placeholder="Enter link" value="" />
                              </div>
                          </div>
                          <div class="form-group">
                              <div class="col-sm-10 col-sm-offset-2">
                                  <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Save Changes</button>
                              </div>
                          </div>
                           
                        </form>
                    </div>
                </div>
            </div>
         </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

  function getBase64Image(img) {
    var canvas = document.createElement("canvas");
    canvas.width = img.width;
    canvas.height = img.height;
    var ctx = canvas.getContext("2d");
    ctx.drawImage(img, 0, 0);
    var dataURL = canvas.toDataURL("image/png");
    return dataURL;
    // return dataURL.replace(/^data:image\/(png|jpg);base64,/, "");
  }

  var base_url = '{{ url('public') }}';
  $(function () {

    var table = $('.data-table').on( 'error.dt', function ( e, settings, techNote, message ) {
      if(confirm('Please reload this page and check.')){
        location.reload();
      }
    }).DataTable({
        
        // dom: 'Blfrtip',
        dom: 'lfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],

        processing: true,
        serverSide: true,
        ajax: "{{ route('galleries.index') }}",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'gallery_image', name: 'gallery_image',
                render: function( data, type, full, meta ) {
                      return '<img class="gallery_image" src="'+base_url + data +'" height="50" alt="image" >';
                  }
            },
            {data: 'title', name: 'title'},
            {data: 'description', name: 'description'},
            {data: 'link', name: 'link'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],

        drawCallback: function( settings ) {
          
            $(document).find('.gallery_image').each(function(index, el) {
                
                var base64 = getBase64Image(el);
                // $(el).attr('src', base64);
              
            });
        },
    });

    $('#createNewGallery').click(function () {
        $('#saveBtn').val("create-Gallery");
        $('#Gallery_id').val('');
        $('#gallery_image_show').html('')
        $('#GalleryForm').trigger("reset");
        $('#modelHeading').html("Create New Gallery");
        $('#ajaxModel').modal('show');
    });

    $('body').on('click', '.editGallery', function () {

      var Gallery_id = $(this).data('id');

      $.get("{{ route('galleries.index') }}" +'/' + Gallery_id +'/edit', function (data) {

          $('#modelHeading').html("Edit Gallery");

          $('#saveBtn').val("edit-user");

          $('#ajaxModel').modal('show');

          $('#Gallery_id').val(data.id);

          $('#title').val(data.title);

          $('#gallery_image_show').html('<img src="'+base_url+data.gallery_image+'" style="width: 200px; height: 200px" />');

          $('#description').val(data.description);
          $('#link').val(data.link);
      })

   });

    $('#GalleryForm').submit(function(e) {
        e.preventDefault();
        // $(this).html('Sending..');

        var form_data = new FormData(this);
        // console.log("form_data", form_data);return false;

        $.ajax({

          data: form_data,
          url: "{{ route('galleries.store') }}",
          type: "POST",
          cache: false,
          contentType: false,
          processData: false,

          success: function (data) {

              $('#GalleryForm').trigger("reset");
              $('#ajaxModel').modal('hide');
              table.draw();
          },
          error: function (data) {
              console.log('Error:', data);
              $('#saveBtn').html('Save Changes');
          }
      });
    });

    $('body').on('click', '.deleteGallery', function () {

        var Gallery_id = $(this).data("id");
        if( ! confirm("Are You sure want to delete !") ){
          return false;
        }

        $.ajax({
            type: "DELETE",
            url: "{{ route('galleries.store') }}"+'/'+Gallery_id,
            success: function (data) {

                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });


  });

</script>

@endsection