@extends('aceclientv.app')

@section('content_title')
    <strong> Notices</strong>
@endsection

@section('content')
<style type="text/css">
  .notice_file{
    width: 100%;
    height: 110px;
  }
</style>
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script> --}}
<div class="inner_body">
  <div class="content">
    <div class="row">
      <div class="col-lg-12">
        <div class="panel panel-default">
          <div class="panel-heading">
            <div class="row">
              <div class="col-sm-2">
                Notice Manage
              </div>
              <div class="col-sm-6 text-right-">
                <a class="btn btn-primary btn-sm" href="javascript:void(0)" id="createNewNotice"> Create New Notice <i class="fa fa-plus"></i></a>
              </div>              
            </div>
          </div>
          <div class="panel-body">
            <div class="table-responsive">
              
              <table class="table table-stripped table-bordered data-table">
                  <thead>
                      <tr>
                          <th width="5%">No</th>
                          <th width="20%">File</th>
                          <th>Title</th>
                          <th>Description</th>
                          <th width="12%">Action</th>
                      </tr>
                  </thead>
                  <tbody>
                  </tbody>
              </table>
            </div>
          </div>
          <div class="modal fade" id="ajaxModel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modelHeading"></h4>
                    </div>
                    <div class="modal-body">
                      <form id="NoticeForm" name="NoticeForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                          <input type="hidden" name="Notice_id" id="Notice_id">
                          <div class="form-group">
                              <label for="notice_file" class="col-sm-2 control-label">File</label>
                              <div class="col-sm-10">
                                  <input type="file" class="form-control" id="notice_file" name="notice_file" placeholder="Enter Title" accept=".txt, .pdf, .xls, docx, .xlsx, .doc, .png, .jpg, .jpeg" />
                                  <span>.pdf, .xls, docx, .xlsx, .doc, .png, .jpg, .jpeg</span>
                                  <div id="notice_file_show"></div>
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="title" class="col-sm-2 control-label">Title</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="description" class="col-sm-2 control-label">Description</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="description" name="description" placeholder="Enter description" >
                              </div>
                          </div>
                          <div class="form-group">
                              <div class="col-sm-10 col-sm-offset-2">
                                  <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Save Changes</button>
                              </div>
                          </div>
                           
                        </form>
                    </div>
                </div>
            </div>
         </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

  var base_url = '{{ url('public') }}';
  $(function () {

    var table = $('.data-table').on( 'error.dt', function ( e, settings, techNote, message ) {
      if(confirm('Please reload this page and check.')){
        location.reload();
      }
    }).DataTable({
        
        // dom: 'Blfrtip',
        dom: 'lfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],

        processing: true,
        serverSide: true,
        ajax: "{{ route('notices.index') }}",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'notice_file', name: 'notice_file',
                render: function( data, type, full, meta ) {
                      return '<b><a class="" target="_blank" href="'+base_url + data +'" >'+full.title+' &raquo;</a></b>';
                  }
            },
            {data: 'title', name: 'title'},
            {data: 'description', name: 'description'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],
    });

    $('#createNewNotice').click(function () {
        $('#saveBtn').val("create-Notice");
        $('#Notice_id').val('');
        $('#notice_file_show').html('')
        $('#NoticeForm').trigger("reset");
        $('#modelHeading').html("Create New Notice");
        $('#ajaxModel').modal('show');
    });

    $('body').on('click', '.editNotice', function () {

      var Notice_id = $(this).data('id');

      $.get("{{ route('notices.index') }}" +'/' + Notice_id +'/edit', function (data) {

          $('#modelHeading').html("Edit Notice");

          $('#saveBtn').val("edit-user");

          $('#ajaxModel').modal('show');

          $('#Notice_id').val(data.id);

          $('#title').val(data.title);

          $('#notice_file_show').html('<h4>'+data.notice_file.replace('/upload/notice_file/', '')+'</h4>');

          $('#description').val(data.description);
      })

   });

    $('#NoticeForm').submit(function(e) {
        e.preventDefault();
        // $(this).html('Sending..');

        var form_data = new FormData(this);
        // console.log("form_data", form_data);return false;

        $.ajax({

          data: form_data,
          url: "{{ route('notices.store') }}",
          type: "POST",
          cache: false,
          contentType: false,
          processData: false,

          success: function (data) {

              $('#NoticeForm').trigger("reset");
              $('#ajaxModel').modal('hide');
              table.draw();
          },
          error: function (data) {
              console.log('Error:', data);
              if( data.status === 422 ) {
                  var response = JSON.parse( data.responseText );
                  // $.notify(response['message'], 'error');
                  var errors = response['errors'];
                  $.each(errors, function (key, val) {
                      $.notify(val[0], 'error');
                  });
              }
              $('#saveBtn').html('Save Changes');
          }
      });
    });

    $('body').on('click', '.deleteNotice', function () {

        var Notice_id = $(this).data("id");
        if( ! confirm("Are You sure want to delete !") ){
          return false;
        }

        $.ajax({
            type: "DELETE",
            url: "{{ route('notices.store') }}"+'/'+Notice_id,
            success: function (data) {

                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });


  });

</script>

@endsection