@extends('aceclientv.app')

@section('content_title')
    <strong> Programs</strong>
@endsection

@section('content')

<div class="inner_body">
  <div class="content">
    <div class="row">
      <div class="col-lg-12">
        <div class="panel panel-default">
          <div class="panel-heading">
            <div class="row">
              <div class="col-sm-2">
                Program Manage
              </div>
              <div class="col-sm-6 text-right-">
                <a class="btn btn-primary btn-sm" href="javascript:void(0)" id="createNewProgram"> Create New Program <i class="fa fa-plus"></i></a>
              </div>              
            </div>
          </div>
          <div class="panel-body">
            <div class="table-responsive">
              
              <table class="table table-stripped table-bordered data-table">
                  <thead>
                      <tr>
                          <th width="5%">SL</th>
                          <th width="%">Program Name</th>
                          <th>Slug</th>
                          <th>Description</th>
                          <th width="%">Action</th>
                      </tr>
                  </thead>
                  <tbody>
                  </tbody>
              </table>
            </div>
          </div>
          <div class="modal fade" id="ajaxModel" aria-hidden="true">
            <div class="modal-dialog modal-lg-" style="width-: 85%">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modelHeading"></h4>
                    </div>
                    <div class="modal-body">
                      <form id="ProgramForm" name="ProgramForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                          <input type="hidden" name="Program_id" id="Program_id">
                          <div class="form-group">
                              <label for="name" class="col-sm-2 control-label">Program Name</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="name" name="name" placeholder="" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="description" class="col-sm-2 control-label">Description<br />(optional)</label>
                              <div class="col-sm-10">
                                <textarea class="form-control" id="description" name="description"></textarea>
                              </div>
                          </div>
                          <div class="form-group">
                              <div class="col-sm-10 col-sm-offset-2">
                                  <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Save Changes</button>
                              </div>
                          </div>
                           
                        </form>
                    </div>
                </div>
            </div>
         </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

  var base_url = '{{ url('public') }}';
  $(function () {

    // wysiwyg editor
    // $('#description').summernote();

    var table = $('.data-table').on( 'error.dt', function ( e, settings, techNote, message ) {
      if(confirm('Please reload this page and check.')){
        location.reload();
      }
    }).DataTable({
        
        // dom: 'Blfrtip',
        dom: 'lfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],

        processing: true,
        serverSide: true,
        ajax: "{{ route('programs.index') }}",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name: 'name'},
            {data: 'slug', name: 'slug'},
            {data: 'description', name: 'description'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],
        drawCallback: function( settings ) {},
    });

    $('#createNewProgram').click(function () {
        $('#saveBtn').val("create-Program");
        $('#Program_id').val('');
        $('#program_image_show').html('')
        $('#ProgramForm').trigger("reset");
        $('#modelHeading').html("Create New Program");
        $('#ajaxModel').modal('show');
    });

    $('body').on('click', '.editProgram', function () {

      var Program_id = $(this).data('id');

      $.get("{{ route('programs.index') }}" +'/' + Program_id +'/edit', function (data) {

          $('#modelHeading').html("Edit Program");
          $('#saveBtn').val("edit-user");
          $('#ajaxModel').modal('show');
          $('#Program_id').val(data.id);
          $('#name').val(data.name);
          $('#description').text(data.description);
      })

   });

    $('#ProgramForm').submit(function(e) {
        e.preventDefault();
        // $(this).html('Sending..');
        var form_data = new FormData(this);
        $.ajax({
          data: form_data,
          url: "{{ route('programs.store') }}",
          type: "POST",
          cache: false,
          contentType: false,
          processData: false,
          success: function (data) {
              $('#ProgramForm').trigger("reset");
              $('#ajaxModel').modal('hide');
              table.draw();
          },
          error: function (data) {
              console.log('Error:', data);
              $('#saveBtn').html('Save Changes');
          }
      });
    });

    $('body').on('click', '.deleteProgram', function () {

        var Program_id = $(this).data("id");
        if( ! confirm("Are You sure want to delete !") ){
          return false;
        }

        $.ajax({
            type: "DELETE",
            url: "{{ route('programs.store') }}"+'/'+Program_id,
            success: function (data) {

                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });


  });

</script>

@endsection