@extends('aceclientv.app')

@section('content_title')
    <strong> Sliders</strong>
@endsection

@section('content')
<style type="text/css">
  .slider_image{
    width: 100%;
    height: 130px;
  }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
<div class="inner_body">
  <div class="content">
    <div class="row">
      <div class="col-lg-12">
        <div class="panel panel-default">
          <div class="panel-heading">
            <div class="row">
              <div class="col-sm-2">
                Slider Manage
              </div>
              <div class="col-sm-6 text-right-">
                <a class="btn btn-primary btn-sm" href="javascript:void(0)" id="createNewSlider"> Create New Slider <i class="fa fa-plus"></i></a>
              </div>              
            </div>
          </div>
          <div class="panel-body">
            <div class="table-responsive">
              
              <table class="table table-stripped table-bordered data-table">
                  <thead>
                      <tr>
                          <th width="5%">No</th>
                          <th width="50%">Image</th>
                          <th>Title</th>
                          <th>Description</th>
                          <th>Link</th>
                          <th width="12%">Action</th>
                      </tr>
                  </thead>
                  <tbody>
                  </tbody>
              </table>
            </div>
          </div>
          <div class="modal fade" id="ajaxModel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modelHeading"></h4>
                    </div>
                    <div class="modal-body">
                      <form id="SliderForm" name="SliderForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                          <input type="hidden" name="Slider_id" id="Slider_id">
                          <div class="form-group">
                              <label for="slider_image" class="col-sm-2 control-label">Image</label>
                              <div class="col-sm-10">
                                  {{ image_input_show('slider_image', '467px', '120px') }}
                                  <div id="slider_image_show"></div>
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="title" class="col-sm-2 control-label">Title</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="description" class="col-sm-2 control-label">Description</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="description" name="description" placeholder="Enter description" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="link" class="col-sm-2 control-label">Link</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="link" name="link" placeholder="Enter link" value="" />
                              </div>
                          </div>
                          <div class="form-group">
                              <div class="col-sm-10 col-sm-offset-2">
                                  <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Save Changes</button>
                              </div>
                          </div>
                           
                        </form>
                    </div>
                </div>
            </div>
         </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

  function getBase64Image(img) {
    var canvas = document.createElement("canvas");
    canvas.width = img.width;
    canvas.height = img.height;
    var ctx = canvas.getContext("2d");
    ctx.drawImage(img, 0, 0);
    var dataURL = canvas.toDataURL("image/png");
    return dataURL;
    // return dataURL.replace(/^data:image\/(png|jpg);base64,/, "");
  }

  var base_url = '{{ url('public') }}';
  $(function () {

    var table = $('.data-table').on( 'error.dt', function ( e, settings, techNote, message ) {
      if(confirm('Please reload this page and check.')){
        location.reload();
      }
    }).DataTable({
        
        // dom: 'Blfrtip',
        dom: 'lfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],

        processing: true,
        serverSide: true,
        ajax: "{{ route('sliders.index') }}",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'slider_image', name: 'slider_image',
                render: function( data, type, full, meta ) {
                      return '<img class="slider_image" src="'+base_url + data +'" height="50" alt="image" >';
                  }
            },
            {data: 'title', name: 'title'},
            {data: 'description', name: 'description'},
            {data: 'link', name: 'link'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],

        drawCallback: function( settings ) {
          
            $(document).find('.slider_image').each(function(index, el) {
                
                var base64 = getBase64Image(el);
                // $(el).attr('src', base64);
              
            });
        },
    });

    $('#createNewSlider').click(function () {
        $('#saveBtn').val("create-Slider");
        $('#Slider_id').val('');
        $('#slider_image_show').html('')
        $('#SliderForm').trigger("reset");
        $('#modelHeading').html("Create New Slider");
        $('#ajaxModel').modal('show');
    });

    $('body').on('click', '.editSlider', function () {

      var Slider_id = $(this).data('id');

      $.get("{{ route('sliders.index') }}" +'/' + Slider_id +'/edit', function (data) {

          $('#modelHeading').html("Edit Slider");

          $('#saveBtn').val("edit-user");

          $('#ajaxModel').modal('show');

          $('#Slider_id').val(data.id);

          $('#title').val(data.title);

          $('#slider_image_show').html('<img src="'+base_url+data.slider_image+'" style="width: 467px; height: 120px" />');

          $('#description').val(data.description);
          $('#link').val(data.link);
      })

   });

    $('#SliderForm').submit(function(e) {
        e.preventDefault();
        // $(this).html('Sending..');

        var form_data = new FormData(this);
        // console.log("form_data", form_data);return false;

        $.ajax({

          data: form_data,
          url: "{{ route('sliders.store') }}",
          type: "POST",
          cache: false,
          contentType: false,
          processData: false,

          success: function (data) {

              $('#SliderForm').trigger("reset");
              $('#ajaxModel').modal('hide');
              table.draw();
          },
          error: function (data) {
              console.log('Error:', data);
              $('#saveBtn').html('Save Changes');
          }
      });
    });

    $('body').on('click', '.deleteSlider', function () {

        var Slider_id = $(this).data("id");
        if( ! confirm("Are You sure want to delete !") ){
          return false;
        }

        $.ajax({
            type: "DELETE",
            url: "{{ route('sliders.store') }}"+'/'+Slider_id,
            success: function (data) {

                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });


  });

</script>

@endsection