@extends('acewebv.app')
@section('head_title') @endsection
@section('content_title')@endsection
@section('content')

<style type="text/css">
    .embed-responsive-item {
        background-color: black;
    }
    .lecturers-area {
        padding: 30px 0 30px;
    }
    .lecturers-area .single-item {
        background: #beb; padding: 15px 8px 15px 8px;
        margin-right: 2%;
        margin-bottom: 5%;
        min-height: 309px;
    }
    .single-item {
        min-height: 309px;
    }
    .lecturers-content-wrapper{
        padding-top: 3px;
    }
    .lecturers-content-wrapper .item-designation{
        margin-bottom: 2px;
    }
    .title-default-left{
        margin-bottom: 20px;
    }
    .owl-controls .owl-nav {
        top: -65px;
    }

    .carousel-caption h4 {
        color: whitesmoke;
    }
    .lecturers-area .col-lg-2 {
        /*width: 14%;*/
    }

    .movie-thumb{
        height: 223px;
        padding-left: 7%;
        display: inline-block;
        min-height: 223px;
    }
    @media screen and (max-width: 480px) {
        .movie-thumb {
            display: block;
            width: auto !important;
            margin: 0 auto;
            padding-top: 1%;
            border-radius: 5px;
            padding-left: 0%;
        }
    }
</style>

<!-- softwares Area Starts Here -->
<div class="lecturers-area">
    <div class="container">
        <h3 class="title-default-left">{{ ucfirst( request('category_slug') ) }}</h3>
        @if(request('search'))
            <p>Search result showing for "{{ request('search') }}":</p>
        @endif
    </div>
    <div class="container">
        {{-- <div class="row"> --}}

            {{-- @for ($i=0; $i<=5; $i++) --}}

            @foreach ($softwares as $key=>$value)

                <div class="col-lg-2 single-item">
                    <div class="card">
                        {{-- <div id="trailer" class="section d-flex justify-content-center embed-responsive embed-responsive-16by9">
                            <video  height="340" class="embed-responsive-item" controls >
                                <source src="{{ $value->drive_host.'/'.$value->category_name.'/'.$value->sub_category_title.'/'.$value->video_folder_name.'/'.$value->video_url }}" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                        </div> --}}

                        <a href="{{ url('software-details/'.$value->id) }}">
                            <img class="movie-thumb" alt="Thumbnail" src="{{ $value->drive_host.'/'.$value->category_name.'/'.$value->sub_category_title.'/'.$value->video_folder_name.'/'.$value->thumbnail_url }}">
                        </a>
                        <div class="card-body" />
                            <div class="lecturers-content-wrapper">
                                <h3 class="item-title"><a title="{{ $value->video_folder_name }}" href="{{ url('software-details/'.$value->id) }}">{{ substr($value->video_folder_name, 0, 11) }}</a></h3>

                                <span class="item-designation">
                                    ({{ $value->year }})
                                    <a href="{{ url('software-details/'.$value->id) }}" class="btn btn-xs btn-primary">
                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                    </a>
                                    <a target="_blank" href="{{ url('download-file/'.$value->id) }}" class="btn btn-xs btn-primary">
                                        <i class="fa fa-download" aria-hidden="true"></i>
                                    </a>
                                </span>
                                
                            </div>
                        </div>
                    </div>
                </div>

            @endforeach

            {{-- @endfor --}}

        {{-- </div> --}}

        {{ $softwares->appends( request()->query() )->links() }}

    </div>
</div>
<!--  Softwares Area Ends Here -->

@endsection
