@extends('acewebv.app')
{{-- @extends('layouts.member.app') --}}

@section('content')
<div class="row justify-content-center">
    <div class="col-md-7">
        <div class="panel">
            <div class="panel-heading">Forgot Password Reset</div>
            <div class="panel-body">

                @if (session()->has('success'))
                    <div class="row justify-content-center">
                        <div class="col-md-12">
                            <div class="alert alert-success alert-dismissible">
                              <a href="#" class="close" data-dismiss="alert" aria-label="close" style="color: black !important;">×</a>
                              {!! session()->get("success") !!}
                            </div>
                        </div>
                    </div>
                @endif
                @if (session()->has('error'))
                    <div class="row justify-content-center">
                        <div class="col-md-12">
                            <div class="alert alert-danger alert-dismissible">
                              <a href="#" class="close" data-dismiss="alert" aria-label="close" style="color: black !important;">×</a>
                              {!! session()->get("error") !!}
                            </div>
                        </div>
                    </div>
                @endif

                <form method="POST" action="{{ route('frontend.forgot-password') }}">
                    @csrf
                    <div class="form-group row">
                        <label for="email" class="col-md-3 col-form-label text-md-right">{{ __('E-Mail Address') }}</label>

                        <div class="col-md-6">
                            <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required>

                            @if ($errors->has('email'))
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="form-group row">

                        <div class="col-md-6 col-md-offset-3">
                            <button type="submit" class="btn btn-primary">
                                {{ __('Send Password Reset Link') }}
                            </button>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-md-6 col-md-offset-3">
                            <button class="btn btn-link" id="login-link" style="cursor: ;">
                                {{ __('Login ') }}&raquo;
                            </button>
                        </div>
                    </div>

                </form>

                <script type="text/javascript">
                    $(document).ready(function() {
                        
                        $('#login-link').click(function(event) {
                            event.preventDefault();

                            location.href = '{{ url('/') }}'+'/member/login';
                        });
                        

                    });
                </script>
            </div>
        </div>
    </div>
</div>
@endsection
