@extends('acewebv.app')
{{-- @extends('layouts.member.app') --}}

@section('content')
<div class="row justify-content-center">
    <div class="col-md-7">
        <div class="panel">
            <div class="panel-heading">Forgot Password Reset</div>
            <div class="panel-body">

                @if (session()->has('success'))
                    <div class="row justify-content-center">
                        <div class="col-md-12">
                            <div class="alert alert-success alert-dismissible">
                              <a href="#" class="close" data-dismiss="alert" aria-label="close" style="color: black !important;">×</a>
                              {!! session()->get("success") !!}
                            </div>
                        </div>
                    </div>
                @endif
                @if (session()->has('error'))
                    <div class="row justify-content-center">
                        <div class="col-md-12">
                            <div class="alert alert-danger alert-dismissible">
                              <a href="#" class="close" data-dismiss="alert" aria-label="close" style="color: black !important;">×</a>
                              {!! session()->get("error") !!}
                            </div>
                        </div>
                    </div>
                @endif

                <form method="POST" action="{{ route('frontend.password-reset', $extra_remember_token) }}">
                    @csrf
                    <div class="form-group row">
                        <label for="password" class="col-md-3 col-form-label text-md-right">{{ __('New Password') }}</label>

                        <div class="col-md-6">
                            <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required>

                            @if ($errors->has('password'))
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="password-confirm" class="col-md-3 col-form-label text-md-right">{{ __('Confirm Password') }}</label>

                        <div class="col-md-6">
                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required>
                        </div>
                    </div>

                    <div class="form-group row">

                        <div class="col-md-6 col-md-offset-3">
                            <button type="submit" class="btn btn-primary">
                                {{ __('Save New Password') }}
                            </button>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-md-6 col-md-offset-3">
                            <button class="btn btn-link" id="login-link" style="cursor: ;">
                                {{ __('Login ') }}&raquo;
                            </button>
                        </div>
                    </div>

                </form>

                <script type="text/javascript">
                    $(document).ready(function() {
                        
                        $('#login-link').click(function(event) {
                            event.preventDefault();

                            location.href = '{{ url('/') }}'+'/member/login';
                        });
                        

                    });
                </script>
            </div>
        </div>
    </div>
</div>
@endsection
