@extends('aceclientv.app')

@section('content_title')
    <strong> Profile Edit</strong>
@endsection

@section('content')

    <div class="container">

        @if (Session::has('message'))
            <div class="row">
                <div class="col-md-6 col-md-offset-2 alert alert-info">
                    <button type="button" class="close" data-dismiss="alert">
                        <i class="ace-icon fa fa-times"></i>
                    </button>
                    {{ Session::get('message') }}
                </div>
            </div>
        @endif
        @if ($errors->any())
            <div class="row">
                <div class="alert alert-danger col-md-6 col-md-offset-2">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endif
        @php
            $auth_user = \Auth::user();
        @endphp
        <div class="row">
            <form method="post" class="form-horizontal" action="{{ route('users.update', $user->id) }}"
                enctype="multipart/form-data">
                <div class="form-group">
                    {{ csrf_field() }}
                    {{ method_field('patch') }}
                    <label for="lgFormGroupInput"
                        class="col-sm-2 col-form-label col-form-label-lg control-label">Name:</label>
                    <div class="col-sm-6">
                        <input type="text" name="name" class="form-control form-control-lg" value="{{ $user->name }}" />
                    </div>
                </div>
                <div class="form-group">
                    <label for="lgFormGroupInput"
                        class="col-sm-2 col-form-label col-form-label-lg control-label">Email:</label>
                    <div class="col-sm-6">
                        <input type="email" class="form-control form-control-lg" name="email" value="{{ $user->email }}">
                    </div>
                </div>
                <div class="form-group">
                    <label for="lgFormGroupInput"
                        class="col-sm-2 col-form-label col-form-label-lg control-label">Phone:</label>
                    <div class="col-sm-6">
                        <input type="phone" class="form-control form-control-lg" name="phone" value="{{ $user->phone }}">
                    </div>
                </div>
                <div class="form-group">
                    <label for="lgFormGroupInput"
                        class="col-sm-2 col-form-label col-form-label-lg control-label">Password:</label>
                    <div class="col-sm-6">
                        <input type="password" class="form-control form-control-lg" name="password" value="">
                    </div>
                </div>
                <div class="form-group">
                    <label for="lgFormGroupInput" class="col-sm-2 col-form-label col-form-label-lg control-label">Confirm
                        Password:</label>
                    <div class="col-sm-6">
                        <input type="password" class="form-control form-control-lg" name="password_confirmation" value="">
                    </div>
                </div>

                @if ($auth_user->type == 'admin')

                    <div class="form-group">
                        <label class="col-sm-2 col-form-label col-form-label-lg control-label">.</label>
                        <div class="col-sm-2">
                            <div class="radio">
                                <label><input type="radio" {{ $user->active == 1 ? 'checked' : '' }} value="1" name="active">
                                    Active</label>
                                <label><input type="radio" {{ $user->active == 0 ? 'checked' : '' }} value="0" name="active"> In
                                    Active</label>
                            </div>
                        </div>
                    </div>

                @endif

                <div class="form-group">

                    <label class="col-sm-2 col-form-label col-form-label-lg control-label">Photo:</label>
                    <div class="col-sm-6">
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <div class="fileinput-new img-thumbnail" style="width: 200px; height: 200px;">
                                <img src="{{ url('public') . '/' . $user->image }}" alt="...">
                            </div>
                            <div class="fileinput-preview fileinput-exists img-thumbnail"
                                style="max-width: 200px; max-height: 200px;"></div>
                            <div>
                                <span class="btn btn-outline-secondary btn-file">
                                    <span class="fileinput-new">Select image</span>
                                    <span class="fileinput-exists">Change</span>
                                    <input type="file" name="image" accept="image/*" />
                                </span>
                                <a href="#" class="btn btn-outline-secondary fileinput-exists"
                                    data-dismiss="fileinput">Remove</a>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="form-group">
                    <label class="col-sm-2 col-form-label col-form-label-lg control-label">.</label>
                    <div class="col-sm-2">
                        <input type="submit" class="btn btn-primary" style="width: 100%!important"
                            value="      Save      " />
                    </div>
                </div>

            </form>
        </div>
    </div>

@endsection
