@extends('aceclientv.app')

@section('content_title')
    <strong> User Manage</strong>
@endsection

@section('content')

    <div class="inner_body">
        <div class="content">

            <div style="margin-bottom: 10px;" class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"><strong>New User</strong></div>
                        <div class="panel-body">
                            <form class="form-horizontal" method="POST" action="{{ route('users.store') }}"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label class="control-label col-md-2 required" for="name">Name</label>
                                    <div class="col-md-3">
                                        <input class="form-control" type="text" name="name" id="name"
                                            value="{{ old('name', '') }}" required>
                                        @if ($errors->has('name'))
                                            <span class="help-block" role="alert">{{ $errors->first('name') }}</span>
                                        @endif
                                    </div>
                                    <label class="control-label col-md-2" for="email">Email</label>
                                    <div class="col-md-3">
                                        <input class="form-control" type="text" name="email" id="email"
                                            value="{{ old('email', '') }}">
                                        @if ($errors->has('email'))
                                            <span class="help-block" role="alert">{{ $errors->first('email') }}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-2" for="password">Password</label>
                                    <div class="col-md-3">
                                        <input id="password" type="password"
                                            class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}"
                                            name="password" required>
                                        @if ($errors->has('password'))
                                            <span class="help-block"
                                                role="alert">{{ $errors->first('password') }}</span>
                                        @endif
                                    </div>
                                    <label class="control-label col-md-2" for="password">Confirm Password</label>
                                    <div class="col-md-3">
                                        <input id="password-confirm" type="password" class="form-control"
                                            name="password_confirmation" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-2" for="phone">Phone</label>
                                    <div class="col-md-3">
                                        <input id="phone" type="text" class="form-control" name="phone">
                                    </div>
                                    <div class="col-md-2 col-md-offset-2">
                                        <button class="btn btn-sm btn-primary" style="width: 100%"
                                            type="submit">Create</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <form id="form-inquery" target="_blunk" class="form-inline" action="" method="get">
                        <button id="pdf_btn" type="submit" class="btn btn-sm btn-primary">
                            <i class="ace-icon fa fa-file-pdf-o"></i> Pdf &nbsp; &nbsp;
                            <i class="ace-icon fa fa-external-link"></i>
                        </button>
                        <input type="hidden" name="action" value="pdf" />
                        @csrf
                    </form>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <strong>User List</strong>
                        </div>
                        <div class="panel-body">
                            <div class="table-responsive">
                                <table class=" table table-bordered table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Photo</th>
                                            <th>Type</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($users as $key => $user)
                                            <tr data-entry-id="{{ $user->id }}">
                                                <td>
                                                    {{ $loop->index + 1 }}
                                                </td>
                                                <td>
                                                    {{ $user->name ?? '' }}
                                                </td>
                                                <td>
                                                    {{ $user->email ?? '' }}
                                                </td>
                                                <td>
                                                    {{ $user->phone ?? '' }}
                                                </td>
                                                <td>
                                                    <img src="{{ url('public') . '/' . $user->image ?? '' }}"
                                                        style="width: 100px; height: 80px;" />
                                                </td>
                                                <td>
                                                    {{ $user->type ?? '' }}
                                                </td>
                                                <td>
                                                    {{ $user->active == 1 ? 'Active' : 'Inactive' }}
                                                </td>
                                                <td>
                                                    {{-- <a class="btn btn-xs btn-primary" href="{{ route('users.show', $user->id) }}">
                                                    view
                                                </a> --}}

                                                    <a class="btn btn-xs btn-info"
                                                        href="{{ route('users.edit', $user->id) }}">

                                                        <i class="fa fa-edit"></i>
                                                    </a>

                                                    @if (\Auth::user()->type == 'admin')

                                                        <a class="btn btn-xs btn-danger delete_data"
                                                            href="{{ route('users.destroy', $user->id) }}">
                                                            <i class="fa fa-times"></i>
                                                        </a>

                                                    @endif

                                                </td>

                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>

@endsection
