<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/dashboard', function () {
	if (Auth::check()) {
	    return view('client.dashboard');
	}else{
		return redirect('/login');
	}	 
});

Route::get('users/{user}',  ['as' => 'users.edit', 'uses' => 'UserController@edit']);
Route::get('users/',  ['as' => 'users', 'uses' => 'UserController@index']);
Route::post('users/store',  ['as' => 'users.store', 'uses' => 'UserController@store']);
Route::patch('users/{user}/update',  ['as' => 'users.update', 'uses' => 'UserController@update']);
Route::delete('users/{user}',  ['as' => 'users.destroy', 'uses' => 'UserController@destroy']);

Route::match(['get','post'], 'forgot-password', 'CommonController@forgotPassword')->name('forgot-password');

Route::get('/home', 'HomeController@index');

Auth::routes(['register' => false]);

Route::middleware('auth')->group(function (){

	// UserController
	Route::get('/user', 'UserController@index');
	Route::post('/user', 'UserController@store');
	Route::put('/user/{user}', 'UserController@update');
	Route::get('/user/{id}', 'UserController@show');

	Route::match(['get', 'post'], '/admin/settings', 'SettingController@index')->name('admin.settings.index');

    Route::resource('admin/galleries', 'Backend\GalleryController');
    Route::resource('admin/video_galleries', 'Backend\VideoGalleryController');
    Route::resource('admin/notices', 'Backend\NoticeController');

    Route::resource('admin/pages', 'Backend\PageController');

    Route::get('admin/files_auto_listing', 'Backend\CategoryController@files_auto_listing')->name('files_auto_listing');

    Route::post('admin/files_auto_listing_run', 'Backend\CategoryController@files_auto_listing_run')->name('files_auto_listing_run');



});
//________________________________________________

