<?php

Route::get('/', 'Frontend\HomeController@index');

Route::get('video-details/{id}', 'Frontend\FolderController@details')->name('frontent.video-details');
Route::get('software-details/{id}', 'Frontend\FolderController@software_details')->name('frontent.software-details');

Route::get('movies', 'Frontend\FolderController@movies')->name('frontent.movies');

Route::get('softwares', 'Frontend\FolderController@softwares')->name('frontent.softwares');
Route::get('games', 'Frontend\FolderController@games')->name('frontent.games');

Route::get('download-file/{id}', 'Frontend\FolderController@download_file')->name('frontent.download-file');

Route::post('search_movies/', 'Frontend\FolderController@search_movies')->name('frontent.search_movies');

Route::get('notice', 'Frontend\HomeController@notice')->name('frontent.notice');

Route::get('gallery', 'Frontend\HomeController@gallery')->name('frontent.gallery');
Route::get('video_gallery', 'Frontend\HomeController@video_gallery')->name('frontent.video_gallery');
Route::get('contact', 'Frontend\HomeController@contact')->name('frontent.contact');


Route::get('member/login', 'Frontend\MemberController@login')->name('member.login');
Route::post('member/login-validate', 'Frontend\MemberController@loginValidate')->name('member.login-validate');
Route::post('member/logout', 'Frontend\MemberController@logout')->name('member.logout');
Route::match(['get','post'], 'forgot-password', 'Frontend\MemberController@forgotPassword')->name('frontend.forgot-password');
Route::match(['get','post'], 'password-reset/{extra_remember_token}', 'Frontend\MemberController@passwordReset')->name('frontend.password-reset');

Route::get('member/register', 'Frontend\MemberController@register')->name('member.register');
Route::post('member/register', 'Frontend\MemberController@registration')->name('member.registration');

Route::get('about_page/{slug}', 'Frontend\PageController@about_page')->name('frontent.about_page');

Route::get('terms', 'CommonController@terms')->name('terms');
Route::get('privacy', 'CommonController@privacy')->name('privacy');
Route::get('policy', 'CommonController@policy')->name('policy');

Route::group(['middleware'=>['member']], function(){
	
	Route::get('member/profile',  ['as' => 'member.profile', 'uses' => 'Frontend\MemberController@profile']);
	Route::post('member/profile-update',  ['as' => 'member.profile-update', 'uses' => 'Frontend\MemberController@profile_update']);

});
