<?php $__env->startSection('content_title'); ?>
    <strong> About Pages</strong>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style type="text/css">
  .page_image{
    width: 100%;
    height: 130px;
  }
</style>
<div class="inner_body">
  <div class="content">
    <div class="row">
      <div class="col-lg-12">
        <div class="panel panel-default">
          <div class="panel-heading">
            <div class="row">
              <div class="col-sm-2">
                About Page Manage
              </div>
              <div class="col-sm-6 text-right-">
                <a class="btn btn-primary btn-sm" href="javascript:void(0)" id="createNewPage"> Create New About Page <i class="fa fa-plus"></i></a>
              </div>              
            </div>
          </div>
          <div class="panel-body">
            <div class="table-responsive">
              
              <table class="table table-stripped table-bordered data-table">
                  <thead>
                      <tr>
                          <th width="5%">No</th>
                          <th>Title</th>
                          <th>Slug</th>
                          <th>Description</th>
                          <th width="25%">Image</th>
                          <th width="12%">Action</th>
                      </tr>
                  </thead>
                  <tbody>
                  </tbody>
              </table>
            </div>
          </div>
          <div class="modal fade" id="ajaxModel" aria-hidden="true">
            <div class="modal-dialog modal-lg" style="width: 85%">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modelHeading"></h4>
                    </div>
                    <div class="modal-body">
                      <form id="PageForm" name="PageForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                          <input type="hidden" name="Page_id" id="Page_id">
                          <div class="form-group">
                              <label for="title" class="col-sm-2 control-label">Title</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="slug" class="col-sm-2 control-label">Slug</label>
                              <div class="col-sm-10">
                                  <input type="text" readonly="" class="form-control" id="slug" name="slug" placeholder="Enter slug" value="" />
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="description" class="col-sm-2 control-label">Description</label>
                              <div class="col-sm-10">
                                <textarea class="form-control" id="description" name="description"></textarea>
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="page_image" class="col-sm-2 control-label">Image</label>
                              <div class="col-sm-10">
                                  <?php echo e(image_input_show('page_image', '467px', '120px')); ?>

                                  <div id="page_image_show"></div>
                              </div>
                          </div>
                          
                          <div class="form-group">
                              <div class="col-sm-10 col-sm-offset-2">
                                  <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Save Changes</button>
                              </div>
                          </div>
                           
                        </form>
                    </div>
                </div>
            </div>
         </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

  function getBase64Image(img) {
    var canvas = document.createElement("canvas");
    canvas.width = img.width;
    canvas.height = img.height;
    var ctx = canvas.getContext("2d");
    ctx.drawImage(img, 0, 0);
    var dataURL = canvas.toDataURL("image/png");
    return dataURL;
    // return dataURL.replace(/^data:image\/(png|jpg);base64,/, "");
  }

  var base_url = '<?php echo e(url('public')); ?>';
  $(function () {

    // wysiwyg editor
    $('#description').summernote();

    $(document).on('keyup focus input', '#title', function(event) {

        var data = $(this).val();
        data = data.replaceAll(' ', '-').toLowerCase();
        $('#slug').val(data);
    });

    var table = $('.data-table').on( 'error.dt', function ( e, settings, techNote, message ) {
      if(confirm('Please reload this page and check.')){
        location.reload();
      }
    }).DataTable({
        
        // dom: 'Blfrtip',
        dom: 'lfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],

        processing: true,
        serverSide: true,
        ajax: "<?php echo e(route('pages.index')); ?>",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'title', name: 'title'},
            {data: 'slug', name: 'slug'},
            {data: 'description', name: 'description',
                render: function( data, type, full, meta ) {
                    return $("<div/>").html(data).text().slice(0, 165) + ' ...';
                }
            },
            {data: 'page_image', name: 'page_image',
                render: function( data, type, full, meta ) {
                      return '<img class="page_image" src="'+base_url + data +'" height="50" alt="image" >';
                  }
            },
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],

        drawCallback: function( settings ) {
          
            $(document).find('.page_image').each(function(index, el) {
                
                var base64 = getBase64Image(el);
                // $(el).attr('src', base64);
              
            });
        },
    });

    $('#createNewPage').click(function () {
        $('#saveBtn').val("create-Page");
        $('#Page_id').val('');
        $('#page_image_show').html('')
        $('#PageForm').trigger("reset");
        $('#modelHeading').html("Create New About Page");
        $('#ajaxModel').modal('show');
        $('#description').summernote('code', '');
    });

    $('body').on('click', '.editPage', function () {

      var Page_id = $(this).data('id');

      $.get("<?php echo e(route('pages.index')); ?>" +'/' + Page_id +'/edit', function (data) {

          $('#modelHeading').html("Edit About Page");

          $('#saveBtn').val("edit-user");

          $('#ajaxModel').modal('show');

          $('#Page_id').val(data.id);

          $('#title').val(data.title);

          $('#page_image_show').html('<img src="'+base_url+data.page_image+'" style="width: 230px; height: 120px" />');

          $('#description').summernote('code', data.description);
          $('#slug').val(data.slug);
      })

   });

    $('#PageForm').submit(function(e) {
        e.preventDefault();
        // $(this).html('Sending..');

        var form_data = new FormData(this);
        // console.log("form_data", form_data);return false;

        $.ajax({

          data: form_data,
          url: "<?php echo e(route('pages.store')); ?>",
          type: "POST",
          cache: false,
          contentType: false,
          processData: false,

          success: function (data) {

              $('#PageForm').trigger("reset");
              $('#ajaxModel').modal('hide');
              table.draw();
          },
          error: function (data) {
              console.log('Error:', data);
              $('#saveBtn').html('Save Changes');
          }
      });
    });

    $('body').on('click', '.deletePage', function () {

        var Page_id = $(this).data("id");
        if( ! confirm("Are You sure want to delete !") ){
          return false;
        }

        $.ajax({
            type: "DELETE",
            url: "<?php echo e(route('pages.store')); ?>"+'/'+Page_id,
            success: function (data) {

                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });


  });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('aceclientv.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>