<!DOCTYPE html>
<!-- <html lang="en">-->
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta charset="utf-8" />
    <title><?php echo $__env->yieldContent('head_title'); ?> <?php echo e(config('app_settings.application_title')); ?></title>

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <meta name="description" content="overview &amp; stats" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

    
    <meta http-equiv='cache-control' content='no-cache'>
    <meta http-equiv='expires' content='0'>
    <meta http-equiv='pragma' content='no-cache'>
    
    

    

    <link rel="icon" href="<?php echo e(url('public')); ?>/ace_assets/images/favicon.png" />

    <!-- bootstrap & fontawesome -->
    <!--  Html::style('ace_assets/css/bootstrap.css')  -->

    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/bootstrap.css" />
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/font-awesome.css" />

    <!-- page specific plugin styles -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/jquery-ui.custom.css" />
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/chosen.css" />
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/datepicker.css" />
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/bootstrap-timepicker.css" />
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/daterangepicker.css" />
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/bootstrap-datetimepicker.css" />

    <!-- text fonts -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/ace-fonts.css" />

    <!-- dashboard styles -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/dashboard.css" />

    <!-- ace styles -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/ace.css" class="ace-main-stylesheet" id="main-ace-style" />

    <!-- custom styles -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/css/custom.css" class="ace-main-stylesheet" id="main-ace-style" />

    <!--[if lte IE 9]>
        <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/ace-part2.css" class="ace-main-stylesheet" />
    <![endif]-->

    <!--[if lte IE 9]>
      <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/ace-ie.css" />
    <![endif]-->

    <!-- inline styles related to this page -->

    <!-- ace settings handler -->
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace-extra.js"></script>

    <!-- HTML5shiv and Respond.js for IE8 to support HTML5 elements and media queries -->

    <!--[if lte IE 8]>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/html5shiv.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/respond.js"></script>
    <![endif]-->

    <!-- basic scripts -->

    <!--[if !IE]> -->
    <script type="text/javascript">
        var ace_assets_baselink = "<?php echo e(url('public')); ?>/ace_assets/";
        window.jQuery || document.write("<script src='"+ace_assets_baselink+"js/jquery.js'>"+"<"+"/script>");
    </script>

    <!-- <![endif]-->

    <!--[if IE]>
<script type="text/javascript">
window.jQuery || document.write("<script src='assets/js/jquery1x.js'>"+"<"+"/script>");
</script>
<![endif]-->
    <script type="text/javascript">
        if('ontouchstart' in document.documentElement) document.write("<script src='"+ace_assets_baselink+"js/jquery.mobile.custom.js'>"+"<"+"/script>");
    </script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/bootstrap.js"></script>

    <!-- page specific plugin scripts -->

    <!--[if lte IE 8]>
      <script src="<?php echo e(url('public')); ?>/ace_assets/js/excanvas.js"></script>
    <![endif]-->
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/jquery-ui.custom.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/jquery.ui.touch-punch.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/chosen.jquery.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/fuelux/fuelux.spinner.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/date-time/bootstrap-datepicker.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/date-time/bootstrap-timepicker.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/date-time/moment.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/date-time/daterangepicker.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/date-time/bootstrap-datetimepicker.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/jquery.easypiechart.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/jquery.sparkline.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/flot/jquery.flot.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/flot/jquery.flot.pie.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/flot/jquery.flot.resize.js"></script>

    <!-- ace scripts -->
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.scroller.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.colorpicker.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.fileinput.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.typeahead.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.wysiwyg.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.spinner.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.treeview.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.wizard.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/elements.aside.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.ajax-content.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.touch-drag.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.sidebar.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.sidebar-scroll-1.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.submenu-hover.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.widget-box.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.settings.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.settings-rtl.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.settings-skin.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.widget-on-reload.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/ace/ace.searchbox-autocomplete.js"></script>

    <!-- page specific plugin scripts -->
    <!--[if lte IE 8]>
      <script src="assets/js/excanvas.js"></script>
    <![endif]-->
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/bootstrap-colorpicker.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/jquery.knob.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/jquery.autosize.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/jquery.inputlimiter.1.3.1.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/jquery.maskedinput.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/bootstrap-tag.js"></script>

    <script src="<?php echo e(url('public')); ?>/ace_assets/js/form_elements.js"></script>

    <link href="<?php echo e(url('public')); ?>/ace_assets/css/select2.css" rel="stylesheet" />
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/select2.js"></script>

    <script src="<?php echo e(url('public')); ?>/ace_assets/js/inputmask/jquery.inputmask.bundle.js"></script>

    <!-- page specific plugin scripts -->
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables/jquery.dataTables.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables/jquery.dataTables.bootstrap.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables/extensions/TableTools/js/dataTables.tableTools.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables/extensions/ColVis/js/dataTables.colVis.js"></script>

    
    

    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/buttons.flash.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/jszip.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/pdfmake.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/vfs_fonts.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/buttons.html5.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/buttons.print.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/mark.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/dataTables-file-export/js/dataTables.mark.js"></script>
    <style type="text/css">
        .dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
            color: #333 !important;
            border: 1px solid #979797;
            background-color: white;
            background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #fff), color-stop(100%, #dcdcdc));
            background: -webkit-linear-gradient(top, #fff 0%, #dcdcdc 100%);
            background: -moz-linear-gradient(top, #fff 0%, #dcdcdc 100%);
            background: -ms-linear-gradient(top, #fff 0%, #dcdcdc 100%);
            background: -o-linear-gradient(top, #fff 0%, #dcdcdc 100%);
            background: linear-gradient(to bottom, #fff 0%, #dcdcdc 100%);
        }
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            box-sizing: border-box;
            display: inline-block;
            min-width: 1.5em;
            padding: 0.5em 1em;
            margin-left: 2px;
            text-align: center;
            text-decoration: none !important;
            cursor: pointer;
            *cursor: hand;
            color: #333 !important;
            border: 1px solid transparent;
            border-radius: 2px;
        }
        mark{background:orange;color:black;}
    </style>

    <link href="<?php echo e(url('public')); ?>/css/fileinput.min.css" rel="stylesheet" type="text/css"/>
    <script src="<?php echo e(url('public')); ?>/js/fileinput.min.js"></script>

    
    <script src="<?php echo e(url('public')); ?>/ace_assets/js/notify/notify.min.js"></script>
    
    
    <script type="text/javascript">
        $(document).ready(function() {

            var notify_options = {
                // whether to auto-hide the notification
                autoHide: true,
                // if autoHide, hide after milliseconds
                autoHideDelay: 7000,
                close: true,
                Width: "520px",
            };
            $.notify.defaults( notify_options );

            $.fn.serializeObject = function () {
                var o = {};
                this.find("[name]").each(function () {
                     o[this.name] = this.value;
                });
                return o;
            };
        });
    </script>

    <script src="<?php echo e(url('public')); ?>/js/print.js"></script>
    
    
    
    

    
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/summernote-0.8.18-dist-wysiwyg/summernote.min.css">
    <script src="<?php echo e(url('public')); ?>/summernote-0.8.18-dist-wysiwyg/summernote.min.js"></script>
    

    <style>
        .table > tbody > tr > td {
            vertical-align: middle;
        }
        .table > tbody > tr > td > a, .table > tbody > tr > td > form {
            display: inline-block !important;
        }
        small.summary_{
            font-size: 100%;
            padding-top: 1px;
            color: #fff;
            font-weight: bold;
            position: absolute;
            left: 2%;
        }
        .form-control, textarea, input[type="text"], input[type="password"], input[type="datetime"], input[type="datetime-local"], input[type="date"], input[type="month"], input[type="time"], input[type="week"], input[type="number"], input[type="email"], input[type="url"], input[type="search"], input[type="tel"], input[type="color"] {
            color: #111 !important;
            border: 1px solid #aaa !important;
            border-radius: 4px !important;
            -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075) !important;
            box-shadow: inset 0 1px 1px rgba(0,0,0,.075) !important;
            -webkit-transition: border-color ease-in-out .15s,-webkit-box-shadow ease-in-out .15s !important;
            -o-transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s !important;
            transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s !important;
        }

        .form-multiline .form-group {
            margin-bottom: 5px;
            margin-right: 5px;
        }
        .form-multiline label,
        .form-multiline .form-control {
            margin-right: 5px;
        }
        .dt-buttons{
            float: left;
        }

        .dt-buttons button{
            margin-right: 5px;
        }

        .nav-list ul, .nav-list li{
            font-weight: bold;
        }
        .btn{
            /*margin-bottom: 2px;*/
        }
        .breadcrumbs {
            font-size: 17px;
        }
        /*th { white-space: nowrap; }
        td { white-space: nowrap; }*/
        /*@
        media screen and (min-width: 480px) {
            .full-sum{
                display: block;
            }
            .page-sum{
                display: none;
            }
        }*/

        /* page jumping on .table-responsive remove*/
        .table-responsive {
            overflow-x: overlay !important;
            min-height: 0.01% !important;
        }
        /* page jumping on .table-responsive remove end*/

        .navbar:not(.navbar-collapse) .ace-nav {
            background-color: inherit;
        }
        .ace-nav > li > a {
            background-color: inherit;
        }
        .ace-nav > li {
            border-left: none;
        }
        .navbar:not(.navbar-collapse) .ace-nav{
            border: none;
        }
        .navbar:not(.navbar-collapse) .ace-nav > li:first-child {
            border-left: none;
        }
        .ace-nav > li.light-blue > a:hover, .ace-nav > li.light-blue > a:focus, .ace-nav > li.open.light-blue > a {
            background-color: inherit;
        }
        .ace-nav > li.light-blue > a {
            background-color: #428bca !important;
        }
        .navbar {
            background: #428bca;
        }
        .breadcrumbs {
            background-color: none !important;
            color: #ffffff;
        }
        .panel-info > .panel-heading {
            color: #ffffff;
            background-color: #428bca;
            border-color: #428bca;
        }
        .panel-heading {
            color: #ffffff;
            background-color: #428bca;
        }
        .no-skin .navbar .navbar-toggle {
            background-color: #808000;
        }

    </style>
    <script>
        $(document).ready(function() {

            $.fn.dataTable.ext.errMode = 'throw';
            
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log("errorThrown", errorThrown);
                    console.log("textStatus", textStatus);
                    console.log("jqXHR", jqXHR);
                    if (jqXHR.status==419) {
                        $.notify('Session Expired! Refreshing...', 'error');
                        setTimeout(function() {

                            location.reload();
                        }, 1000);
                    }
                    if (jqXHR.status==401) {
                        $.notify('Unauthenticated! Refreshing...', 'error');
                        setTimeout(function() {

                            location.reload();
                        }, 1000);
                    }
                    
                }
            });
            
            $('.chosen').chosen();
            $('.datepicker').datepicker({format: "dd-mm-yyyy"});
        });
    </script>

</head>
<body class="no-skin">

    <!-- _________________________HEADER DIVITION STARTS_____________________________ -->
    <!-- #section:basics/navbar.layout -->
    <div id="navbar" class="navbar navbar-default">
        <script type="text/javascript">
            try{ace.settings.check('navbar' , 'fixed')}catch(e){}
        </script>

        <div class="navbar-container" id="navbar-container">
            <!-- #section:basics/sidebar.mobile.toggle -->
            <button type="button" class="navbar-toggle menu-toggler pull-left" id="menu-toggler" data-target="#sidebar">
                <span class="sr-only">Toggle sidebar</span>

                <span class="icon-bar"></span>

                <span class="icon-bar"></span>

                <span class="icon-bar"></span>
            </button>

            <!-- /section:basics/sidebar.mobile.toggle -->
            <div class="navbar-header pull-left">
                <!-- #section:basics/navbar.layout.brand -->
                <a href="#" class="navbar-brand" style="padding: 2px !important;">
                    <small class="">
                        <!-- <i class="fa fa-leaf"></i> -->
                        
                        
                        <img src="<?php echo e(url('public').config('app_settings.site_logo')); ?>" style="width: 201px;max-width: 201px; height:40px; max-height:40px; " />
                    </small>
                </a>
                <small class="summary_"> </small>

                <!-- /section:basics/navbar.layout.brand -->

                <!-- #section:basics/navbar.toggle -->

                <!-- /section:basics/navbar.toggle -->
            </div>

            <!-- #section:basics/navbar.dropdown -->
            <div class="navbar-buttons navbar-header pull-right" role="navigation" style="float: right!important;">
                <ul class="nav ace-nav">                    

                    <!-- #section:basics/navbar.user_menu -->
                    <?php
                    if (Auth::guard('admin')->check()) {
                        $userType = 'admin';
                    }else{
                        $userType = 'user';
                    }

                    $auth_user = Auth::user();
                    ?>
                    <?php if(Auth::guest()): ?>

                        <li class="light-blue">
                            <a data-toggle="dropdown" href="#" class="dropdown-toggle">
                                <img class="nav-user-photo" 
                                src="" alt="photo" />
                                <span class="user-info">
                                    <small>Welcome</small>
                                </span>
                                <i class="ace-icon fa fa-caret-down"></i>
                            </a>

                            <ul class="user-menu dropdown-menu-right dropdown-menu dropdown-yellow dropdown-caret dropdown-close">
                                <li>
                                    <a href="<?php echo e(route('login')); ?>">
                                        <i class="ace-icon fa fa-cog"></i>
                                        Login
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('register')); ?>">
                                        <i class="ace-icon fa fa-user"></i>
                                        Sign up
                                    </a>
                                </li>                                                              
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="light-blue">
                            <a data-toggle="dropdown" href="#" class="dropdown-toggle">
                                <img class="nav-user-photo" src="<?php echo e(url('public')); ?>/<?php echo e($auth_user->image); ?>" alt="photo" />
                                <span class="user-info">
                                    <small>Welcome, (<?php echo e($auth_user->type); ?>)</small>
                                    <?php echo e($auth_user->name); ?>

                                </span>
                                <i class="ace-icon fa fa-caret-down"></i>
                            </a>

                            <ul class="user-menu dropdown-menu-right dropdown-menu dropdown-yellow dropdown-caret dropdown-close">
                                <li>
                                    <a href="<?php echo e(url('/admin/settings')); ?>">
                                        <i class="ace-icon fa fa-cog"></i>
                                        Settings
                                    </a>
                                </li>

                                <li>                                    
                                    <a href="<?php echo e(route('users.edit', $auth_user->id)); ?>">
                                        <i class="ace-icon fa fa-user"></i>
                                        My Profile
                                    </a>
                                </li>
                                <li class="divider"></li>

                                <li>
                                    <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                        <i class="ace-icon fa fa-power-off"></i>
                                        Logout
                                    </a>
                                </li>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                    <?php echo e(csrf_field()); ?>

                                </form>
                            </ul>
                        </li>
                        <?php endif; ?>

                    <!-- /section:basics/navbar.user_menu -->
                </ul>
            </div>

            <!-- /section:basics/navbar.dropdown -->
        </div><!-- /.navbar-container -->
    </div>

<!-- /section:basics/navbar.layout -->
    <div class="main-container" id="main-container">
        <script type="text/javascript">
            try{ace.settings.check('main-container' , 'fixed')}catch(e){}
        </script>
    <!-- _________________________ HEADER DIVITION ENDS ___________________________ -->
    <!-- _________________________ NAVIGATION STARTS ___________________________ -->
    <!-- #section:basics/sidebar -->
    <div id="sidebar" class="sidebar                  responsive">
        <script type="text/javascript">
            try{ace.settings.check('sidebar' , 'fixed')}catch(e){}
        </script>

        <!-- div class="sidebar-shortcuts" id="sidebar-shortcuts">
            <div class="sidebar-shortcuts-large" id="sidebar-shortcuts-large">
                <button class="btn btn-success">
                    <i class="ace-icon fa fa-signal"></i>
                </button>
        
                <button class="btn btn-info">
                    <i class="ace-icon fa fa-pencil"></i>
                </button>
        
                #section:basics/sidebar.layout.shortcuts
                <button class="btn btn-warning">
                    <i class="ace-icon fa fa-users"></i>
                </button>
        
                <button class="btn btn-danger">
                    <i class="ace-icon fa fa-cogs"></i>
                </button>
        
                /section:basics/sidebar.layout.shortcuts
            </div>
        
            <div class="sidebar-shortcuts-mini" id="sidebar-shortcuts-mini">
                <span class="btn btn-success"></span>
        
                <span class="btn btn-info"></span>
        
                <span class="btn btn-warning"></span>
        
                <span class="btn btn-danger"></span>
            </div>
        </div>/.sidebar-shortcuts -->

        <ul class="nav nav-list">
                    
            <!-- #section:basics/sidebar.layout.minimize -->
            <div class="sidebar-toggle sidebar-collapse" id="sidebar-collapse" style="background-color: #428bca">
                <i class="ace-icon fa fa-angle-double-left" data-icon1="ace-icon fa fa-angle-double-left" data-icon2="ace-icon fa fa-angle-double-right" ></i>
            </div>

        <?php if( ! Auth::guest()): ?>

            <li hidden="" class="<?php echo e(url('/')); ?>">
                <a href="<?php echo e(url('/')); ?>" target="_blank">
                    <i class="menu-icon fa fa-globe"></i>
                    <span class="menu-text"> Visit Front Site &nbsp;&nbsp;<i class="fa fa-external-link"></i></span>
                </a>
                <b class="arrow"></b>
            </li>

            <li class="<?php echo e((Request::is('dashboard') || Request::is('/')) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('dashboard')); ?>">
                    <i class="menu-icon fa fa-home"></i>
                    <span class="menu-text"> <strong> Dashboard</strong> </span>
                </a>

                <b class="arrow"></b>
            </li>

            <li hidden="" class="<?php echo e((Request::is('admin/settings') ) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/admin/settings')); ?>">
                    <i class="menu-icon fa fa-cog"></i>
                    <span class="menu-text"> Settings </span>
                </a>
                <b class="arrow"></b>
            </li>

            <li hidden="" class="<?php echo e((Request::is('admin/files_auto_listing') ) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/admin/files_auto_listing')); ?>">
                    <i class="menu-icon fa fa-cog"></i>
                    <span class="menu-text"> Files Auto Listing </span>
                </a>
                <b class="arrow"></b>
            </li>

            <li class="<?php echo e((Request::is('admin/sliders') || Request::is('admin/sliders*')) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/sliders')); ?>">
                    <i class="menu-icon glyphicon glyphicon-inbox" aria-hidden="true"></i>
                    <span class="menu-text"> <strong> Sliders</strong> </span>
                </a>
                <b class="arrow"></b>
            </li>

            <li class="<?php echo e((Request::is('admin/pages') || Request::is('admin/pages*')) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/pages')); ?>">
                    <i class="menu-icon glyphicon glyphicon-inbox" aria-hidden="true"></i>
                    <span class="menu-text"> <strong> About Pages</strong> </span>
                </a>
                <b class="arrow"></b>
            </li>

            <li class="<?php echo e((Request::is('admin/galleries') || Request::is('admin/galleries*')) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/galleries')); ?>">
                    <i class="menu-icon glyphicon glyphicon-inbox" aria-hidden="true"></i>
                    <span class="menu-text"> <strong> Galleries</strong> </span>
                </a>
                <b class="arrow"></b>
            </li>

            <li class="<?php echo e((Request::is('admin/video_galleries') || Request::is('admin/video_galleries*')) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/video_galleries')); ?>">
                    <i class="menu-icon glyphicon glyphicon-inbox" aria-hidden="true"></i>
                    <span class="menu-text"> <strong> Video Galleries</strong> </span>
                </a>
                <b class="arrow"></b>
            </li>

            <li class="<?php echo e((Request::is('admin/notices') || Request::is('admin/notices*')) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('admin/notices')); ?>">
                    <i class="menu-icon glyphicon glyphicon-inbox" aria-hidden="true"></i>
                    <span class="menu-text"> <strong> Notices</strong> </span>
                </a>
                <b class="arrow"></b>
            </li>

            <li hidden="" class="<?php echo e((Request::is('users/'.$auth_user->id) ) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/users/'.$auth_user->id)); ?>">
                    <i class="menu-icon fa fa-user"></i>                    
                    <span class="menu-text"> My Profile </span>
                </a>
                <b class="arrow"></b>
            </li>
            
            <?php if($auth_user->type=='admin'): ?>
                <li hidden="" class="<?php echo e((Request::is('users/*') || Request::is('users')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('/users/')); ?>">
                        <i class="menu-icon fa fa-users"></i>                    
                        <span class="menu-text"> User Summary </span>
                    </a>
                    <b class="arrow"></b>
                </li>
                   
            <?php endif; ?>

        <?php endif; ?>
            
        </ul><!-- /.nav-list -->

        <!-- /section:basics/sidebar.layout.minimize -->
        <script type="text/javascript">
            try{ace.settings.check('sidebar' , 'collapsed')}catch(e){}
        </script>
    </div>
    <!-- _________________________ NAVIGATION ENDS ___________________________ -->
    <!-- _________________________ MAIN CONTENTS STARTS ___________________________ -->
    <div class="main-content">        

    <!-- /section:basics/sidebar -->
        <div class="main-content" style="margin-top: 1px;">
            <div class="main-content-inner">

                <!-- /section:basics/content.breadcrumbs -->
                <div class="page-content">

                    <div class="row">
                        <div class="col-xs-12">
                            <!-- #section:basics/content.breadcrumbs -->
                            <div class="breadcrumbs" id="breadcrumbs" style="color: #585858 !important;">
                                <script type="text/javascript">
                                    try{ace.settings.check('breadcrumbs' , 'fixed')}catch(e){}
                                </script>

                                <?php echo $__env->yieldContent('content_title'); ?>

                                <!-- /section:basics/content.searchbox -->
                            </div>
                        <!--_____Main import Contents______ -->
                        <div class="content_body">

                            <?php echo $__env->make('layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                            <?php echo $__env->yieldContent('content'); ?>
                        </div>

                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div><!-- /.page-content -->
                </div><!-- /.page-content -->
                </div><!-- /.page-content -->
                </div><!-- /.page-content -->

                <div class="footer">
                    <div class="footer-inner">
                      <!-- #section:basics/footer -->
                      <div class="footer-content" style="line-height: 1.4 !important;left:6px!important;right:4px!important;">
                        <span class="bigger-110">
                                  <span class="blue bolder"></span>
                                  &copy; <?php echo e(date('Y')); ?>, <?php echo e(config('app_settings.application_title')); ?>.
                              </span>

                                
                                <span class="bigger-10"></span>
                        </div>
                       <!-- /section:basics/footer -->
                    </div>
                </div>
                
                <a href="#" id="btn-scroll-up" class="btn-scroll-up btn btn-sm btn-inverse" style="width: 28px !important;">
                    <i class="ace-icon fa fa-angle-double-up icon-only bigger-110"></i>
                </a>
              
            </div>
        </div><!-- /.main-content -->

    </div><!-- /.main-container -->
    
    <!-- for ajax loader starts-->
    <div class="load-container" id="ajax_loader">
        
        <img src="<?php echo e(url('public')); ?>/ace_assets/images/loadingAnimation.gif">
    </div>
    <style>
    .load-container
    {
        /*height: 100vh;*/
        /*width: 100vw;*/
        height: 50px;
        width: 100px;
        
        padding: 0;
        margin: 0;
        position: fixed;
        top: 80px;
        /*left: 0;*/
        right: 67px;
        /*background-color: rgba(0, 0, 0,.8);*/
        z-index: 99999999;
        display: none;
    }
    .load-container>img
    {
        position: absolute;
        height: 30px;
        width: 160px;
        border-radius: 7px;
        top: 50%;
        left: 50%;
        margin-left: -50px;
        margin-top: -50px;
    }
    </style>
    <script type="text/javascript">
        $(document).ready(function() {

            $('.timepicker').timepicker();
            $('.timepicker').val("");

            $('.datepickerjui').datepicker({
                // format: {
                //     toDisplay: function () {},
                //     toValue: function () {}
                //   }
                format : 'dd-mm-yyyy',
            });
            $('.datemask').inputmask('dd-mm-yyyy', { 'placeholder': 'dd-mm-yyyy' });

            $(document).on('click', '.delete_data', function(event) {
                event.preventDefault();

                var status = confirm('Are you sure to delete!');
                if (! status) {
                    return false;
                }

                var href = $(this).prop('href');

                var this_r = $(this).closest('tr');

                var _token = '<?php echo e(csrf_token()); ?>';
                
                $.ajax({
                    type: 'DELETE',
                    url: href,
                    data: {_token:_token},
                    success:function(data){
                        console.log("data", data);
                        $.notify(data.message, data.status);
                        if (data.status=='success') {
                            $(this_r).remove();
                        }
                    },
                    error:function(data){
                        console.log(data);
                    },
                });
            });

        });
    </script>
    <script>
        $(document).ajaxStart(function()
        {
            $("#ajax_loader").show();
        });
        $(document).ajaxComplete(function()
        {
            $("#ajax_loader").hide();
        });

    </script>
    <!-- for ajax loader ends-->

</body>
</html>
    
