<?php $__env->startSection('content_title'); ?>
    <strong> User Manage</strong>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="inner_body">
        <div class="content">

            <div style="margin-bottom: 10px;" class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"><strong>New User</strong></div>
                        <div class="panel-body">
                            <form class="form-horizontal" method="POST" action="<?php echo e(route('users.store')); ?>"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label class="control-label col-md-2 required" for="name">Name</label>
                                    <div class="col-md-3">
                                        <input class="form-control" type="text" name="name" id="name"
                                            value="<?php echo e(old('name', '')); ?>" required>
                                        <?php if($errors->has('name')): ?>
                                            <span class="help-block" role="alert"><?php echo e($errors->first('name')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <label class="control-label col-md-2" for="email">Email</label>
                                    <div class="col-md-3">
                                        <input class="form-control" type="text" name="email" id="email"
                                            value="<?php echo e(old('email', '')); ?>">
                                        <?php if($errors->has('email')): ?>
                                            <span class="help-block" role="alert"><?php echo e($errors->first('email')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-2" for="password">Password</label>
                                    <div class="col-md-3">
                                        <input id="password" type="password"
                                            class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>"
                                            name="password" required>
                                        <?php if($errors->has('password')): ?>
                                            <span class="help-block"
                                                role="alert"><?php echo e($errors->first('password')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <label class="control-label col-md-2" for="password">Confirm Password</label>
                                    <div class="col-md-3">
                                        <input id="password-confirm" type="password" class="form-control"
                                            name="password_confirmation" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-2" for="phone">Phone</label>
                                    <div class="col-md-3">
                                        <input id="phone" type="text" class="form-control" name="phone">
                                    </div>
                                    <div class="col-md-2 col-md-offset-2">
                                        <button class="btn btn-sm btn-primary" style="width: 100%"
                                            type="submit">Create</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <form id="form-inquery" target="_blunk" class="form-inline" action="" method="get">
                        <button id="pdf_btn" type="submit" class="btn btn-sm btn-primary">
                            <i class="ace-icon fa fa-file-pdf-o"></i> Pdf &nbsp; &nbsp;
                            <i class="ace-icon fa fa-external-link"></i>
                        </button>
                        <input type="hidden" name="action" value="pdf" />
                        <?php echo csrf_field(); ?>
                    </form>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <strong>User List</strong>
                        </div>
                        <div class="panel-body">
                            <div class="table-responsive">
                                <table class=" table table-bordered table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Photo</th>
                                            <th>Type</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr data-entry-id="<?php echo e($user->id); ?>">
                                                <td>
                                                    <?php echo e($loop->index + 1); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($user->name ?? ''); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($user->email ?? ''); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($user->phone ?? ''); ?>

                                                </td>
                                                <td>
                                                    <img src="<?php echo e(url('public') . '/' . $user->image ?? ''); ?>"
                                                        style="width: 100px; height: 80px;" />
                                                </td>
                                                <td>
                                                    <?php echo e($user->type ?? ''); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($user->active == 1 ? 'Active' : 'Inactive'); ?>

                                                </td>
                                                <td>
                                                    

                                                    <a class="btn btn-xs btn-info"
                                                        href="<?php echo e(route('users.edit', $user->id)); ?>">

                                                        <i class="fa fa-edit"></i>
                                                    </a>

                                                    <?php if(\Auth::user()->type == 'admin'): ?>

                                                        <a class="btn btn-xs btn-danger delete_data"
                                                            href="<?php echo e(route('users.destroy', $user->id)); ?>">
                                                            <i class="fa fa-times"></i>
                                                        </a>

                                                    <?php endif; ?>

                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('aceclientv.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>