<!doctype html>
<html class="no-js" lang="">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo $__env->yieldContent('head_title'); ?> <?php echo e(config('app_settings.application_title')); ?></title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(url('public')); ?>/frontend/img/favicon.png">
    <!-- Normalize CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/normalize.css">
    <!-- Main CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/main.css">
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/custom.css">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/bootstrap.min.css">
    <!-- Animate CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/animate.min.css">
    <!-- Font-awesome CSS-->
    
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/ace_assets/css/font-awesome.css" />

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
    
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/v4-shims.css">
    <!-- Owl Caousel CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/vendor/OwlCarousel/owl.carousel.min.css">
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/vendor/OwlCarousel/owl.theme.default.min.css">
    <!-- Main Menu CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/meanmenu.min.css">
    <!-- nivo slider CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/vendor/slider/css/nivo-slider.css" type="text/css" />
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/vendor/slider/css/preview.css" type="text/css" media="screen" />
    <!-- Datetime Picker Style CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/jquery.datetimepicker.css">
    <!-- Magic popup CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/magnific-popup.css">
    <!-- Switch Style CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/hover-min.css">
    <!-- ReImageGrid CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/reImageGrid.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(url('public')); ?>/frontend/css/style.css">
    <!-- Modernizr Js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/modernizr-2.8.3.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/frontend/js/jquery-2.2.4.min.js" type="text/javascript"></script>

    <!-- Google Map js -->
    
    
    
    <style>
        nav#desktop-nav ul li .mega-menu-area > li {
            width: 230px;
            border-bottom: none;
            display: inline-block;
            margin-right: 14px;
        }
        nav#desktop-nav li.has-child-menu > ul.thired-level {
            left: 340px;
        }

        nav#desktop-nav ul li > ul {
            width: 340px;
        }

        .footer-box img {
            width: 210px;
            height: 195px;
        }

        .carousel-inner > .item > img {
            height: 490px;
        }

        .news-img-holder img {
            height: auto;
        }

        .owl-carousel .owl-item img {
            display: block;
            width: 100%;
            -webkit-transform-style: preserve-3d;
            /*height: 200px;*/
        }
        .header-top-right, .header-top-left {
            font-weight: bold;
        }

        .main-menu-area .header-search .search-form {
            background: rgba(0, 0, 0, 0.8);
            border: 2px solid #002147;
        }

    </style>
</head>

<body>
    <div id="wrapper">
        <!-- Header Area Start Here -->
        <header>
            <div id="header2" class="header2-area">
                <div class="header-top-area">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="header-top-left">
                                    <ul>
                                        <li><i class="fa fa-phone" aria-hidden="true"></i><a href="Tel:+1234567890"> <?php echo e(config('app_settings.site_phone')); ?> </a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="header-top-right">
                                    <ul>
                                        <li>
                                            <a class="login-btn-area" href="#" id="login-button"><i class="fa fa-envelope-o" aria-hidden="true"></i> <?php echo e(config('app_settings.site_email')); ?></a>
                                        </li>
                                        <li>
                                            <a class="login-btn-area" target="_blank" href="<?php echo e(url('login')); ?>" id="login-button"><i class="fa fa-lock" aria-hidden="true"></i> Login</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="main-menu-area bg-textPrimary" id="sticker">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-2 col-md-2 col-sm-1">
                                <div class="logo-area">
                                    <a href="<?php echo e(url('/')); ?>"><img class="img-responsive" src="<?php echo e(show_image( config('app_settings.site_logo') )); ?>" alt="logo"></a>
                                </div>
                            </div>
                            <div class="col-lg-9 col-md-9 col-sm-9">
                                <nav id="desktop-nav">
                                    <ul>
                                        <li class="active"><a href="<?php echo e(url('/')); ?>">Home</a>
                                        </li>

                                        <?php
                                            $categories = App\Model\Category::all();
                                            $sub_categories = App\Model\SubCategory::all();
                                        ?>

                                        <li><a href="<?php echo e(url('movies/')); ?>">Movies</a>
                                            <ul>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="has-child-menu"><a href="<?php echo e(url('movies/?category_slug='.$value->slug)); ?>"><?php echo e($value->name); ?></a>
                                                        <ul class="thired-level">
                                                            <?php $__currentLoopData = $sub_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_key => $sub_value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    <a href="<?php echo e(url('movies/?category_slug='.$value->slug.'&sub_category_slug='.$sub_value->slug)); ?>"><?php echo e($sub_value->title); ?></a>
                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </li>

                                        <li>
                                            <a href="#">Movie Series</a>
                                        </li>

                                        <li>
                                            <a href="#">TV Series</a>
                                        </li>

                                        <li>
                                            <a href="#">Game</a>
                                        </li>

                                        <li>
                                            <a href="#">Software</a>
                                        </li>

                                        <li>
                                            <a href="#">More</a>
                                        </li>

                                        <li>
                                            <a target="_blank" href="<?php echo e(config('app_settings.live_tv_link')); ?>">Live TV</a>
                                        </li>

                                        <li><a href="<?php echo e(url('/')); ?>/contact">Contact</a></li>

                                    </ul>
                                </nav>
                            </div>
                            <div class="col-lg-1 col-md-1 hidden-sm">
                                <div class="header-search">
                                    <form action="<?php echo e(url('movies/?')); ?>" method="get">
                                        <input type="text" class="search-form" name="search" placeholder="Search...." required="">
                                        <a href="#" class="search-button" id="search-button"><i class="fa fa-search" aria-hidden="true"></i></a>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Mobile Menu Area Start -->
            <div class="mobile-menu-area">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mobile-menu">
                                <nav id="dropdown">
                                    <ul>
                                        <li><a href="<?php echo e(url('/')); ?>">Home</a>
                                        </li>              
                                        
                                        <li><a href="#">Movies</a>
                                            <ul>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="has-child-menu"><a href="#"><?php echo e($value->name); ?></a>
                                                        <ul class="thired-level">
                                                            <?php $__currentLoopData = $sub_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_key => $sub_value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    <a href="#"><?php echo e($sub_value->title); ?></a>
                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </li>

                                        <li>
                                            <a href="#">Movie Series</a>
                                        </li>

                                        <li>
                                            <a href="#">TV Series</a>
                                        </li>

                                        <li>
                                            <a href="#">Game</a>
                                        </li>

                                        <li>
                                            <a href="#">Software</a>
                                        </li>

                                        <li>
                                            <a href="#">More</a>
                                        </li>

                                        <li>
                                            <a target="_blank" href="<?php echo e(config('app_settings.live_tv_link')); ?>">Live TV</a>
                                        </li>

                                        <li><a href="<?php echo e(url('/')); ?>/contact">Contact</a></li>

                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Mobile Menu Area End -->
        </header>
        <!-- Header Area End Here -->

        <?php echo $__env->make('layouts.notification', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        <?php echo $__env->yieldContent('content'); ?>
        
    <footer>
      <div class="footer-area-top">
      <div class="container">
          <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                  <div class="footer-box">
                        <h3>Social Links</h3>
                        <h4>
                            <strong>
                                <a href="" class="text-default" style="color: white;"><?php echo e(config('app_settings.application_title')); ?></a>
                            </strong>
                        </h4>
                        <p><?php echo e(config('app_settings.site_slogan')); ?></p>
                        <ul class="footer-social">
                              <li><a target="_blank" href="<?php echo e(config('app_settings.facebook_link')); ?>"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                              <li><a target="_blank" href="<?php echo e(config('app_settings.twitter_link')); ?>"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                              <li><a target="_blank" href="<?php echo e(config('app_settings.youtube_link')); ?>"><i class="fa fa-youtube" aria-hidden="true"></i></a></li>
                              <li><a target="_blank" href="<?php echo e(config('app_settings.instagram_link')); ?>"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                              <li><a target="_blank" href="<?php echo e(config('app_settings.linkedin_link')); ?>"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
                        </ul>
                  </div>
              </div>
              <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                  <div class="footer-box">
                      <h3>Important Links</h3>
                      <ul class="featured-links">
                          <li>
                              <ul>
                                    <?php if(strlen(config('app_settings.important_link_1')) > 1): ?>
                                        <li><a target="_blank" href="<?php echo e(config('app_settings.important_link_1')); ?>"><?php echo e(config('app_settings.important_link_1_name')); ?></a></li>
                                    <?php endif; ?>

                                    <?php if(strlen(config('app_settings.important_link_2')) > 1): ?>
                                        <li><a target="_blank" href="<?php echo e(config('app_settings.important_link_2')); ?>"><?php echo e(config('app_settings.important_link_2_name')); ?></a></li>
                                    <?php endif; ?>

                                    <?php if(strlen(config('app_settings.important_link_3')) > 1): ?>
                                        <li><a target="_blank" href="<?php echo e(config('app_settings.important_link_3')); ?>"><?php echo e(config('app_settings.important_link_3_name')); ?></a></li>
                                    <?php endif; ?>

                                    <?php if(strlen(config('app_settings.important_link_4')) > 1): ?>
                                        <li><a target="_blank" href="<?php echo e(config('app_settings.important_link_4')); ?>"><?php echo e(config('app_settings.important_link_4_name')); ?></a></li>
                                    <?php endif; ?>

                                    <?php if(strlen(config('app_settings.important_link_5')) > 1): ?>
                                        <li><a target="_blank" href="<?php echo e(config('app_settings.important_link_5')); ?>"><?php echo e(config('app_settings.important_link_5_name')); ?></a></li>
                                    <?php endif; ?>
                                  
                                    <?php if(strlen(config('app_settings.important_link_6')) > 1): ?>
                                      <li><a target="_blank" href="<?php echo e(config('app_settings.important_link_6')); ?>"><?php echo e(config('app_settings.important_link_6_name')); ?></a></li>
                                    <?php endif; ?>
                                  
                              </ul>
                          </li>

                      </ul>
                  </div>
              </div>
              <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                  <div class="footer-box">
                        <h3>Information</h3>
                        <ul class="corporate-address">
                            <li>
                                <i class="fa fa-home" aria-hidden="true"></i>
                                <?php echo e(config('app_settings.site_address')); ?>

                            </li>
                            <li>
                                <i class="fa fa-phone" aria-hidden="true"></i>
                                <a href="Tel:<?php echo e(config('app_settings.site_phone')); ?>"><?php echo e(config('app_settings.site_phone')); ?></a>
                            </li>
                            <li>
                                <i class="fa fa-envelope-o" ></i>
                                <?php echo e(config('app_settings.site_email')); ?>

                            </li>
                        </ul>

                  </div>
              </div>
              
                  </div>
              </div>
          </div>
          <div class="footer-area-bottom">
              <div class="container">
                  <div class="row">
                      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                          <p class="text-center">&copy; <?php echo e(date('Y')); ?> All Rights Reserved. <?php echo e(config('app_settings.application_title')); ?>.
                      </div>

                  </div>
              </div>
          </div>
      </footer>
      <!-- Footer Area End Here -->
  </div>
  <!-- Main Body Area End Here -->


  <!-- jquery-->
    <!-- Plugins js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/plugins.js" type="text/javascript"></script>
    <!-- Bootstrap js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/bootstrap.min.js" type="text/javascript"></script>
    <!-- WOW JS -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/wow.min.js"></script>
    <!-- Nivo slider js -->
    <script src="<?php echo e(url('public')); ?>/frontend/vendor/slider/js/jquery.nivo.slider.js" type="text/javascript"></script>
    <script src="<?php echo e(url('public')); ?>/frontend/vendor/slider/home.js" type="text/javascript"></script>
    <!-- Owl Cauosel JS -->
    <script src="<?php echo e(url('public')); ?>/frontend/vendor/OwlCarousel/owl.carousel.min.js" type="text/javascript"></script>
    <!-- Meanmenu Js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/jquery.meanmenu.min.js" type="text/javascript"></script>
    <!-- Srollup js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/jquery.scrollUp.min.js" type="text/javascript"></script>
    <!-- jquery.counterup js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/jquery.counterup.min.js"></script>
    <script src="<?php echo e(url('public')); ?>/frontend/js/waypoints.min.js"></script>
    <!-- Countdown js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/jquery.countdown.min.js" type="text/javascript"></script>
    <!-- Isotope js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/isotope.pkgd.min.js" type="text/javascript"></script>
    <!-- Magic Popup js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/jquery.magnific-popup.min.js" type="text/javascript"></script>
    <!-- Gridrotator js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/jquery.gridrotator.js" type="text/javascript"></script>
    <!-- Custom Js -->
    <script src="<?php echo e(url('public')); ?>/frontend/js/main.js" type="text/javascript"></script>
</body>

</html>
