<?php $__env->startSection('content_title'); ?>
    <strong> Video Galleries</strong>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="inner_body">
  <div class="content">
    <div class="row">
      <div class="col-lg-12">
        <div class="panel panel-default">
          <div class="panel-heading">
            <div class="row">
              <div class="col-sm-2">
                Video Gallery Manage
              </div>
              <div class="col-sm-6 text-right-">
                <a class="btn btn-primary btn-sm" href="javascript:void(0)" id="createNewVideoGallery"> Create New Video Gallery <i class="fa fa-plus"></i></a>
              </div>              
            </div>
          </div>
          <div class="panel-body">
            <div class="table-responsive">
              
              <table class="table table-stripped table-bordered data-table">
                  <thead>
                      <tr>
                          <th width="5%">No</th>
                          <th>Title</th>
                          <th>Link</th>
                          <th>Description</th>
                          <th width="12%">Action</th>
                      </tr>
                  </thead>
                  <tbody>
                  </tbody>
              </table>
            </div>
          </div>
          <div class="modal fade" id="ajaxModel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modelHeading"></h4>
                    </div>
                    <div class="modal-body">
                      <form id="VideoGalleryForm" name="VideoGalleryForm" class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                          <input type="hidden" name="gallery_id" id="gallery_id">
                          
                          <div class="form-group">
                              <label for="title" class="col-sm-2 control-label">Title</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" >
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="link" class="col-sm-2 control-label">Link</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="link" name="link" placeholder="Enter link" required="" value="" />
                              </div>
                          </div>
                          <div class="form-group">
                              <label for="description" class="col-sm-2 control-label">Description<br />(optional)</label>
                              <div class="col-sm-10">
                                  <input type="text" class="form-control" id="description" name="description" placeholder="Enter description" >
                              </div>
                          </div>
                          <div class="form-group">
                              <div class="col-sm-10 col-sm-offset-2">
                                  <button type="submit" class="btn btn-primary" id="saveBtn" value="create">Save Changes</button>
                              </div>
                          </div>
                           
                        </form>
                    </div>
                </div>
            </div>
         </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

  var base_url = '<?php echo e(url('public')); ?>';
  $(function () {

    var table = $('.data-table').on( 'error.dt', function ( e, settings, techNote, message ) {
      if(confirm('Please reload this page and check.')){
        location.reload();
      }
    }).DataTable({
        
        // dom: 'Blfrtip',
        dom: 'lfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],

        processing: true,
        serverSide: true,
        ajax: "<?php echo e(route('video_galleries.index')); ?>",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'title', name: 'title'},
            {data: 'link', name: 'link'},
            {data: 'description', name: 'description'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],

        drawCallback: function( settings ) {

        },
    });

    $('#createNewVideoGallery').click(function () {
        $('#saveBtn').val("create-VideoGallery");
        $('#gallery_id').val('');
        $('#VideoGalleryForm').trigger("reset");
        $('#modelHeading').html("Create New Video Gallery");
        $('#ajaxModel').modal('show');
    });

    $('body').on('click', '.editVideoGallery', function () {

      var gallery_id = $(this).data('id');

      $.get("<?php echo e(route('video_galleries.index')); ?>" +'/' + gallery_id +'/edit', function (data) {

          $('#modelHeading').html("Edit Video Gallery");

          $('#saveBtn').val("edit-user");

          $('#ajaxModel').modal('show');

          $('#gallery_id').val(data.id);

          $('#title').val(data.title);

          $('#description').val(data.description);
          $('#link').val(data.link);
      })

   });

    $('#VideoGalleryForm').submit(function(e) {
        e.preventDefault();
        // $(this).html('Sending..');

        var form_data = new FormData(this);
        // console.log("form_data", form_data);return false;

        $.ajax({

          data: form_data,
          url: "<?php echo e(route('video_galleries.store')); ?>",
          type: "POST",
          cache: false,
          contentType: false,
          processData: false,

          success: function (data) {

              $('#VideoGalleryForm').trigger("reset");
              $('#ajaxModel').modal('hide');
              table.draw();
          },
          error: function (data) {
              console.log('Error:', data);
              $('#saveBtn').html('Save Changes');
          }
      });
    });

    $('body').on('click', '.deleteVideoGallery', function () {

        var gallery_id = $(this).data("id");
        if( ! confirm("Are You sure want to delete !") ){
          return false;
        }

        $.ajax({
            type: "DELETE",
            url: "<?php echo e(route('video_galleries.store')); ?>"+'/'+gallery_id,
            success: function (data) {

                table.draw();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    });


  });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('aceclientv.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>