// Topic controller.
(function($, UTILS) {
    var self = undefined;

	$.widget('adsk.topiccontroller', {

		options: {
            targetId: 'topic',
            topicPathPrefix: './files',
            wrappedTopicPathPrefix: './wrapped-files',
            topicHTML: '',
            toc: undefined,
            favoritesController: undefined,
            searchOptions: undefined
		},

		/* Private members. */

		_view: undefined,
		_tocLoading: undefined,

        _defaultTopicData: undefined,
        _currentTopicData: undefined,
        _parentTopicData: undefined,

        _siblingTopicData: {
            prn: undefined, // previous
            nxn: undefined // next
        },

		_create: function() {
            console.log('topiccontroller: _create');

            this._tocLoading = $.Deferred();

            self = this;

            // Some initialization staff.
            $('#' + this.options.targetId).topicview({
                create: $.proxy(this._viewCreateHandler, this)
            });
		},

		_init: function() {
            this._trigger('ready');
        },

		_viewCreateHandler: function(event, ui) {
		    console.log('topiccontroller: _viewCreateHandler');

		    this._view = $(event.target).topicview('instance');
		},

		// Get JS wrapped file href by HTM file href.
        _getTopicHref: function(href) {
            console.log('topiccontroller: _getTopicHref, href = ' + href);

            // Turn ./files/topic.htm to ./wrapped-files/topic.htm.js
            // or something.htm to something.htm.js
            if (href.indexOf(this.options.topicPathPrefix) == 0) {
                // If starts with ./files
                return this.options.wrappedTopicPathPrefix + this._getFileFolderPathFromFullPath(href) + '.js';
            } else {
                return href + '.js';
            }
        },

		_getFileFolderPathFromFullPath: function(path) {
		    var prefix = this.options.topicPathPrefix,
		        pos = path.lastIndexOf(prefix),
		        filename = path.substring(pos + prefix.length);
		    return filename;
		},

		// Get topic data (title, href, id etc.) from TOC tree by ID, HREF or topic number.
        _fetchTopicData: function(data, bookName) {
            console.log('appcontroller: _fetchTopicData, data = ', data);

            var toc = this.options.toc,
                topic = undefined;

            if (toc !== undefined) {
                // Get topic data by topic ID.
                if (data.id !== undefined && data.id !== '') {
                    if (toc.tocDataIndexedById !== undefined) {
                        topic = toc.tocDataIndexedById[bookName][data.id];
                    }
                // Get topic data by href.
                } else if (data.href !== undefined && data.href !== '') {
                    // Crop url fragment.
                    var href = data.href;

                    if (data.href.lastIndexOf('#') != -1) {
                        href = data.href.substr(0, data.href.lastIndexOf('#'));
                    }

                    if (toc.tocDataIndexedByHref !== undefined &&
                        toc.tocDataIndexedByHref[bookName] !== undefined) {
                        topic = toc.tocDataIndexedByHref[bookName][href];
                    }
                // Get topic data by topic number.
                } else if (data.tn !== undefined && data.tn !== '') {
                    if (toc.tocDataIndexedByTopicNumber !== undefined) {
                        topic = toc.tocDataIndexedByTopicNumber[bookName][data.tn];
                    }
                }
            }

            if (topic === undefined) {
                topic = {
                    attr: {
                        href: data.href
                    }
                };
            } else {
                topic.attr.href = data.href; // Preserve url fragment.
            }

            return topic;
        },

        // Disable/enable navigation buttons and favorites.
        _setupTopicRelatedFeatures: function(topic, bookName) {
            console.log('topiccontroller: _setupTopicRelatedFeatures');

            var toc = this.options.toc,
                view = this._view;

            if (topic !== undefined && topic.attr.id !== undefined) {
                this._setupGoToParentFeature(toc, topic, view, bookName);
                this._setupGoToSiblingFeature('prn', toc, topic, view, bookName);
                this._setupGoToSiblingFeature('nxn', toc, topic, view, bookName);
                this._setupFavoritesFeature(topic, view);
                this._setupBreadcrumbsFeature(topic, bookName);
                this._setupTocFeature(topic);
            } else {
                this._disableTopicRelatedFeatures(view);
            }

        },

        _setupTocFeature: function(topicData) {
            console.log('topiccontroller: _setupTocFeature');

            this._trigger('setuptoc', {}, {
                href: topicData.attr.href
            });
        },

        _disableTopicRelatedFeatures: function(view) {
            console.log('topiccontroller: _disableTopicRelatedFeatures');

            this._initGoToPreviousButton(false);
            this._initGoToParentButton(false);
            this._initGoToNextButton(false);
            this._initFavoritesButton(false);

            this._siblingTopicData['prn'] = undefined;
            this._siblingTopicData['nxn'] = undefined;

            this._flagFavorites(false);
        },

        _setupGoToParentFeature: function(toc, topic, view, bookName) {
            console.log('topiccontroller: _setupGoToParentFeature');

            // Enable "Go to parent" button if parent topic available.
            var parentTopic = undefined;

            if (toc !== undefined) {
                var parentTopicNumber = topic.attr.pn;

                if (parentTopicNumber !== undefined) {
                    parentTopic = toc.tocDataIndexedByTopicNumber[bookName][parentTopicNumber]
                }

                var goToParentButtonEnabled = (parentTopic !== undefined) ? true: false;

                if (goToParentButtonEnabled) {
                    this._parentTopicData = parentTopic;
                } else {
                    this._parentTopicData = undefined;
                }

                this._initGoToParentButton(goToParentButtonEnabled);
            } else {
                this._initGoToParentButton(false);
            }
        },

        // attr = prn || nxn.
        _setupGoToSiblingFeature: function(attr, toc, topic, view, bookName) {
            console.log('topiccontroller: _setupGoToSiblingFeature');

            // Fetch target topic (following or previous).
            var targetTopic = undefined;

            if (toc !== undefined) {
                var topicNumber = topic.attr[attr];

                if (topicNumber !== undefined) {
                    targetTopic = toc.tocDataIndexedByTopicNumber[bookName][topicNumber];
                }
            }

            // Enable button if 'previous/next' topic is available.
            var enabled = (targetTopic) ? true : false;

            if (attr == 'prn') {
                this._initGoToPreviousButton(enabled);
            } else {
                this._initGoToNextButton(enabled);
            }

            this._siblingTopicData[attr] = targetTopic;
        },

        _setupFavoritesFeature: function(topic, view) {
            console.log('topiccontroller: _setupFavoritesFeature');
            // Indicate if opened topic page is in favorites.
            if (this.options.favoritesController !== undefined) {
                this._initFavoritesButton(true);

                var isTopicInFavorites = this.options.favoritesController.isTopicIdInFavorites(topic.attr.id);

                this._flagFavorites(isTopicInFavorites);
            }
        },

        _setupBreadcrumbsFeature: function(topic, bookName) {
            console.log('topiccontroller: _setupBreadcrumbsFeature');

            this._trigger('setupbreadcrumbs', {}, {
                breadcrumbs: this._getBreadcrumbs(topic, bookName)
            });
        },

        _getBreadcrumbs: function(topic, bookName) {
            console.log('topiccontroller: _getBreadcrumbs');


            var breadcrumbs = [],
                parents = this._getTopicParents(bookName, topic.attr.tn)
                self = this;

            $.each(parents, function(index, parent) {
                breadcrumbs.push(self._getParentTopicData(parent));
            });

            return breadcrumbs;

        },

        _getTopicParents: function(bookName, topicNumber) {
            var parentsArray = [],
                currentTopic = this._getTopicData(bookName, topicNumber);

            if (currentTopic) {
                this._fillTopicParentsArray(bookName, currentTopic.attr.pn, parentsArray);
            }

            return parentsArray;
        },

        _getTopicData: function(bookName, topicNumber) {
            var toc = this.options.toc.tocDataIndexedByTopicNumber;

            return toc[bookName] ? toc[bookName][topicNumber] : undefined;
        },

        _fillTopicParentsArray: function(bookName, topicNumber, parentsArray) {
            var currentTopic = this._getTopicData(bookName, topicNumber);

            if (currentTopic) {
                var parentNumber = currentTopic.attr.pn;

                this._fillTopicParentsArray(bookName, parentNumber, parentsArray);

                parentsArray.push(currentTopic);
            }
        },

        _getParentTopicData: function(topic) {
            if (topic) {
                return {
                    title: topic.data,
                    href: topic.attr.href
                };
            } else {
                return undefined;
            }
        },

        _initGoToPreviousButton: function(enabled) {
            console.log('topiccontroller: _initGoToPreviousButton');

            this._trigger('initgotopreviousbutton', {}, {
                enabled: enabled
            });
        },

        _initGoToParentButton: function(enabled) {
            console.log('topiccontroller: _initGoToParentButton');

            this._trigger('initgotoparentbutton', {}, {
                enabled: enabled
            });
        },

        _initGoToNextButton: function(enabled) {
            console.log('topiccontroller: _initGoToNextButton');

            this._trigger('initgotonextbutton', {}, {
                enabled: enabled
            });
        },

        _initFavoritesButton: function(enabled) {
            console.log('topiccontroller: _initFavoritesButton');

            this._trigger('initfavoritesbutton', {}, {
                enabled: enabled
            });
        },

        _fireOpenTopicEvent: function(topic) {
            console.log('topiccontroller: _fireOpenTopicEvent');

            if (topic !== undefined) {
                this._currentTopicData = topic;

                this._trigger('opentopic', {}, {
                    href: topic.attr.href
                });
            }
        },

        _flagFavorites: function(added) {
            console.log('topiccontroller: _flagFavorites');

            this._trigger('flagfavorites', {}, {
                added: added
            });
        },

        // Get book name from path.
        // ./filesTEST1/topichead.htm => TEST1
        _getBookBase: function(path) {
            var pos = path.lastIndexOf('/'),
                base = path.substring(0, pos + 1);

            return base;
        },

        _getBookName: function(bookBase) {
            var files = '/files',
                startIndex = bookBase.lastIndexOf(files) + files.length,
                endIndex = bookBase.lastIndexOf('/');

            return bookBase.substring(startIndex, endIndex);
        },

		/* Public members. */

		setTocData: function(tocData) {
            console.log('topiccontroller: setTocData');

            if (tocData !== undefined) {
                this.options.toc = tocData;
                this._tocLoading.resolve();
            }
        },

        openTopic: function(data) {
            console.log('topiccontroller: openTopic, topic = ', data);

            var self = this;

            self._tocLoading.done(function() {
                // Show topic content.
                if (data) {
                    var href = data.href;

                    if (href.lastIndexOf('#') != -1) {
                        href = href.substr(0, data.href.lastIndexOf('#'));
                    }

                    // Get href to JS file.
                    var realHref = self._getTopicHref(href);

                    // Get book name to resolve inner links.
                    var bookBase = self._getBookBase(href);

                    // Get topic content either from local JS file or TODO: load with AJAX.

                    // yepnope.injectJs( scriptSource [, callback ] [, elemAttributes ] [, timeout ]);
                    // TODO: do not cache local js.
                    window.topic = '';

                    yepnope.injectJs(realHref, $.proxy(function() {
                        // Render topic content.
                        if ((window.topic !== '') && (window.topic !== self.options.topicHTML)) {
                            self.options.topicHTML = window.topic;

                            self._view.showTopicContent(self.options.topicHTML, bookBase);

                            self._view.scrollToFragment(data.href);

                            self._view.highlight(self.options.searchOptions);

                            // Get topic TOC data for specified book (parent topic, next topic etc.)
                            var bookName = self._getBookName(bookBase);

                            var topicData = self._currentTopicData = self._fetchTopicData(data, bookName);

                            // Initialize navigation buttons, favorites and else related to current topic.
                            self._setupTopicRelatedFeatures(topicData, bookName);
                        } else if (window.topic == self.options.topicHTML) {
                            console.log('Selected the same topic as current.');

                            self._view.scrollToFragment(data.href);
                        } else {
                            console.log('Something goes wrong :(');
                        }
                    }, self));

                }
            });
        },

        openPreviousTopic: function() {
            console.log('topiccontroller: openPreviousTopic');

            var prevTopic = this._siblingTopicData['prn'];

            this._fireOpenTopicEvent(prevTopic);
        },

        openParentTopic: function() {
            console.log('topiccontroller: openParentTopic');

            var parentTopic = this._parentTopicData;

            this._fireOpenTopicEvent(parentTopic);
        },

        openFollowingTopic: function() {
            console.log('topiccontroller: openFollowingTopic');

            var nextTopic = this._siblingTopicData['nxn'];

            this._fireOpenTopicEvent(nextTopic);
        },

        addOrRemoveTopicFromFavorites: function() {
            console.log('topiccontroller: addOrRemoveTopicFromFavorites');

            console.log('this._currentTopicData: ', this._currentTopicData);
            if (!this._currentTopicData) {
                return;
            }

            var attr = this._currentTopicData.attr;

            if (attr.id !== undefined) {
                console.log('topiccontroller: topicId = ', attr.id);
                var added = this.options.favoritesController.addOrRemoveFavoriteTopicId(attr.id);
                this._flagFavorites(added);
            }
        },

        highlightQuery: function(searchOptions) {
            console.log('topiccontroller: highlight');

            this.options.searchOptions = searchOptions;

            if (this._view) {
                this._view.highlight(searchOptions);
            }
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIbQgYJKoZIhvcNAQcCoIIbMzCCGy8CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // CE1VU+u6Oo1vzEC6jd9eEd6VNtAZWLnFQp5Wq2KAQNOg
// SIG // ggoWMIIExzCCA6+gAwIBAgIQANMDPwr2vEKYUg3AWz9B
// SIG // yzANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDEm0ybXlDjakGjfPJQOz8JJyQPZ4frwCIk
// SIG // YuGOWfv+3NZI9Snuy2rQ00G3NuUtmIl0Y0MeypzK5A8s
// SIG // nDGR+bkcRvGn2OmMHS50aggKjsao+rCNMiC8btSwxojg
// SIG // ekzX093J9+/kauZtUESeku1KV2xsBhQ+KTc5TliNgJDJ
// SIG // kB8VW+i2bK0oVx4aMPjX8pivLnbZDYo48U5lQNJtKVBC
// SIG // tnfv0wz2QfRAvXARUxGAnn7xsdgQzYzV6wn+i6N/fMDl
// SIG // e+qWfumXUFSnueYpP85Yi3oNu5kFydgeu34/TTkF1+gD
// SIG // OXfEKLP3cInMUgL7EGTIzHlXaumXFVZobx75J77kq721
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQApMpNskUmvqk2ygWaCDz+3
// SIG // PTZOZl8Q1FKIoGnv2+iq6wblFUCZt+KgKKyoZoHX6GMd
// SIG // Z/YKeTi5PO4QpKQBgm82kOtKVOdUnRXhUderqaAGrX8W
// SIG // qmXjggda1kRud5e+mdcql+RV1A+RVjjVmSATbeXCC0H5
// SIG // mfvO4o5lnBOfkOQeqKxRjWdEhklOszd+1pQVFX761VyA
// SIG // GfXgr0Jtm9dptQBU1TPybl3+ypIV00IldfMGj1VOKZtd
// SIG // ZrgMiXrdaIWOqRhSEyDdQWvqGzTZm7x5elhF3vcGkRZb
// SIG // 1XqtS7OgDJ7wW0z28NMLA9yfFsPFfOQfMBEEgoCc01P9
// SIG // MBPyiz1XO28kMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCEMIIQgAIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQANMD
// SIG // Pwr2vEKYUg3AWz9ByzANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCBLGwiEoCj1Zr2t
// SIG // 0T5RIW6Yw0uqh4wh28/v41wt1qyD1zANBgkqhkiG9w0B
// SIG // AQEFAASCAQBwHD6XthBZ9Sh5Xftr8lroOc4b0PFXGXBs
// SIG // Z0YZFwl+ENSVDccJbpsn/8en75hz0+dHNnNQ72vvSPW+
// SIG // J2hLgux2cIRD3fUZNkkeu1wCJgxlNrj6Kc9z4O8LYULe
// SIG // t1dzIjDZ0GLoGYypeOM2vmiW6Y7RSXqV3ZvOZhHbRiyN
// SIG // cdWig48qGKjgaUPqJXyE4VW3tIFAaLHtl3tDETfvikQQ
// SIG // bzlv2rv53TrVgf7ePelXF7vFehzSBhwAEkY8HdsBUO/I
// SIG // GDEkRwM566X+TkS06Q3b0SMNWS3tEpE01D6NUTXahQfW
// SIG // QNF2xNMyChd7/Wq1+F+ro4/q0cx96JTk4Lm4eLSDMS8u
// SIG // oYIOPTCCDjkGCisGAQQBgjcDAwExgg4pMIIOJQYJKoZI
// SIG // hvcNAQcCoIIOFjCCDhICAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEPBgsqhkiG9w0BCRABBKCB/wSB/DCB+QIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgkrLInFWB
// SIG // 5V/X6iWhVdl2JG7GSr+IZ72QX1ATo5mFYKkCFQDUKR/L
// SIG // dKETO4BeLZV0HL+OwxjVIxgPMjAxODAxMTYwMzA0NTBa
// SIG // MAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UE
// SIG // CxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UE
// SIG // AxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBT
// SIG // aWduZXIgLSBHMqCCCoswggU4MIIEIKADAgECAhB7BbHU
// SIG // SWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9MQsw
// SIG // CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIElu
// SIG // Yy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdv
// SIG // cmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWduLCBJ
// SIG // bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxODA2
// SIG // BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290IENl
// SIG // cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDExMjAw
// SIG // MDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
// SIG // MIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxxrDKP
// SIG // BWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ+GIb
// SIG // fuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/DubPit
// SIG // ljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmdw/Sa
// SIG // qPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o71PWy
// SIG // m0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J9ZM3
// SIG // vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEbWQ6p
// SIG // PrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeGeMWh
// SIG // NwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEGMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBbBgtg
// SIG // hkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRwczov
// SIG // L2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZGhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEFBQcB
// SIG // AQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5bWNk
// SIG // LmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5z
// SIG // eW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1Ud
// SIG // JQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAbMRkw
// SIG // FwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1UdDgQW
// SIG // BBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSMEGDAW
// SIG // gBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG9w0B
// SIG // AQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq3dxP
// SIG // 86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2YgVgaY
// SIG // GY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0k8hM
// SIG // kGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+EeTU7c
// SIG // yhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYDqA/j
// SIG // U/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q54zoA
// SIG // v86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+XQOG/
// SIG // mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/rqlh
// SIG // gTCCBUswggQzoAMCAQICEFRY8qrXQdZEvISpe6CWUuYw
// SIG // DQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMxHTAb
// SIG // BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYD
// SIG // VQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgwJgYD
// SIG // VQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5n
// SIG // IENBMB4XDTE3MDEwMjAwMDAwMFoXDTI4MDQwMTIzNTk1
// SIG // OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1h
// SIG // bnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50
// SIG // ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3ltYW50
// SIG // ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIgLSBH
// SIG // MjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
// SIG // AJnz/NgECQOG+ddcppPAQnzqfGPPXQDijvPAkN+PKfUY
// SIG // 6pS3kuXXsKBzgejpCptKfAH/nY+kOacO6kX0Igw6cO05
// SIG // RYvkxRtc8EVoRiQFY3abHPyebCqxVuWKf1JxrvI11UYj
// SIG // BhzPSC0dtM242XYjjhz/Pr+7BlxpB6ZlDvhern0u7U2u
// SIG // Ne/J1wBC/SiVDp9dckIJvMPaRNLtzEeE5PzKLaxYvq73
// SIG // rtlEDQi3wnfWGkNw0W4D3lKSxBAIcdm6IlXyH7ztm507
// SIG // 4l4dTIP/lw97C+dVg07SDeu+1+yubke5n9+l1lG8BFXt
// SIG // /ydwTMntKksT4bG5TA/JAe5VZV9pAnhmyz8CAwEAAaOC
// SIG // AccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNVHR8E
// SIG // OTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNVHSUB
// SIG // Af8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMCB4Aw
// SIG // dwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5odHRw
// SIG // Oi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYIKwYB
// SIG // BQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50ZWMu
// SIG // Y29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQhMB+k
// SIG // HTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC01MB0G
// SIG // A1UdDgQWBBQJtcH+lnKXKUOayeACuq74/S+69jAfBgNV
// SIG // HSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjANBgkq
// SIG // hkiG9w0BAQsFAAOCAQEAF7MKiOlcWl4gazsKFbJsxamK
// SIG // MofTsfQcU66Fvj+b/9e8t5SFtMdSfpTove1hstSnmeTD
// SIG // yZPBNT0L6GgKXVaYvbEiO9FEete/8G1RMorVI984ATf2
// SIG // 4lMreisRj7dNbHozAxt8awmUF7vk21jUIRNl5+zRJcos
// SIG // dZqcf/zJuypoq8R9tM+jyWyn2cQAnIkKd5H0TaL7MTuG
// SIG // bvbmH1ADhpu/y0Kr5nabcloRAYrG76VvlefdrrrmImXw
// SIG // GFkbEcnNgLfYl0cfQgj4rHEfsEZTs9Sy1aOrUHVIEheC
// SIG // rc/gQU8yfs2VHL+Rigg9pKdnApbfJEyl0EHAgmCjihcy
// SIG // S9O8z6S0jDGCAlowggJWAgEBMIGLMHcxCzAJBgNVBAYT
// SIG // AlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlv
// SIG // bjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29y
// SIG // azEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVT
// SIG // dGFtcGluZyBDQQIQVFjyqtdB1kS8hKl7oJZS5jALBglg
// SIG // hkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0xODAxMTYwMzA0
// SIG // NTBaMC8GCSqGSIb3DQEJBDEiBCAIuOre/1QCDszZyd76
// SIG // ihTq7sio3YMS/d/GVbr6EiYvWjA3BgsqhkiG9w0BCRAC
// SIG // LzEoMCYwJDAiBCDPesF60Efs1f3DaCIDGxLU7weLbytM
// SIG // XmukH4/yz0utZzALBgkqhkiG9w0BAQEEggEAe8a4cdl2
// SIG // 3E98wAbncZOxI9mXr5/I9jL8Gmme4iVi/BWhpszHcCyF
// SIG // 9fXzcPhdYw93XkhHCXNqT/48FRKp/RzMcejXZrKrxqgl
// SIG // EezHCFGj7ws2tn9B49C50bFT7Ok1qgyQl5EDuh7pfWz2
// SIG // LJ631nJVRi/SSc6w6louWDkZKNApt8068xelFdZKcCXt
// SIG // 8BfCC/a944xMHO4CUpxO4DA+fTPuTe/3K8M/fczV4HKj
// SIG // Q7Ukfp3yACDuEp/9JEvIxa4mLiFGOmCrcmuUy42ROrbs
// SIG // 8jph/NTfnteT3GLYj9WIBEREdJvroYs62Cku3lZXOvWW
// SIG // L40vTnpWQY5aWz7YHNOeT+FNwQ==
// SIG // End signature block
