// Topic controller.
(function($) {
	$.widget('adsk.topiccontroller', {
		options: {
		    defaultTopicHref: undefined,
		    shareController: undefined,
            favoritesController: undefined,
		    pageIds: ['navigation', 'search', 'page', 'share'],
		    toc: undefined,
		    orientationData: undefined
		},

        /* Private members. */

		_view: undefined,
		_defaultTopicData: undefined,
		_currentTopicData: undefined,
		_parentTopicData: undefined,

		_siblingTopicData: {
		    prn: undefined, // previous
		    nxn: undefined // next
		},

        // This method is the widget's constructor.
		_create: function() {
            console.log('topiccontroller: _create');

            // Create view and attach event handlers.
            $('#topic').topicview({
                create:     $.proxy(this._viewCreateHandler, this),
                buttontap:  $.proxy(this._viewButtontapHandler, this),
                swipeleft:  $.proxy(this._viewSwipeLeftHandler, this),
                swiperight: $.proxy(this._viewSwipeRightHandler, this),
                opentopic:  $.proxy(this._viewOpentopicHandler, this)
            });
		},

		_viewOpentopicHandler: function(event, data) {
		    console.log('topiccontroller: _viewOpentopicHandler');

		    this._trigger('opentopic', {}, data);
		},

        // View widget 'create' event handler.
		_viewCreateHandler: function(event, ui) {
            console.log('topiccontroller: _viewCreateHandler');

            this._view = $(event.target).topicview("instance");
		},

		_openDefaultTopic: function(defaultTopic) {
		    console.log('topiccontroller: _openDefaultTopic');

            this._trigger('opentopic', {}, {
                href: defaultTopic.attr.href
            });
		},

		_getDefaultTopicData: function() {
		    console.log('topiccontroller: _getDefaultTopicData');

		    var href = this.options.defaultTopicHref;

            var topic = this._fetchTopicData({
                href: href
            });

            // If no topic specified in TOC tree data,
            // use config provided HREF to load default topic.
            if (topic === undefined) {
                topic = {
                    /* TODO: add default topic title into publication config. */
                    data: undefined,
                    attr: {
                        href: href
                    }
                };
            }

            return topic;
		},

        // Disable/enable navigation buttons and favorites.
		_setupTopicRelatedFeatures: function(topic) {
		    console.log('topiccontroller: _setupTopicRelatedFeatures');

            var toc = this.options.toc,
            	view = this._view;

		    if (topic !== undefined && topic.attr.id !== undefined) {
                this._setupGoBackFeature(view);

                this._setupGoToParentFeature(toc, topic, view);
                this._setupGoToSiblingFeature('prn', toc, topic, view);
                this._setupGoToSiblingFeature('nxn', toc, topic, view);

                this._setupFavoritesFeature(topic, view);
                // TODO: prev and next features.
		    } else {
		        this._disableTopicRelatedFeatures(view);
		    }

		},

		_disableTopicRelatedFeatures: function(view) {
		    console.log('topiccontroller: _disableTopicRelatedFeatures');

		    view.initGoToParentButton(false);
            view.initFavoritesButton(false);
            view.initGoBackButton(false);

            this._siblingTopicData['prn'] = undefined;
            this._siblingTopicData['nxn'] = undefined;

            view.flag(false);
		},

		_setupGoBackFeature: function(view) {
		     console.log('topiccontroller: _setupGoBackFeature');

             view.initGoBackButton(history.length > 0);
		},


		_setupGoToParentFeature: function(toc, topic, view) {
		    console.log('topiccontroller: _setupGoToParentFeature');

		    // Enable "Go to parent" button if parent topic available.
		    var parentTopic = undefined;

            if (toc !== undefined) {
                var parentTopicNumber = topic.attr.pn,
                    bookName = "";

                if (parentTopicNumber !== undefined) {
                    parentTopic = toc.tocIndexedByTopicNumber[bookName][parentTopicNumber]
                }

                var goToParentButtonEnabled = (parentTopic !== undefined) ? true: false;

                if (goToParentButtonEnabled) {
                    this._parentTopicData = parentTopic;
                } else {
                    this._parentTopicData = undefined;
                }

                view.initGoToParentButton(goToParentButtonEnabled);
            } else {
                view.initGoToParentButton(false);
            }
		},


		// attr = prn || nxn.
		_setupGoToSiblingFeature: function(attr, toc, topic, view) {
		    console.log('topiccontroller: _setupGoToSiblingFeature');

		    // Enable "GoTo" button if 'previous/next' topic available.
		    var targetTopic = undefined;

            if (toc !== undefined) {
                var topicNumber = topic.attr[attr],
                    bookName = '';

                if (topicNumber !== undefined) {
                    targetTopic = toc.tocIndexedByTopicNumber[bookName][topicNumber];
                }
            }

            this._siblingTopicData[attr] = targetTopic;
		},

		_setupFavoritesFeature: function(topic, view) {
		    console.log('topiccontroller: _setupFavoritesFeature');

		    view.initFavoritesButton(true);

		    // Indicate if opened topic page is in favorites.
            var isTopicInFavorites = this.options.favoritesController.isTopicIdInFavorites(topic.attr.id);
            view.flag(isTopicInFavorites);
		},

		_isPageId: function(id) {
            return ($.inArray(id, this.options.pageIds) > -1);
		},

		_makePageCurrentById: function(id) {
		    console.log('topiccontroller: _makePageCurrentById, id = ', id);

		    if (this._isPageId(id)) {
                this._trigger('showpage', {}, { id: id });
            }
		},

		_createShareController: function() {
		    console.log('topiccontroller: _createShareController');

            this.options.shareController = $.adsk.sharecontroller({
                back:               $.proxy(this._backToPreviousPage, this),
                shareButtonOffset:  this.getShareButtonOffset(),
                orientationData:    this.options.orientationData
            });
		},

		_viewButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _viewButtontapHandler');

            id = id.substring('topic-'.length);
            var handlerName = '_' + id + 'ButtontapHandler';
            this[handlerName](event, id);
		},

        _setTopicTitleToShare: function(title){
            console.log('topiccontroller: _setTopicTitleToShare', title);

            if (this.options.shareController !== undefined) {
                this.options.shareController._setCurrentTopicTitle(title);
            }
        },

		_shareButtontapHandler: function(event, id) {
		    // Create share controller lazily.
		    var controller = this.options.shareController;

		    if (controller === undefined) {
                this._createShareController();
                controller = this.options.shareController;
            }

            this._makePageCurrentById(id);
            this._setTopicTitleToShare(this._currentTopicData.data);
            controller.refresh(this.getShareButtonOffset());
		},

		_parentButtontapHandler: function(event, id) {
		    var parentTopic = this._parentTopicData;

            if (parentTopic !== undefined) {
                this._currentTopicData = parentTopic;

                this._trigger('opentopic', {}, {
                    href: parentTopic.attr.href
                });
            }
		},

		_favoritesButtontapHandler: function(event, id) {
		    var attr = this._currentTopicData.attr;
		    if (attr.id !== undefined) {
                var added = this.options.favoritesController.addOrRemoveFavoriteTopicId(attr.id);
                this._view.flag(added);
            }
		},

		_navigationButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _navigationButtontapHandler');

		    this._makePageCurrentById(id);
		},

		_backButtontapHandler: function() {
		    console.log('topiccontroller: _backButtonHandler');

		    history.go(-1);
		},

		_homeButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _homeButtontapHandler');

            this._openDefaultTopic(this._defaultTopicData);
		},

		_searchButtontapHandler: function(event, id) {
            console.log('topiccontroller: _searchButtontapHandler');

            this._makePageCurrentById(id);

            this._trigger('setsuggestiondata', {}, [this._getTopicSearchData()]);
        },

        _viewSwipeRightHandler: function(event) {
            console.log('topiccontroller: _viewSwipeRightHandler');

            var prevTopic = this._siblingTopicData['prn'];

            if (prevTopic !== undefined) {
                this._currentTopicData = prevTopic;

                this._trigger('opentopic', {}, {
                    href: prevTopic.attr.href
                });
            }
        },

        _viewSwipeLeftHandler: function(event) {
            console.log('topiccontroller: _viewSwipeLeftHandler');

            var nextTopic = this._siblingTopicData['nxn'];

            if (nextTopic !== undefined) {
                this._currentTopicData = nextTopic;

                this._trigger('opentopic', {}, {
                    href: nextTopic.attr.href
                });
            }
        },

        _getTopicSearchData: function(){
            console.log('topiccontroller: _getTopicSearchData');

            return {data: document.getElementById('body-content'),
                    type: 'topic'};
        },

        // Tells the view to load topic if it is specified.
		_showTopicContent: function(topic) {
            console.log('topiccontroller: _showTopicContent, ', topic);

            if (topic !== undefined) {
                console.log('topic data: ', topic);

                var href = topic.attr.href,
                    title = topic.data;

                // Get book name to resolve inner links.
                var bookBase = this._getBookBase(href);

                this._setTopicTitleToShare(title);
                this._view.loadPage(href, title, bookBase);
            }
        },

        // Get topic data (title, href, id etc.) from TOC tree by ID, HREF or topic number.
		_fetchTopicData: function(data) {
		    console.log('topiccontroller: _fetchTopicData');

            var toc = this.options.toc,
                bookName = '',
                topic = undefined;

            if (toc !== undefined) {
                // Get topic data by topic ID.
                if (data.id !== undefined && data.id !== '') {
                    if (toc.tocIndexedById !== undefined) {
                        topic = toc.tocIndexedById[bookName][data.id];
                    }
                // Get topic data by href.
                } else if (data.href !== undefined && data.href !== '') {
                    // Crop url fragment.
                    var href = data.href;
                    if (data.href.lastIndexOf('#') != -1) {
                        href = data.href.substr(0, data.href.lastIndexOf('#'));
                    }

                    if (toc.tocIndexedByHref !== undefined) {
                        topic = toc.tocIndexedByHref[bookName][href];
                    }
                // Get topic data by topic number.
                } else if (data.tn !== undefined && data.tn !== '') {
                    if (toc.tocIndexedByTopicNumber !== undefined) {
                        topic = toc.tocIndexedByTopicNumber[bookName][data.tn];
                    }
                }
            }

            if (topic === undefined) {
                topic = {
                    attr: {
                        href: data.href
                    }
                };
            } else {
                topic.attr.href = data.href; // Preserve url fragment.
            }

            return topic;
		},

		_backToPreviousPage: function() {
            console.log('topiccontroller: _backToPreviousPage');

            this._trigger('back');
        },

        // Get book name from path.
        // ./filesTEST1/topichead.htm => TEST1
        _getBookBase: function(path) {
            var pos = path.lastIndexOf('/'),
                base = path.substring(0, pos + 1);

            return base;
        },

        _getBookName: function(bookBase) {
            var files = '/files',
                startIndex = bookBase.lastIndexOf(files) + files.length,
                endIndex = bookBase.lastIndexOf('/');

            return bookBase.substring(startIndex, endIndex);
        },

		/* Public members. */

        resize: function(data) {
            console.log('topiccontroller: resize');

            this.options.orientationData = data;

            this._view.resize();

            var controller = this.options.shareController;
            if (controller !== undefined) {
                controller.resize(data);
                controller.refresh(this.getShareButtonOffset());
            }
        },

        setTocData: function(data) {
            console.log('topiccontroller: setTocData, ');

            this.options.toc = data;

            // Try to fetch default topic data again.
            this._defaultTopicData = this._getDefaultTopicData();
        },

		openTopic: function(data) {
		    console.log('topiccontroller: openTopic: ', data);

            if (data === undefined || $.isEmptyObject(data)) {
                return;
            }

		    var topic = this._currentTopicData = this._fetchTopicData(data);

		    this._showTopicContent(topic);
		    this._setupTopicRelatedFeatures(topic);
		},

		getShareButtonOffset: function() {
            console.log('topiccontroller: getShareButtonOffset');

            return this._view.getShareButtonOffset();
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIbQQYJKoZIhvcNAQcCoIIbMjCCGy4CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // ZNeqXaznveTUyb4BWTeZwLpse+f6/8bZbbv7BhFkGcCg
// SIG // ggoWMIIExzCCA6+gAwIBAgIQANMDPwr2vEKYUg3AWz9B
// SIG // yzANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDEm0ybXlDjakGjfPJQOz8JJyQPZ4frwCIk
// SIG // YuGOWfv+3NZI9Snuy2rQ00G3NuUtmIl0Y0MeypzK5A8s
// SIG // nDGR+bkcRvGn2OmMHS50aggKjsao+rCNMiC8btSwxojg
// SIG // ekzX093J9+/kauZtUESeku1KV2xsBhQ+KTc5TliNgJDJ
// SIG // kB8VW+i2bK0oVx4aMPjX8pivLnbZDYo48U5lQNJtKVBC
// SIG // tnfv0wz2QfRAvXARUxGAnn7xsdgQzYzV6wn+i6N/fMDl
// SIG // e+qWfumXUFSnueYpP85Yi3oNu5kFydgeu34/TTkF1+gD
// SIG // OXfEKLP3cInMUgL7EGTIzHlXaumXFVZobx75J77kq721
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQApMpNskUmvqk2ygWaCDz+3
// SIG // PTZOZl8Q1FKIoGnv2+iq6wblFUCZt+KgKKyoZoHX6GMd
// SIG // Z/YKeTi5PO4QpKQBgm82kOtKVOdUnRXhUderqaAGrX8W
// SIG // qmXjggda1kRud5e+mdcql+RV1A+RVjjVmSATbeXCC0H5
// SIG // mfvO4o5lnBOfkOQeqKxRjWdEhklOszd+1pQVFX761VyA
// SIG // GfXgr0Jtm9dptQBU1TPybl3+ypIV00IldfMGj1VOKZtd
// SIG // ZrgMiXrdaIWOqRhSEyDdQWvqGzTZm7x5elhF3vcGkRZb
// SIG // 1XqtS7OgDJ7wW0z28NMLA9yfFsPFfOQfMBEEgoCc01P9
// SIG // MBPyiz1XO28kMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCDMIIQfwIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQANMD
// SIG // Pwr2vEKYUg3AWz9ByzANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCBdOiKp199NhKDl
// SIG // 2h4NRIsWdwRr4MLUionQbjiWxgCcQjANBgkqhkiG9w0B
// SIG // AQEFAASCAQAMfN+kaF9iWRIYZ7F08rWdc1Rs7sgXbpc2
// SIG // vLu4DSCkqxj1qHzI8e2kX0mAPYSbxlTPRwQTRN6Xheun
// SIG // ug0hZ6+leL0vLFDF43sbMN4VOwtAgQNXwcY2YatSYw5x
// SIG // NVtroUgwg3gDzu3Z9qaSzeWZmm/5i9ms78RvY5n9CvEm
// SIG // 4r8nAKMa3IV9k+FjEqNpJWc6uJRxYSBTZHfVrFbaFgUW
// SIG // jH/VYijSmnvDB6NfXSwGENMqdDw9x5ImVnx7f5EMY7Rt
// SIG // pcgwUt2wnhYJ5a+45LKlfO2I/l02b7S1LeERnKLltBU/
// SIG // tN4Vtk7RsYRZJBLvxWvIozz8iPZrUktHNKIN6EwkcUZE
// SIG // oYIOPDCCDjgGCisGAQQBgjcDAwExgg4oMIIOJAYJKoZI
// SIG // hvcNAQcCoIIOFTCCDhECAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEOBgsqhkiG9w0BCRABBKCB/gSB+zCB+AIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgLbDImH8H
// SIG // s8ay8pUmuKMHc1TUdIWNsCDFdSkwTnPTOz8CFCTMEpx6
// SIG // pT8i7kT+/Nwh/hI+nLQMGA8yMDE4MDExNjAzMDQ0OVow
// SIG // AwIBHqCBhqSBgzCBgDELMAkGA1UEBhMCVVMxHTAbBgNV
// SIG // BAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQL
// SIG // ExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQD
// SIG // EyhTeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5nIFNp
// SIG // Z25lciAtIEcyoIIKizCCBTgwggQgoAMCAQICEHsFsdRJ
// SIG // aFFE98mJ0pwZnRIwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTYwMTEyMDAw
// SIG // MDAwWhcNMzEwMTExMjM1OTU5WjB3MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // KDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3Rh
// SIG // bXBpbmcgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQC7WZ1ZVU+djHJdGoGi61XzsAGtPHGsMo8F
// SIG // a4aaJwAyl2pNyWQUSym7wtkpuS7sY7Phzz8LVpD4Yht+
// SIG // 66YH4t5/Xm1AONSRBudBfHkcy8utG7/YlZHz8O5s+K2W
// SIG // OS5/wSe4eDnFhKXt7a+Hjs6Nx23q0pi1Oh8eOZ3D9Jqo
// SIG // 9IThxNF8ccYGKbQ/5IMNJsN7CD5N+Qq3M0n/yjvU9bKb
// SIG // S+GImRr1wOkzFNbfx4Dbke7+vJJXcnf0zajM/gn1kze+
// SIG // lYhqxdz0sUvUzugJkV+1hHk1inisGTKPI8EyQRtZDqk+
// SIG // scz51ivvt9jk1R1tETqS9pPJnONI7rtTDtQ2l4Z4xaE3
// SIG // AgMBAAGjggF3MIIBczAOBgNVHQ8BAf8EBAMCAQYwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADBmBgNVHSAEXzBdMFsGC2CG
// SIG // SAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMC4GCCsGAQUFBwEB
// SIG // BCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Muc3ltY2Qu
// SIG // Y29tMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5
// SIG // bWNiLmNvbS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0l
// SIG // BAwwCgYIKwYBBQUHAwgwKAYDVR0RBCEwH6QdMBsxGTAX
// SIG // BgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTMwHQYDVR0OBBYE
// SIG // FK9j1sqjToVy4Ke8QfMpojh/gHViMB8GA1UdIwQYMBaA
// SIG // FLZ3+mlIR59TEtXC6gcydgfRlwcZMA0GCSqGSIb3DQEB
// SIG // CwUAA4IBAQB16rAt1TQZXDJF/g7h1E+meMFv1+rd3E/z
// SIG // ociBiPenjxXmQCmt5l30otlWZIRxMCrdHmEXZiBWBpgZ
// SIG // jV1x8viXvAn9HJFHyeLojQP7zJAv1gpsTjPs1rSTyEyQ
// SIG // Y0g5QCHE3dZuiZg8tZiX6KkGtwnJj1NXQZAv4R5NTtzK
// SIG // EHhsQm7wtsX4YVxS9U72a433Snq+8839A9fZ9gOoD+NT
// SIG // 9wp17MZ1LqpmhQSZt/gGV+HGDvbor9rsmxgfqrnjOgC/
// SIG // zoqUywHbnsc4uw9Sq9HjlANgCk2g/idtFDL8P5dA4b+Z
// SIG // idvkORS92uTTw+orWrOVWFUEfcea7CMDjYUq0v+uqWGB
// SIG // MIIFSzCCBDOgAwIBAgIQVFjyqtdB1kS8hKl7oJZS5jAN
// SIG // BgkqhkiG9w0BAQsFADB3MQswCQYDVQQGEwJVUzEdMBsG
// SIG // A1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNV
// SIG // BAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxKDAmBgNV
// SIG // BAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcg
// SIG // Q0EwHhcNMTcwMTAyMDAwMDAwWhcNMjgwNDAxMjM1OTU5
// SIG // WjCBgDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFu
// SIG // dGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRl
// SIG // YyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQDEyhTeW1hbnRl
// SIG // YyBTSEEyNTYgVGltZVN0YW1waW5nIFNpZ25lciAtIEcy
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // mfP82AQJA4b511ymk8BCfOp8Y89dAOKO88CQ348p9Rjq
// SIG // lLeS5dewoHOB6OkKm0p8Af+dj6Q5pw7qRfQiDDpw7TlF
// SIG // i+TFG1zwRWhGJAVjdpsc/J5sKrFW5Yp/UnGu8jXVRiMG
// SIG // HM9ILR20zbjZdiOOHP8+v7sGXGkHpmUO+F6ufS7tTa41
// SIG // 78nXAEL9KJUOn11yQgm8w9pE0u3MR4Tk/MotrFi+rveu
// SIG // 2UQNCLfCd9YaQ3DRbgPeUpLEEAhx2boiVfIfvO2bnTvi
// SIG // Xh1Mg/+XD3sL51WDTtIN677X7K5uR7mf36XWUbwEVe3/
// SIG // J3BMye0qSxPhsblMD8kB7lVlX2kCeGbLPwIDAQABo4IB
// SIG // xzCCAcMwDAYDVR0TAQH/BAIwADBmBgNVHSAEXzBdMFsG
// SIG // C2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBz
// SIG // Oi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBka
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMEAGA1UdHwQ5
// SIG // MDcwNaAzoDGGL2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY3JsMBYGA1UdJQEB
// SIG // /wQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIHgDB3
// SIG // BggrBgEFBQcBAQRrMGkwKgYIKwYBBQUHMAGGHmh0dHA6
// SIG // Ly90cy1vY3NwLndzLnN5bWFudGVjLmNvbTA7BggrBgEF
// SIG // BQcwAoYvaHR0cDovL3RzLWFpYS53cy5zeW1hbnRlYy5j
// SIG // b20vc2hhMjU2LXRzcy1jYS5jZXIwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTUwHQYD
// SIG // VR0OBBYEFAm1wf6WcpcpQ5rJ4AK6rvj9L7r2MB8GA1Ud
// SIG // IwQYMBaAFK9j1sqjToVy4Ke8QfMpojh/gHViMA0GCSqG
// SIG // SIb3DQEBCwUAA4IBAQAXswqI6VxaXiBrOwoVsmzFqYoy
// SIG // h9Ox9BxTroW+P5v/17y3lIW0x1J+lOi97WGy1KeZ5MPJ
// SIG // k8E1PQvoaApdVpi9sSI70UR617/wbVEyitUj3zgBN/bi
// SIG // Uyt6KxGPt01sejMDG3xrCZQXu+TbWNQhE2Xn7NElyix1
// SIG // mpx//Mm7KmirxH20z6PJbKfZxACciQp3kfRNovsxO4Zu
// SIG // 9uYfUAOGm7/LQqvmdptyWhEBisbvpW+V592uuuYiZfAY
// SIG // WRsRyc2At9iXRx9CCPiscR+wRlOz1LLVo6tQdUgSF4Kt
// SIG // z+BBTzJ+zZUcv5GKCD2kp2cClt8kTKXQQcCCYKOKFzJL
// SIG // 07zPpLSMMYICWjCCAlYCAQEwgYswdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBAhBUWPKq10HWRLyEqXugllLmMAsGCWCG
// SIG // SAFlAwQCAaCBpDAaBgkqhkiG9w0BCQMxDQYLKoZIhvcN
// SIG // AQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTE4MDExNjAzMDQ0
// SIG // OVowLwYJKoZIhvcNAQkEMSIEIBqqsKXgXKjndYQAgu7M
// SIG // h1VqJ2CAEpSIzVkro1AlckcvMDcGCyqGSIb3DQEJEAIv
// SIG // MSgwJjAkMCIEIM96wXrQR+zV/cNoIgMbEtTvB4tvK0xe
// SIG // a6Qfj/LPS61nMAsGCSqGSIb3DQEBAQSCAQBDzRN4DAkh
// SIG // EI1e9eq/aJENosGr72jaRifgyYhPo7rZOOLsS/JmD6AX
// SIG // 0wcFDjDGM3AfRFtETPfggfNbDSlmErvDprQmjLbAgKaI
// SIG // 82Pw11+vi1AnfDZGfjOkhENZ2JlDOclXf5vs9ne90PEW
// SIG // 8qdCisl97bXamsRBxeEa4Bbsd60bEhVM52evImXYoNc0
// SIG // aGv+EDd94RTZlnASSutcBslDE3C2DnvZKtlvzzl24Kur
// SIG // g6bCNGKPhuNgfBc4d3U40A4fTUHvyyxjAt2QyBmPc7ZZ
// SIG // vZupAgxOISm77KY2TisuTgMZ70Hkud4vPj6wEZB57JkH
// SIG // Gs6Bxn/AuFN8jQRXhTixt499
// SIG // End signature block
