var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"RSTR\">\n      <meta name=\"release\" content=\"2019\">\n      <meta name=\"book\" content=\"Installation\">\n      <meta name=\"created\" content=\"2018-01-15\">\n      <meta name=\"topicid\" content=\"GUID-44D693F1-193A-4A9B-BCC6-4228657BC0FE\">\n      <meta name=\"description\" content=\"Create a license file that allows multiple products to run on the same network.\">\n      <meta name=\"indexterm\" content=\"multi-product license file\">\n      <meta name=\"topic-type\" content=\"topic\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <meta name=\"topic-subtype\" content=\"installing\">\n      <title>To Combine License Files</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-44D693F1-193A-4A9B-BCC6-4228657BC0FE\"></a><div class=\"head\">\n            <h1>To Combine License Files</h1>\n         </div>\n         <p class=\"blurb\"> Create a license file that allows multiple products to run on the same network. \n            \n         </p>\n         <p><a name=\"GUID-1D3FBF47-5C25-4643-9CFB-83909853AE01\"></a>In Autodesk Account, you can generate a license file that automatically consolidates\n            network licenses. However, this automatic method can sometimes drop licenses for older\n            products. In this case, combine your network licenses manually by adding license statements\n            in the new file to the end of the existing file. \n            	 \n         </p>\n         <p>After you create the combined license file, stop and restart each server that uses\n            the file. Upon restart, the server reads the new file. \n            	 \n         </p>\n         <div><a name=\"GUID-660D51F5-BA94-440B-8A50-10976100CFFB\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span>For Windows servers, the LMTOOLS utility has a command for rereading a license file\n               without stopping the server. However, it is more reliable to stop and restart the\n               server. \n               	 \n            </div>\n         </div>\n         <p><em class=\"strong\">To Combine Manually \n               		</em> \n         </p><a name=\"GUID-8F2DB5AE-C052-4522-8E54-809B9314DE1B\"></a><ol start=\"1\">\n            <li>Back up your existing license file before you begin editing. \n               		\n            </li>\n            <li> Examine the license files you want to combine to ensure that the top lines are identical,\n               from SERVER to VENDOR. The following example shows the applicable lines for a single-server\n               model: \n               		  \n               <div class=\"codeBlock\"><pre>SERVER XXHP0528 0019bbd68993\nUSE_SERVER \nVENDOR adskflex port=2080</pre></div> \n            </li>\n            <li> Open both the existing and newly issued license files in Notepad (Windows) or TextEdit\n               (macOS). \n               		\n            </li>\n            <li> Copy everything after the VENDOR line from the newly issued license file. \n               		\n            </li>\n            <li>Paste the new license statements at the end of the existing license file. \n               		\n            </li>\n            <li>To include other new license files, copy statements from each new license file and\n               paste them at the end of the existing license file. \n               		\n            </li>\n            <li> Save the new combined license file. \n               		\n            </li>\n         </ol>\n         <p><em class=\"strong\">Example of a Combined File</em> \n         </p>\n         <p>The following example shows how to paste license statements for AutoCAD 2014-2017\n            into an existing license file for AutoCAD 2013-2016. Manual combination is necessary\n            here because automatic generation through Autodesk Account would drop the statement\n            for the older AutoCAD 2013 product. \n            	 \n         </p>\n         <div><a name=\"GUID-BA8B058B-F5BB-4B1C-AD67-CD16701D5293\"></a><div class=\"note-important\"><span class=\"label label-target-language\">IMPORTANT:</span>The first three lines, from SERVER to VENDOR, appear only once in the combined file.\n               Don\'t copy those first three lines from AutoCAD 2014-2017.\n               	 \n            </div>\n         </div>\n         <p>Existing AutoCAD 2013-2016 license file: \n            		\n            <div class=\"codeBlock\"><pre>SERVER SIN3NYDYZ1 8086F221F250\nUSE_SERVER\nVENDOR adskflex port=2080\nPACKAGE 64300ACD_F adskflex 1.000 COMPONENTS=\"86445ACD_2016_0F \\\n	86295ACD_2015_0F 86063ACD_2014_0F 85871ACD_2013_0F\" \\\n	OPTIONS=SUITE SUPERSEDE=64300ACD_F ISSUED=13-Apr-2014 \\\n	SIGN=\"13D3 F8F5 48C2 B4A4 B077 C96F AFA4 E8CF 86D0 742D 9687 \\\n	3A10 CDAE C9E8 F305 1D17 AAB6 80E8 9A41 06D7 1833 56F2 FC93 \\\n	7DE0 86EA 5B5E 8E36 2617 0826 59DC\" SIGN2=\"0CFE 86F1 EC10 290E \\\n	9207 4D75 B8DE 13BD 88E3 47D1 E24C 3E6C AA2E 8A3E AF92 13B8 \\\n	44FF 1870 244E 1FE0 B8D2 2227 80C5 B591 127E 7CC2 5939 5D69 \\\n	A804 4770\"\nINCREMENT 64300ACD_F adskflex 1.000 permanent 5 \\\n	VENDOR_STRING=commercial:permanent SUPERSEDE=64300ACD_F \\\n	DUP_GROUP=UH SUITE_DUP_GROUP=UHV ISSUED=13-Apr-2014 \\\n	BORROW=4320 SN=399-99999966 SIGN=\"0785 CC2C 1E29 E4D4 D452 \\\n	8204 A8B2 0819 E31F 470B BACE F3AD DDC4 6D8C 681B 1F26 1BE3 \\\n	96F2 6559 9406 78D2 20DC CA61 8434 06BD CF95 04BC 3C11 99A7 \\\n	C984\" SIGN2=\"138F 9AF1 119F 2728 F0B6 1863 E791 02B4 09B8 28D0 \\\n	F2EC 1E19 DAE4 561C AED8 13AE B059 9D36 31DA 1F0A 1D24 06E9 \\\n	D99D 9891 2FFF DF13 1936 F1C3 06DC CE38\"\n</pre></div> \n         </p>\n         <p>New AutoCAD 2014-2017 license file: \n            		\n            <div class=\"codeBlock\"><pre>SERVER SIN3NYDYZ1 8086F221F250\nUSE_SERVER\nVENDOR adskflex port=2080\nPACKAGE 64300ACD_T_F adskflex 1.000 COMPONENTS=\"86445ACD_2017_0F \\\n	86295ACD_2016_0F 86063ACD_2015_0F 85871ACD_2014_0F\" \\\n	OPTIONS=SUITE SUPERSEDE=64300ACD_T_F ISSUED=13-Apr-2016 \\\n	SIGN=\"184C FEAF 3F49 3E24 A1CC 65E8 AE84 208A 272F 760E 0F92 \\\n	6C45 8E9B DB44 1A96 0048 A182 DB6F 7915 9DD6 226B 6D95 B9B0 \\\n	6489 21CE 3A5A 818E 2ADD 5DA1 A659\" SIGN2=\"0C43 5034 F3B5 E032 \\\n	AD5A F814 7CF9 8494 5F07 D668 1A98 1320 8D1B FB51 4E5C 1CB7 \\\n	CFD7 10F3 D3B7 3D66 399E 7C9B 64DC 1EDD 3FFA CF63 A88F B397 \\\n	AE39 6609\"\nINCREMENT 64300ACD_T_F adskflex 1.000 13-apr-2017 10 \\\n	VENDOR_STRING=commercial:extendable SUPERSEDE=64300ACD_T_F \\\n	DUP_GROUP=UH SUITE_DUP_GROUP=UHV ISSUED=13-Apr-2016 \\\n	BORROW=4320 SN=399-12345678 SIGN=\"1E40 7956 3769 A2FC AF70 \\\n	A12B FDB3 7918 325C F80C 4016 321E 5460 7BFE 071C 0FBF 0CBC \\\n	1D8F F13F F6D4 A96A 32C2 98CA 560B 994C FAD4 23D7 FE2D 8EF6 \\\n	E314\" SIGN2=\"110E E19B 44D4 A07C 730F F33B DE65 F98D 0D77 2D9A \\\n	74D2 F39C 9299 42CC FB28 1F82 5E4E 16A5 E7DF 943E DB57 6058 \\\n	AABF 7A2C 1518 40B7 DB27 1CD1 A10D D772\"\\\n</pre></div> \n         </p>\n         <p>Resultant combined license file: \n            		\n            <div class=\"codeBlock\"><pre>SERVER SIN3NYDYZ1 8086F221F250\nUSE_SERVER\nVENDOR adskflex port=2080\nPACKAGE 64300ACD_F adskflex 1.000 COMPONENTS=\"86445ACD_2016_0F \\\n	86295ACD_2015_0F 86063ACD_2014_0F 85871ACD_2013_0F\" \\\n	OPTIONS=SUITE SUPERSEDE=64300ACD_F ISSUED=13-Apr-2014 \\\n	SIGN=\"13D3 F8F5 48C2 B4A4 B077 C96F AFA4 E8CF 86D0 742D 9687 \\\n	3A10 CDAE C9E8 F305 1D17 AAB6 80E8 9A41 06D7 1833 56F2 FC93 \\\n	7DE0 86EA 5B5E 8E36 2617 0826 59DC\" SIGN2=\"0CFE 86F1 EC10 290E \\\n	9207 4D75 B8DE 13BD 88E3 47D1 E24C 3E6C AA2E 8A3E AF92 13B8 \\\n	44FF 1870 244E 1FE0 B8D2 2227 80C5 B591 127E 7CC2 5939 5D69 \\\n	A804 4770\"	License snippet for SN A\nINCREMENT 64300ACD_F adskflex 1.000 permanent 5 \\\n	VENDOR_STRING=commercial:permanent SUPERSEDE=64300ACD_F \\\n	DUP_GROUP=UH SUITE_DUP_GROUP=UHV ISSUED=13-Apr-2014 \\\n	BORROW=4320 SN=399-99999966 SIGN=\"0785 CC2C 1E29 E4D4 D452 \\\n	8204 A8B2 0819 E31F 470B BACE F3AD DDC4 6D8C 681B 1F26 1BE3 \\\n	96F2 6559 9406 78D2 20DC CA61 8434 06BD CF95 04BC 3C11 99A7 \\\n	C984\" SIGN2=\"138F 9AF1 119F 2728 F0B6 1863 E791 02B4 09B8 28D0 \\\n	F2EC 1E19 DAE4 561C AED8 13AE B059 9D36 31DA 1F0A 1D24 06E9 \\\n	D99D 9891 2FFF DF13 1936 F1C3 06DC CE38\"\nPACKAGE 64300ACD_T_F adskflex 1.000 COMPONENTS=\"86445ACD_2017_0F \\\n	86295ACD_2016_0F 86063ACD_2015_0F 85871ACD_2014_0F\" \\\n	OPTIONS=SUITE SUPERSEDE=64300ACD_T_F ISSUED=13-Apr-2016 \\\n	SIGN=\"184C FEAF 3F49 3E24 A1CC 65E8 AE84 208A 272F 760E 0F92 \\\n	6C45 8E9B DB44 1A96 0048 A182 DB6F 7915 9DD6 226B 6D95 B9B0 \\\n	6489 21CE 3A5A 818E 2ADD 5DA1 A659\" SIGN2=\"0C43 5034 F3B5 E032 \\\n	AD5A F814 7CF9 8494 5F07 D668 1A98 1320 8D1B FB51 4E5C 1CB7 \\\n	CFD7 10F3 D3B7 3D66 399E 7C9B 64DC 1EDD 3FFA CF63 A88F B397 \\\n	AE39 6609\"	License snippet for SN B\nINCREMENT 64300ACD_T_F adskflex 1.000 13-apr-2017 10 \\\n	VENDOR_STRING=commercial:extendable SUPERSEDE=64300ACD_T_F \\\n	DUP_GROUP=UH SUITE_DUP_GROUP=UHV ISSUED=13-Apr-2016 \\\n	BORROW=4320 SN=399-12345678 SIGN=\"1E40 7956 3769 A2FC AF70 \\\n	A12B FDB3 7918 325C F80C 4016 321E 5460 7BFE 071C 0FBF 0CBC \\\n	1D8F F13F F6D4 A96A 32C2 98CA 560B 994C FAD4 23D7 FE2D 8EF6 \\\n	E314\" SIGN2=\"110E E19B 44D4 A07C 730F F33B DE65 F98D 0D77 2D9A \\\n	74D2 F39C 9299 42CC FB28 1F82 5E4E 16A5 E7DF 943E DB57 6058 \\\n	AABF 7A2C 1518 40B7 DB27 1CD1 A10D D772\"\n</pre></div> \n         </p>\n         <div class=\"related-topics\"><span class=\"noindex\">\n               <div class=\"related-information\">\n                  <h4 class=\"related\">Related Information</h4>\n                  <ul>\n                     <li class=\"topiclist-litem\"><a href=\"license_workflow_license_options.htm\">About License Management Options and Tools</a></li>\n                  </ul>\n               </div></span></div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbQgYJKoZIhvcNAQcCoIIbMzCCGy8CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 0lGbRbwG5sNhJb5xzpI2H+vUlKCvhsekNpaYb4wuJUag
// SIG // ggoWMIIExzCCA6+gAwIBAgIQLlHY9Ndmb2zQll6+Kgx7
// SIG // KjANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCWOkLrhgKJc4cdkvAOeJKDALJyy0m/NoWe
// SIG // xtX9gEthpW13RF7h/lYXoRqnSOrt6xk1O2U+UiwINp8p
// SIG // 0BiM2batbfwxKNzTYzV3QtR5kuK+3DJ28S/k/lpPeccO
// SIG // 8cPnR2XepZ7CYHDn2bS2dm8OfMvpUQjZEpVh+Ocv3tkB
// SIG // ZKhhH6TEkbL0OFbJM12uJtNyisfpY/swEiYUBpKed0Zj
// SIG // cCtrQ5BIDqhZA/6kJbxTxTalbvbwJFEDPCrqtc1KV7NZ
// SIG // fiMkkdme/ScdDcGCdYpqR5xt54egqg6/xJOyrDtGW0EV
// SIG // b6bU68ZFMeqfKHCZyXE42/mBac1i+rWjeGZ4zwz8LliZ
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQBnP911vx5AalekBbG3iscF
// SIG // RO88rBim60QD86JT5VendZmZKCt+d+vQjRPNdEQ9wjPS
// SIG // V3R2n+7eIVrf0oaN90hca9KAuuovkyRMU/UVVod3vfUv
// SIG // 8XvtNSJT0g3/Yei7WlBIE74QGz7brUWQYY74/2H5svn1
// SIG // 6WmXUd/HoP767an7iMORFsIIHSdESj9RVSXzWLa1N7oR
// SIG // UwRsBM8wUYjfUmEVUwFXMc/eMz55Wc+yYzS+IOsCN4l1
// SIG // TT5A16vX3O4XKYJo1q5dMs8+Q7BSdS8pKyExKCq0/SYu
// SIG // JUJWOHE1SbXmCPRyAWm1nPOtWMI13QzjWO5cAVW2cNKA
// SIG // 6fCl4nFctmEZMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCEMIIQgAIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQLlHY
// SIG // 9Ndmb2zQll6+Kgx7KjANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCBT3o451u2RJe+a
// SIG // PaxtsABYfBwI8lfyOz3omyKSvwpy3jANBgkqhkiG9w0B
// SIG // AQEFAASCAQBjPbWKbwtz7D3WOdM1ztrWupjwzkNZBWAj
// SIG // IHJYlUDR14x9e4jLkX2dCgWx5K0KXKyoVU2B3Q0vN+FW
// SIG // XrQoZmVtfUGsPe+44ZnHhibGd6e3b21iQYCZ48Namrm6
// SIG // YiK/a1dsPL0FeHR+x+g9ohwH0O0omh55WROv/LQUXvQM
// SIG // 3+D0Co9k0rNAbCb8H5wsE2f3aCxaFYECeKuGUc0WqGeO
// SIG // pWVavSXKqZzvR8oX3rCNRNQxgSRN9CFqyUnL/T8HfSbH
// SIG // iuDoTnANuNihFoo+SDvDpgIdBjLuJY2Gqf48OhdNav7t
// SIG // IBvbUwmRO9BTHkFVC+w04n0R/6X2tnKyZm8TmHrvbWpj
// SIG // oYIOPTCCDjkGCisGAQQBgjcDAwExgg4pMIIOJQYJKoZI
// SIG // hvcNAQcCoIIOFjCCDhICAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEPBgsqhkiG9w0BCRABBKCB/wSB/DCB+QIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgBLzTySdr
// SIG // c4SMYNSk8AorzyaLgpX1mBuA356DnCAfyCsCFQCFB2cr
// SIG // 0+4ZgYE4gI0Iu0RcCU/PsBgPMjAxODAxMTYwMzA0MTBa
// SIG // MAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UE
// SIG // CxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UE
// SIG // AxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBT
// SIG // aWduZXIgLSBHMqCCCoswggU4MIIEIKADAgECAhB7BbHU
// SIG // SWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9MQsw
// SIG // CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIElu
// SIG // Yy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdv
// SIG // cmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWduLCBJ
// SIG // bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxODA2
// SIG // BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290IENl
// SIG // cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDExMjAw
// SIG // MDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
// SIG // MIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxxrDKP
// SIG // BWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ+GIb
// SIG // fuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/DubPit
// SIG // ljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmdw/Sa
// SIG // qPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o71PWy
// SIG // m0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J9ZM3
// SIG // vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEbWQ6p
// SIG // PrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeGeMWh
// SIG // NwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEGMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBbBgtg
// SIG // hkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRwczov
// SIG // L2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZGhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEFBQcB
// SIG // AQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5bWNk
// SIG // LmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5z
// SIG // eW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1Ud
// SIG // JQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAbMRkw
// SIG // FwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1UdDgQW
// SIG // BBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSMEGDAW
// SIG // gBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG9w0B
// SIG // AQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq3dxP
// SIG // 86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2YgVgaY
// SIG // GY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0k8hM
// SIG // kGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+EeTU7c
// SIG // yhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYDqA/j
// SIG // U/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q54zoA
// SIG // v86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+XQOG/
// SIG // mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/rqlh
// SIG // gTCCBUswggQzoAMCAQICEFRY8qrXQdZEvISpe6CWUuYw
// SIG // DQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMxHTAb
// SIG // BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYD
// SIG // VQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgwJgYD
// SIG // VQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5n
// SIG // IENBMB4XDTE3MDEwMjAwMDAwMFoXDTI4MDQwMTIzNTk1
// SIG // OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1h
// SIG // bnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50
// SIG // ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3ltYW50
// SIG // ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIgLSBH
// SIG // MjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
// SIG // AJnz/NgECQOG+ddcppPAQnzqfGPPXQDijvPAkN+PKfUY
// SIG // 6pS3kuXXsKBzgejpCptKfAH/nY+kOacO6kX0Igw6cO05
// SIG // RYvkxRtc8EVoRiQFY3abHPyebCqxVuWKf1JxrvI11UYj
// SIG // BhzPSC0dtM242XYjjhz/Pr+7BlxpB6ZlDvhern0u7U2u
// SIG // Ne/J1wBC/SiVDp9dckIJvMPaRNLtzEeE5PzKLaxYvq73
// SIG // rtlEDQi3wnfWGkNw0W4D3lKSxBAIcdm6IlXyH7ztm507
// SIG // 4l4dTIP/lw97C+dVg07SDeu+1+yubke5n9+l1lG8BFXt
// SIG // /ydwTMntKksT4bG5TA/JAe5VZV9pAnhmyz8CAwEAAaOC
// SIG // AccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNVHR8E
// SIG // OTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNVHSUB
// SIG // Af8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMCB4Aw
// SIG // dwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5odHRw
// SIG // Oi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYIKwYB
// SIG // BQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50ZWMu
// SIG // Y29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQhMB+k
// SIG // HTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC01MB0G
// SIG // A1UdDgQWBBQJtcH+lnKXKUOayeACuq74/S+69jAfBgNV
// SIG // HSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjANBgkq
// SIG // hkiG9w0BAQsFAAOCAQEAF7MKiOlcWl4gazsKFbJsxamK
// SIG // MofTsfQcU66Fvj+b/9e8t5SFtMdSfpTove1hstSnmeTD
// SIG // yZPBNT0L6GgKXVaYvbEiO9FEete/8G1RMorVI984ATf2
// SIG // 4lMreisRj7dNbHozAxt8awmUF7vk21jUIRNl5+zRJcos
// SIG // dZqcf/zJuypoq8R9tM+jyWyn2cQAnIkKd5H0TaL7MTuG
// SIG // bvbmH1ADhpu/y0Kr5nabcloRAYrG76VvlefdrrrmImXw
// SIG // GFkbEcnNgLfYl0cfQgj4rHEfsEZTs9Sy1aOrUHVIEheC
// SIG // rc/gQU8yfs2VHL+Rigg9pKdnApbfJEyl0EHAgmCjihcy
// SIG // S9O8z6S0jDGCAlowggJWAgEBMIGLMHcxCzAJBgNVBAYT
// SIG // AlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlv
// SIG // bjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29y
// SIG // azEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVT
// SIG // dGFtcGluZyBDQQIQVFjyqtdB1kS8hKl7oJZS5jALBglg
// SIG // hkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0xODAxMTYwMzA0
// SIG // MTBaMC8GCSqGSIb3DQEJBDEiBCAEirNaMAuOUtcyrml0
// SIG // bB2P1KH9hklhJeuOTRC0c0V0xjA3BgsqhkiG9w0BCRAC
// SIG // LzEoMCYwJDAiBCDPesF60Efs1f3DaCIDGxLU7weLbytM
// SIG // XmukH4/yz0utZzALBgkqhkiG9w0BAQEEggEAacVAk3Vj
// SIG // qTn28hRzi6SGYOys/FuGPr9VRwB8q61GzKL5zlTm6Vf1
// SIG // pOpREYPIzKSyNhAQ6MDcj1dTqDNdM97CN/Xn4DTp8X6u
// SIG // vKu+Z79wjV67mwqLb/eds0//8ooQrvufb9QR5ox/UJNB
// SIG // Sq1R/Phrj6LJisARrF1Hz7p/meoCqdE+7YWXK7uXIqMs
// SIG // VETnj4d2+PRUiFUtD+9Ddi98NyvNSm9wEn9CHBq/LdNb
// SIG // +qQ77ZksHxUQTj1V6wXHZHibZsYacbsXajml+tM/X+U3
// SIG // TXuMRg6SKZ+qFqb6zBeeqW5TIErhiYljDIsDwnwqZwKc
// SIG // yCwyGW0AxdTUeQR02AklP/n4rA==
// SIG // End signature block
