// Suggestion processor.

(function ($) {

    $.widget('adsk.suggestionprocessor', {

        options:{

        },



        _suggestionList:[],

        _view:undefined,



        _create:function () {

            console.log('suggestionprocessor: _create');



            //  Create view and attach event handlers.

        },



        createHtmlSuggestionList:function (data) {

            this._clearSuggestionList();

            this._createHtmlSuggestionList(data);

            return this._suggestionList;

        },



        createTocSuggestionList:function (data) {

//            console.log('suggestionprocessor: createTocSuggestionList');

            this._clearSuggestionList();

            for (var l in data) {

                var letter = data[l];

                var string = letter.data;

                this._createSuggestionList(string);

                this._renderTocChildren(letter.children);

            }

            return this._suggestionList;

        },



        createIndexSuggestionList:function (data) {

//            console.log('suggestionprocessor: createIndexSuggestionList');

            this._clearSuggestionList();

            for (var l in data) {

                var letter = data[l];

                this._renderIndexChildren(letter.c);

            }

            return this._suggestionList;

        },



        createFavoritesSuggestionList:function (data) {

//            console.log('suggestionprocessor: createFavoritesSuggestionList');

            this._clearSuggestionList();

            for (var l in data) {

                var letter = data[l];

                var string = letter.data;

                this._createSuggestionList(string);

            }

            return this._suggestionList;

        },



        _renderTocChildren:function (children) {

//            console.log('indextabview: _renderTocChildren');

            for (var i in children) {

                var child = children[i];

                var grandchildren = child.c;

                var string = child.data;

                this._createSuggestionList(string);

                if (grandchildren) {

                    this._renderIndexChildren(grandchildren);

                }

            }

        },



        _renderIndexChildren:function (children) {

//            console.log('indextabview: _renderIndexChildren');

            for (var i in children) {

                var child = children[i];

                var grandchildren = child.c;

                var string = child.l;

                this._createSuggestionList(string);

                if (grandchildren) {

                    this._renderIndexChildren(grandchildren);

                }

            }

        },



        _createSuggestionList: function(string){

//            console.log('indextabview: _createSuggestionList');

            var wordReg = new RegExp('[\\w+\'-]{1,}', 'gi');

            while (x = wordReg.exec(string)) {

                this._suggestionList.sort();

                var xReg = new RegExp('\\b' + x[0] + '\\b', 'i');

                if (!this._suggestionList.toString().match(xReg)) {

                    this._suggestionList.push(x[0]);

                }

            }

        },



        createObjectSuggestionList:function (data) {

            console.log('suggestionprocessor: createObjectSuggestionList');

            this._clearSuggestionList();



            return this._suggestionList;

        },



         _clearSuggestionList: function(){

            this._suggestionList = [];

        },



        _createHtmlSuggestionList:function (node) {

            var TEXT_NODE = 3;

            var ELEMENT_NODE = 1;

            var skip = 0;

            if (node && node.nodeType == TEXT_NODE) {

                skip = 1;

                var string = node.textContent;

                this._createSuggestionList(string);

            } else {

                if (node && node.nodeType == ELEMENT_NODE && node.childNodes && !/(script|style)/i.test(node.tagName)) {

                    for (var i = 0; i < node.childNodes.length; ++i) {

                        this._createHtmlSuggestionList(node.childNodes[i]);

                    }

                }

            }

            return skip;

        }

    });

})(jQuery);
// SIG // Begin signature block
// SIG // MIIbQQYJKoZIhvcNAQcCoIIbMjCCGy4CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // ouzBN9xT4wuj+av/g1CDTkZ6xbJOmRQ/HftSr+wT91Cg
// SIG // ggoWMIIExzCCA6+gAwIBAgIQANMDPwr2vEKYUg3AWz9B
// SIG // yzANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDEm0ybXlDjakGjfPJQOz8JJyQPZ4frwCIk
// SIG // YuGOWfv+3NZI9Snuy2rQ00G3NuUtmIl0Y0MeypzK5A8s
// SIG // nDGR+bkcRvGn2OmMHS50aggKjsao+rCNMiC8btSwxojg
// SIG // ekzX093J9+/kauZtUESeku1KV2xsBhQ+KTc5TliNgJDJ
// SIG // kB8VW+i2bK0oVx4aMPjX8pivLnbZDYo48U5lQNJtKVBC
// SIG // tnfv0wz2QfRAvXARUxGAnn7xsdgQzYzV6wn+i6N/fMDl
// SIG // e+qWfumXUFSnueYpP85Yi3oNu5kFydgeu34/TTkF1+gD
// SIG // OXfEKLP3cInMUgL7EGTIzHlXaumXFVZobx75J77kq721
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQApMpNskUmvqk2ygWaCDz+3
// SIG // PTZOZl8Q1FKIoGnv2+iq6wblFUCZt+KgKKyoZoHX6GMd
// SIG // Z/YKeTi5PO4QpKQBgm82kOtKVOdUnRXhUderqaAGrX8W
// SIG // qmXjggda1kRud5e+mdcql+RV1A+RVjjVmSATbeXCC0H5
// SIG // mfvO4o5lnBOfkOQeqKxRjWdEhklOszd+1pQVFX761VyA
// SIG // GfXgr0Jtm9dptQBU1TPybl3+ypIV00IldfMGj1VOKZtd
// SIG // ZrgMiXrdaIWOqRhSEyDdQWvqGzTZm7x5elhF3vcGkRZb
// SIG // 1XqtS7OgDJ7wW0z28NMLA9yfFsPFfOQfMBEEgoCc01P9
// SIG // MBPyiz1XO28kMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCDMIIQfwIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQANMD
// SIG // Pwr2vEKYUg3AWz9ByzANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCDUKElE5o3oZ58i
// SIG // ksmf0Du69595vp3c3uaD9cEhLPI+IzANBgkqhkiG9w0B
// SIG // AQEFAASCAQCNaHZbbnSQD5oNjAyW8Gz9XhMer8gwrha/
// SIG // BjXBonKtaONasWfZEN3fa2cNX/b1Si1h0JyQ2SbvIx++
// SIG // gieNfQBwRQ87CS+66bZTMzbwJlWRu6/dUQNt1x9k68MZ
// SIG // zfLtCCEO4JIXK2XMlc/UT4BRfzhwDIjRBlvKe+35Uzry
// SIG // Ap8uf5/EZPk0fbL0tgmnsgwnLxd4Hl8OXYLx6ycQfC1k
// SIG // lf/17et7OLte2lc/yQr/22Nke6GhQnT1KpTLFnODBdGH
// SIG // XtFu1RJNN+96JM25liOnDkzzTIqVpVYh5HG+qd4rFmcp
// SIG // Uhwg+CsVI3QLiXSa6RUhBmJ1DHoyJT8EjqJWI27y46jK
// SIG // oYIOPDCCDjgGCisGAQQBgjcDAwExgg4oMIIOJAYJKoZI
// SIG // hvcNAQcCoIIOFTCCDhECAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEOBgsqhkiG9w0BCRABBKCB/gSB+zCB+AIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQg+gZUJIkl
// SIG // OZbloYXkMnA4AXFC+bzCuQ6XrVRmpzKvJvcCFF/Axgfm
// SIG // 9agbN2M7dSe3TPQWEabxGA8yMDE4MDExNjAzMDMzMVow
// SIG // AwIBHqCBhqSBgzCBgDELMAkGA1UEBhMCVVMxHTAbBgNV
// SIG // BAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQL
// SIG // ExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQD
// SIG // EyhTeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5nIFNp
// SIG // Z25lciAtIEcyoIIKizCCBTgwggQgoAMCAQICEHsFsdRJ
// SIG // aFFE98mJ0pwZnRIwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTYwMTEyMDAw
// SIG // MDAwWhcNMzEwMTExMjM1OTU5WjB3MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // KDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3Rh
// SIG // bXBpbmcgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQC7WZ1ZVU+djHJdGoGi61XzsAGtPHGsMo8F
// SIG // a4aaJwAyl2pNyWQUSym7wtkpuS7sY7Phzz8LVpD4Yht+
// SIG // 66YH4t5/Xm1AONSRBudBfHkcy8utG7/YlZHz8O5s+K2W
// SIG // OS5/wSe4eDnFhKXt7a+Hjs6Nx23q0pi1Oh8eOZ3D9Jqo
// SIG // 9IThxNF8ccYGKbQ/5IMNJsN7CD5N+Qq3M0n/yjvU9bKb
// SIG // S+GImRr1wOkzFNbfx4Dbke7+vJJXcnf0zajM/gn1kze+
// SIG // lYhqxdz0sUvUzugJkV+1hHk1inisGTKPI8EyQRtZDqk+
// SIG // scz51ivvt9jk1R1tETqS9pPJnONI7rtTDtQ2l4Z4xaE3
// SIG // AgMBAAGjggF3MIIBczAOBgNVHQ8BAf8EBAMCAQYwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADBmBgNVHSAEXzBdMFsGC2CG
// SIG // SAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMC4GCCsGAQUFBwEB
// SIG // BCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Muc3ltY2Qu
// SIG // Y29tMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5
// SIG // bWNiLmNvbS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0l
// SIG // BAwwCgYIKwYBBQUHAwgwKAYDVR0RBCEwH6QdMBsxGTAX
// SIG // BgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTMwHQYDVR0OBBYE
// SIG // FK9j1sqjToVy4Ke8QfMpojh/gHViMB8GA1UdIwQYMBaA
// SIG // FLZ3+mlIR59TEtXC6gcydgfRlwcZMA0GCSqGSIb3DQEB
// SIG // CwUAA4IBAQB16rAt1TQZXDJF/g7h1E+meMFv1+rd3E/z
// SIG // ociBiPenjxXmQCmt5l30otlWZIRxMCrdHmEXZiBWBpgZ
// SIG // jV1x8viXvAn9HJFHyeLojQP7zJAv1gpsTjPs1rSTyEyQ
// SIG // Y0g5QCHE3dZuiZg8tZiX6KkGtwnJj1NXQZAv4R5NTtzK
// SIG // EHhsQm7wtsX4YVxS9U72a433Snq+8839A9fZ9gOoD+NT
// SIG // 9wp17MZ1LqpmhQSZt/gGV+HGDvbor9rsmxgfqrnjOgC/
// SIG // zoqUywHbnsc4uw9Sq9HjlANgCk2g/idtFDL8P5dA4b+Z
// SIG // idvkORS92uTTw+orWrOVWFUEfcea7CMDjYUq0v+uqWGB
// SIG // MIIFSzCCBDOgAwIBAgIQVFjyqtdB1kS8hKl7oJZS5jAN
// SIG // BgkqhkiG9w0BAQsFADB3MQswCQYDVQQGEwJVUzEdMBsG
// SIG // A1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNV
// SIG // BAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxKDAmBgNV
// SIG // BAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcg
// SIG // Q0EwHhcNMTcwMTAyMDAwMDAwWhcNMjgwNDAxMjM1OTU5
// SIG // WjCBgDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFu
// SIG // dGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRl
// SIG // YyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQDEyhTeW1hbnRl
// SIG // YyBTSEEyNTYgVGltZVN0YW1waW5nIFNpZ25lciAtIEcy
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // mfP82AQJA4b511ymk8BCfOp8Y89dAOKO88CQ348p9Rjq
// SIG // lLeS5dewoHOB6OkKm0p8Af+dj6Q5pw7qRfQiDDpw7TlF
// SIG // i+TFG1zwRWhGJAVjdpsc/J5sKrFW5Yp/UnGu8jXVRiMG
// SIG // HM9ILR20zbjZdiOOHP8+v7sGXGkHpmUO+F6ufS7tTa41
// SIG // 78nXAEL9KJUOn11yQgm8w9pE0u3MR4Tk/MotrFi+rveu
// SIG // 2UQNCLfCd9YaQ3DRbgPeUpLEEAhx2boiVfIfvO2bnTvi
// SIG // Xh1Mg/+XD3sL51WDTtIN677X7K5uR7mf36XWUbwEVe3/
// SIG // J3BMye0qSxPhsblMD8kB7lVlX2kCeGbLPwIDAQABo4IB
// SIG // xzCCAcMwDAYDVR0TAQH/BAIwADBmBgNVHSAEXzBdMFsG
// SIG // C2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBz
// SIG // Oi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBka
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMEAGA1UdHwQ5
// SIG // MDcwNaAzoDGGL2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY3JsMBYGA1UdJQEB
// SIG // /wQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIHgDB3
// SIG // BggrBgEFBQcBAQRrMGkwKgYIKwYBBQUHMAGGHmh0dHA6
// SIG // Ly90cy1vY3NwLndzLnN5bWFudGVjLmNvbTA7BggrBgEF
// SIG // BQcwAoYvaHR0cDovL3RzLWFpYS53cy5zeW1hbnRlYy5j
// SIG // b20vc2hhMjU2LXRzcy1jYS5jZXIwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTUwHQYD
// SIG // VR0OBBYEFAm1wf6WcpcpQ5rJ4AK6rvj9L7r2MB8GA1Ud
// SIG // IwQYMBaAFK9j1sqjToVy4Ke8QfMpojh/gHViMA0GCSqG
// SIG // SIb3DQEBCwUAA4IBAQAXswqI6VxaXiBrOwoVsmzFqYoy
// SIG // h9Ox9BxTroW+P5v/17y3lIW0x1J+lOi97WGy1KeZ5MPJ
// SIG // k8E1PQvoaApdVpi9sSI70UR617/wbVEyitUj3zgBN/bi
// SIG // Uyt6KxGPt01sejMDG3xrCZQXu+TbWNQhE2Xn7NElyix1
// SIG // mpx//Mm7KmirxH20z6PJbKfZxACciQp3kfRNovsxO4Zu
// SIG // 9uYfUAOGm7/LQqvmdptyWhEBisbvpW+V592uuuYiZfAY
// SIG // WRsRyc2At9iXRx9CCPiscR+wRlOz1LLVo6tQdUgSF4Kt
// SIG // z+BBTzJ+zZUcv5GKCD2kp2cClt8kTKXQQcCCYKOKFzJL
// SIG // 07zPpLSMMYICWjCCAlYCAQEwgYswdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBAhBUWPKq10HWRLyEqXugllLmMAsGCWCG
// SIG // SAFlAwQCAaCBpDAaBgkqhkiG9w0BCQMxDQYLKoZIhvcN
// SIG // AQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTE4MDExNjAzMDMz
// SIG // MVowLwYJKoZIhvcNAQkEMSIEIFVIuAz4PSnrkZ927mwr
// SIG // 8rn5vVex+E0YSaLI0PBGen4kMDcGCyqGSIb3DQEJEAIv
// SIG // MSgwJjAkMCIEIM96wXrQR+zV/cNoIgMbEtTvB4tvK0xe
// SIG // a6Qfj/LPS61nMAsGCSqGSIb3DQEBAQSCAQBP2YMaFLRS
// SIG // bAzq3v59m0sibrHW9q+ygrH0utlmOaWxf6rkfdZwPDVV
// SIG // uJ/2XpiEB0CfBtrDN01097yiezLYKwHQZAvcwhAUgH0E
// SIG // SsMZrYT8MTTtlx7/MJFEwDKYx+NGAEoAIqU3P06Q3mzj
// SIG // s+Fow3m+z0BqSyMIDqGgXh8/QNJ8Uia+VDMgFQRdjJoV
// SIG // v5f8B55R7ry1nxpXa2krBsnGox+h7j9DltKypxjr/NUC
// SIG // ydzLQYvyJlyScnEWEud4zh9zh3aLsBmeyaX5wjo9XZjr
// SIG // ebSMfATYTEFKeugzwKmfXr3xKZ/zwxAgT+2jVCs6Zo7z
// SIG // tkCIBDC9Hl0GGkbMC4T26/3E
// SIG // End signature block
