// Topic controller.
(function($) {
	$.widget('adsk.topiccontroller', {
		options: {
		    defaultTopicHref: undefined,
		    shareController: undefined,
            favoritesController: undefined,
		    pageIds: ['navigation', 'search', 'page', 'share'],
		    toc: undefined,
		    orientationData: undefined
		},

        /* Private members. */

		_view: undefined,
		_defaultTopicData: undefined,
		_currentTopicData: undefined,
		_parentTopicData: undefined,

		_siblingTopicData: {
		    prn: undefined, // previous
		    nxn: undefined // next
		},

        // This method is the widget's constructor.
		_create: function() {
            console.log('topiccontroller: _create');

            // Create view and attach event handlers.
            $('#topic').topicview({
                create:     $.proxy(this._viewCreateHandler, this),
                buttontap:  $.proxy(this._viewButtontapHandler, this),
                swipeleft:  $.proxy(this._viewSwipeLeftHandler, this),
                swiperight: $.proxy(this._viewSwipeRightHandler, this),
                opentopic:  $.proxy(this._viewOpentopicHandler, this)
            });
		},

		_viewOpentopicHandler: function(event, data) {
		    console.log('topiccontroller: _viewOpentopicHandler');

		    this._trigger('opentopic', {}, data);
		},

        // View widget 'create' event handler.
		_viewCreateHandler: function(event, ui) {
            console.log('topiccontroller: _viewCreateHandler');

            this._view = $(event.target).topicview("instance");
		},

		_openDefaultTopic: function(defaultTopic) {
		    console.log('topiccontroller: _openDefaultTopic');

            this._trigger('opentopic', {}, {
                href: defaultTopic.attr.href
            });
		},

		_getDefaultTopicData: function() {
		    console.log('topiccontroller: _getDefaultTopicData');

		    var href = this.options.defaultTopicHref;

            var topic = this._fetchTopicData({
                href: href
            });

            // If no topic specified in TOC tree data,
            // use config provided HREF to load default topic.
            if (topic === undefined) {
                topic = {
                    /* TODO: add default topic title into publication config. */
                    data: undefined,
                    attr: {
                        href: href
                    }
                };
            }

            return topic;
		},

        // Disable/enable navigation buttons and favorites.
		_setupTopicRelatedFeatures: function(topic) {
		    console.log('topiccontroller: _setupTopicRelatedFeatures');

            var toc = this.options.toc,
            	view = this._view;

		    if (topic !== undefined && topic.attr.id !== undefined) {
                this._setupGoBackFeature(view);

                this._setupGoToParentFeature(toc, topic, view);
                this._setupGoToSiblingFeature('prn', toc, topic, view);
                this._setupGoToSiblingFeature('nxn', toc, topic, view);

                this._setupFavoritesFeature(topic, view);
                // TODO: prev and next features.
		    } else {
		        this._disableTopicRelatedFeatures(view);
		    }

		},

		_disableTopicRelatedFeatures: function(view) {
		    console.log('topiccontroller: _disableTopicRelatedFeatures');

		    view.initGoToParentButton(false);
            view.initFavoritesButton(false);
            view.initGoBackButton(false);

            this._siblingTopicData['prn'] = undefined;
            this._siblingTopicData['nxn'] = undefined;

            view.flag(false);
		},

		_setupGoBackFeature: function(view) {
		     console.log('topiccontroller: _setupGoBackFeature');

             view.initGoBackButton(history.length > 0);
		},


		_setupGoToParentFeature: function(toc, topic, view) {
		    console.log('topiccontroller: _setupGoToParentFeature');

		    // Enable "Go to parent" button if parent topic available.
		    var parentTopic = undefined;

            if (toc !== undefined) {
                var parentTopicNumber = topic.attr.pn,
                    bookName = "";

                if (parentTopicNumber !== undefined) {
                    parentTopic = toc.tocIndexedByTopicNumber[bookName][parentTopicNumber]
                }

                var goToParentButtonEnabled = (parentTopic !== undefined) ? true: false;

                if (goToParentButtonEnabled) {
                    this._parentTopicData = parentTopic;
                } else {
                    this._parentTopicData = undefined;
                }

                view.initGoToParentButton(goToParentButtonEnabled);
            } else {
                view.initGoToParentButton(false);
            }
		},


		// attr = prn || nxn.
		_setupGoToSiblingFeature: function(attr, toc, topic, view) {
		    console.log('topiccontroller: _setupGoToSiblingFeature');

		    // Enable "GoTo" button if 'previous/next' topic available.
		    var targetTopic = undefined;

            if (toc !== undefined) {
                var topicNumber = topic.attr[attr],
                    bookName = '';

                if (topicNumber !== undefined) {
                    targetTopic = toc.tocIndexedByTopicNumber[bookName][topicNumber];
                }
            }

            this._siblingTopicData[attr] = targetTopic;
		},

		_setupFavoritesFeature: function(topic, view) {
		    console.log('topiccontroller: _setupFavoritesFeature');

		    view.initFavoritesButton(true);

		    // Indicate if opened topic page is in favorites.
            var isTopicInFavorites = this.options.favoritesController.isTopicIdInFavorites(topic.attr.id);
            view.flag(isTopicInFavorites);
		},

		_isPageId: function(id) {
            return ($.inArray(id, this.options.pageIds) > -1);
		},

		_makePageCurrentById: function(id) {
		    console.log('topiccontroller: _makePageCurrentById, id = ', id);

		    if (this._isPageId(id)) {
                this._trigger('showpage', {}, { id: id });
            }
		},

		_createShareController: function() {
		    console.log('topiccontroller: _createShareController');

            this.options.shareController = $.adsk.sharecontroller({
                back:               $.proxy(this._backToPreviousPage, this),
                shareButtonOffset:  this.getShareButtonOffset(),
                orientationData:    this.options.orientationData
            });
		},

		_viewButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _viewButtontapHandler');

            id = id.substring('topic-'.length);
            var handlerName = '_' + id + 'ButtontapHandler';
            this[handlerName](event, id);
		},

        _setTopicTitleToShare: function(title){
            console.log('topiccontroller: _setTopicTitleToShare', title);

            if (this.options.shareController !== undefined) {
                this.options.shareController._setCurrentTopicTitle(title);
            }
        },

		_shareButtontapHandler: function(event, id) {
		    // Create share controller lazily.
		    var controller = this.options.shareController;

		    if (controller === undefined) {
                this._createShareController();
                controller = this.options.shareController;
            }

            this._makePageCurrentById(id);
            this._setTopicTitleToShare(this._currentTopicData.data);
            controller.refresh(this.getShareButtonOffset());
		},

		_parentButtontapHandler: function(event, id) {
		    var parentTopic = this._parentTopicData;

            if (parentTopic !== undefined) {
                this._currentTopicData = parentTopic;

                this._trigger('opentopic', {}, {
                    href: parentTopic.attr.href
                });
            }
		},

		_favoritesButtontapHandler: function(event, id) {
		    var attr = this._currentTopicData.attr;
		    if (attr.id !== undefined) {
                var added = this.options.favoritesController.addOrRemoveFavoriteTopicId(attr.id);
                this._view.flag(added);
            }
		},

		_navigationButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _navigationButtontapHandler');

		    this._makePageCurrentById(id);
		},

		_backButtontapHandler: function() {
		    console.log('topiccontroller: _backButtonHandler');

		    history.go(-1);
		},

		_homeButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _homeButtontapHandler');

            this._openDefaultTopic(this._defaultTopicData);
		},

		_searchButtontapHandler: function(event, id) {
            console.log('topiccontroller: _searchButtontapHandler');

            this._makePageCurrentById(id);

            this._trigger('setsuggestiondata', {}, [this._getTopicSearchData()]);
        },

        _viewSwipeRightHandler: function(event) {
            console.log('topiccontroller: _viewSwipeRightHandler');

            var prevTopic = this._siblingTopicData['prn'];

            if (prevTopic !== undefined) {
                this._currentTopicData = prevTopic;

                this._trigger('opentopic', {}, {
                    href: prevTopic.attr.href
                });
            }
        },

        _viewSwipeLeftHandler: function(event) {
            console.log('topiccontroller: _viewSwipeLeftHandler');

            var nextTopic = this._siblingTopicData['nxn'];

            if (nextTopic !== undefined) {
                this._currentTopicData = nextTopic;

                this._trigger('opentopic', {}, {
                    href: nextTopic.attr.href
                });
            }
        },

        _getTopicSearchData: function(){
            console.log('topiccontroller: _getTopicSearchData');

            return {data: document.getElementById('body-content'),
                    type: 'topic'};
        },

        // Tells the view to load topic if it is specified.
		_showTopicContent: function(topic) {
            console.log('topiccontroller: _showTopicContent, ', topic);

            if (topic !== undefined) {
                console.log('topic data: ', topic);

                var href = topic.attr.href,
                    title = topic.data;

                // Get book name to resolve inner links.
                var bookBase = this._getBookBase(href);

                this._setTopicTitleToShare(title);
                this._view.loadPage(href, title, bookBase);
            }
        },

        // Get topic data (title, href, id etc.) from TOC tree by ID, HREF or topic number.
		_fetchTopicData: function(data) {
		    console.log('topiccontroller: _fetchTopicData');

            var toc = this.options.toc,
                bookName = '',
                topic = undefined;

            if (toc !== undefined) {
                // Get topic data by topic ID.
                if (data.id !== undefined && data.id !== '') {
                    if (toc.tocIndexedById !== undefined) {
                        topic = toc.tocIndexedById[bookName][data.id];
                    }
                // Get topic data by href.
                } else if (data.href !== undefined && data.href !== '') {
                    // Crop url fragment.
                    var href = data.href;
                    if (data.href.lastIndexOf('#') != -1) {
                        href = data.href.substr(0, data.href.lastIndexOf('#'));
                    }

                    if (toc.tocIndexedByHref !== undefined) {
                        topic = toc.tocIndexedByHref[bookName][href];
                    }
                // Get topic data by topic number.
                } else if (data.tn !== undefined && data.tn !== '') {
                    if (toc.tocIndexedByTopicNumber !== undefined) {
                        topic = toc.tocIndexedByTopicNumber[bookName][data.tn];
                    }
                }
            }

            if (topic === undefined) {
                topic = {
                    attr: {
                        href: data.href
                    }
                };
            } else {
                topic.attr.href = data.href; // Preserve url fragment.
            }

            return topic;
		},

		_backToPreviousPage: function() {
            console.log('topiccontroller: _backToPreviousPage');

            this._trigger('back');
        },

        // Get book name from path.
        // ./filesTEST1/topichead.htm => TEST1
        _getBookBase: function(path) {
            var pos = path.lastIndexOf('/'),
                base = path.substring(0, pos + 1);

            return base;
        },

        _getBookName: function(bookBase) {
            var files = '/files',
                startIndex = bookBase.lastIndexOf(files) + files.length,
                endIndex = bookBase.lastIndexOf('/');

            return bookBase.substring(startIndex, endIndex);
        },

		/* Public members. */

        resize: function(data) {
            console.log('topiccontroller: resize');

            this.options.orientationData = data;

            this._view.resize();

            var controller = this.options.shareController;
            if (controller !== undefined) {
                controller.resize(data);
                controller.refresh(this.getShareButtonOffset());
            }
        },

        setTocData: function(data) {
            console.log('topiccontroller: setTocData, ');

            this.options.toc = data;

            // Try to fetch default topic data again.
            this._defaultTopicData = this._getDefaultTopicData();
        },

		openTopic: function(data) {
		    console.log('topiccontroller: openTopic: ', data);

            if (data === undefined || $.isEmptyObject(data)) {
                return;
            }

		    var topic = this._currentTopicData = this._fetchTopicData(data);

		    this._showTopicContent(topic);
		    this._setupTopicRelatedFeatures(topic);
		},

		getShareButtonOffset: function() {
            console.log('topiccontroller: getShareButtonOffset');

            return this._view.getShareButtonOffset();
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIbQgYJKoZIhvcNAQcCoIIbMzCCGy8CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // ZNeqXaznveTUyb4BWTeZwLpse+f6/8bZbbv7BhFkGcCg
// SIG // ggoWMIIExzCCA6+gAwIBAgIQANMDPwr2vEKYUg3AWz9B
// SIG // yzANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDEm0ybXlDjakGjfPJQOz8JJyQPZ4frwCIk
// SIG // YuGOWfv+3NZI9Snuy2rQ00G3NuUtmIl0Y0MeypzK5A8s
// SIG // nDGR+bkcRvGn2OmMHS50aggKjsao+rCNMiC8btSwxojg
// SIG // ekzX093J9+/kauZtUESeku1KV2xsBhQ+KTc5TliNgJDJ
// SIG // kB8VW+i2bK0oVx4aMPjX8pivLnbZDYo48U5lQNJtKVBC
// SIG // tnfv0wz2QfRAvXARUxGAnn7xsdgQzYzV6wn+i6N/fMDl
// SIG // e+qWfumXUFSnueYpP85Yi3oNu5kFydgeu34/TTkF1+gD
// SIG // OXfEKLP3cInMUgL7EGTIzHlXaumXFVZobx75J77kq721
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQApMpNskUmvqk2ygWaCDz+3
// SIG // PTZOZl8Q1FKIoGnv2+iq6wblFUCZt+KgKKyoZoHX6GMd
// SIG // Z/YKeTi5PO4QpKQBgm82kOtKVOdUnRXhUderqaAGrX8W
// SIG // qmXjggda1kRud5e+mdcql+RV1A+RVjjVmSATbeXCC0H5
// SIG // mfvO4o5lnBOfkOQeqKxRjWdEhklOszd+1pQVFX761VyA
// SIG // GfXgr0Jtm9dptQBU1TPybl3+ypIV00IldfMGj1VOKZtd
// SIG // ZrgMiXrdaIWOqRhSEyDdQWvqGzTZm7x5elhF3vcGkRZb
// SIG // 1XqtS7OgDJ7wW0z28NMLA9yfFsPFfOQfMBEEgoCc01P9
// SIG // MBPyiz1XO28kMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCEMIIQgAIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQANMD
// SIG // Pwr2vEKYUg3AWz9ByzANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCBdOiKp199NhKDl
// SIG // 2h4NRIsWdwRr4MLUionQbjiWxgCcQjANBgkqhkiG9w0B
// SIG // AQEFAASCAQAMfN+kaF9iWRIYZ7F08rWdc1Rs7sgXbpc2
// SIG // vLu4DSCkqxj1qHzI8e2kX0mAPYSbxlTPRwQTRN6Xheun
// SIG // ug0hZ6+leL0vLFDF43sbMN4VOwtAgQNXwcY2YatSYw5x
// SIG // NVtroUgwg3gDzu3Z9qaSzeWZmm/5i9ms78RvY5n9CvEm
// SIG // 4r8nAKMa3IV9k+FjEqNpJWc6uJRxYSBTZHfVrFbaFgUW
// SIG // jH/VYijSmnvDB6NfXSwGENMqdDw9x5ImVnx7f5EMY7Rt
// SIG // pcgwUt2wnhYJ5a+45LKlfO2I/l02b7S1LeERnKLltBU/
// SIG // tN4Vtk7RsYRZJBLvxWvIozz8iPZrUktHNKIN6EwkcUZE
// SIG // oYIOPTCCDjkGCisGAQQBgjcDAwExgg4pMIIOJQYJKoZI
// SIG // hvcNAQcCoIIOFjCCDhICAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEPBgsqhkiG9w0BCRABBKCB/wSB/DCB+QIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgLbDImH8H
// SIG // s8ay8pUmuKMHc1TUdIWNsCDFdSkwTnPTOz8CFQCog9M1
// SIG // qHekGqjLe7ocjdlZ+Xj9vxgPMjAxODAxMTYwMzAzMzRa
// SIG // MAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UE
// SIG // CxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UE
// SIG // AxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBT
// SIG // aWduZXIgLSBHMqCCCoswggU4MIIEIKADAgECAhB7BbHU
// SIG // SWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9MQsw
// SIG // CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIElu
// SIG // Yy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdv
// SIG // cmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWduLCBJ
// SIG // bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxODA2
// SIG // BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290IENl
// SIG // cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDExMjAw
// SIG // MDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
// SIG // MIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxxrDKP
// SIG // BWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ+GIb
// SIG // fuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/DubPit
// SIG // ljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmdw/Sa
// SIG // qPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o71PWy
// SIG // m0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J9ZM3
// SIG // vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEbWQ6p
// SIG // PrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeGeMWh
// SIG // NwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEGMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBbBgtg
// SIG // hkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRwczov
// SIG // L2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZGhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEFBQcB
// SIG // AQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5bWNk
// SIG // LmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5z
// SIG // eW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1Ud
// SIG // JQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAbMRkw
// SIG // FwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1UdDgQW
// SIG // BBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSMEGDAW
// SIG // gBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG9w0B
// SIG // AQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq3dxP
// SIG // 86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2YgVgaY
// SIG // GY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0k8hM
// SIG // kGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+EeTU7c
// SIG // yhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYDqA/j
// SIG // U/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q54zoA
// SIG // v86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+XQOG/
// SIG // mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/rqlh
// SIG // gTCCBUswggQzoAMCAQICEFRY8qrXQdZEvISpe6CWUuYw
// SIG // DQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMxHTAb
// SIG // BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYD
// SIG // VQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgwJgYD
// SIG // VQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5n
// SIG // IENBMB4XDTE3MDEwMjAwMDAwMFoXDTI4MDQwMTIzNTk1
// SIG // OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1h
// SIG // bnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50
// SIG // ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3ltYW50
// SIG // ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIgLSBH
// SIG // MjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
// SIG // AJnz/NgECQOG+ddcppPAQnzqfGPPXQDijvPAkN+PKfUY
// SIG // 6pS3kuXXsKBzgejpCptKfAH/nY+kOacO6kX0Igw6cO05
// SIG // RYvkxRtc8EVoRiQFY3abHPyebCqxVuWKf1JxrvI11UYj
// SIG // BhzPSC0dtM242XYjjhz/Pr+7BlxpB6ZlDvhern0u7U2u
// SIG // Ne/J1wBC/SiVDp9dckIJvMPaRNLtzEeE5PzKLaxYvq73
// SIG // rtlEDQi3wnfWGkNw0W4D3lKSxBAIcdm6IlXyH7ztm507
// SIG // 4l4dTIP/lw97C+dVg07SDeu+1+yubke5n9+l1lG8BFXt
// SIG // /ydwTMntKksT4bG5TA/JAe5VZV9pAnhmyz8CAwEAAaOC
// SIG // AccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNVHR8E
// SIG // OTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNVHSUB
// SIG // Af8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMCB4Aw
// SIG // dwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5odHRw
// SIG // Oi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYIKwYB
// SIG // BQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50ZWMu
// SIG // Y29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQhMB+k
// SIG // HTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC01MB0G
// SIG // A1UdDgQWBBQJtcH+lnKXKUOayeACuq74/S+69jAfBgNV
// SIG // HSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjANBgkq
// SIG // hkiG9w0BAQsFAAOCAQEAF7MKiOlcWl4gazsKFbJsxamK
// SIG // MofTsfQcU66Fvj+b/9e8t5SFtMdSfpTove1hstSnmeTD
// SIG // yZPBNT0L6GgKXVaYvbEiO9FEete/8G1RMorVI984ATf2
// SIG // 4lMreisRj7dNbHozAxt8awmUF7vk21jUIRNl5+zRJcos
// SIG // dZqcf/zJuypoq8R9tM+jyWyn2cQAnIkKd5H0TaL7MTuG
// SIG // bvbmH1ADhpu/y0Kr5nabcloRAYrG76VvlefdrrrmImXw
// SIG // GFkbEcnNgLfYl0cfQgj4rHEfsEZTs9Sy1aOrUHVIEheC
// SIG // rc/gQU8yfs2VHL+Rigg9pKdnApbfJEyl0EHAgmCjihcy
// SIG // S9O8z6S0jDGCAlowggJWAgEBMIGLMHcxCzAJBgNVBAYT
// SIG // AlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlv
// SIG // bjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29y
// SIG // azEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVT
// SIG // dGFtcGluZyBDQQIQVFjyqtdB1kS8hKl7oJZS5jALBglg
// SIG // hkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0xODAxMTYwMzAz
// SIG // MzRaMC8GCSqGSIb3DQEJBDEiBCB7qgDzhYvJ7O2rLmjM
// SIG // l89urRJNwLWw37yebmLvRLtWlTA3BgsqhkiG9w0BCRAC
// SIG // LzEoMCYwJDAiBCDPesF60Efs1f3DaCIDGxLU7weLbytM
// SIG // XmukH4/yz0utZzALBgkqhkiG9w0BAQEEggEAWW4OrcIs
// SIG // DiHjAX0yB1PLRJnDNxsWCl6QZk8Z3OOQmZZIaUa1kzgl
// SIG // Bits23VoJLwh7Myl+pvqdjQSWhnzG7yG1qnUhDSt8kbh
// SIG // vra4CbpnfBC9RG9YltlTLvTlSOLNiNCXLgsuCBw3SFyK
// SIG // X7FshjW97bbi78ZQDzv1uUsYXOHQkrvh4mTHwkB98KIh
// SIG // iIZ7UFarGfFB08RZR8VfceSocYoDVEekR+qEXcyrlVhn
// SIG // yhUxzCXDN8kvu50f+O6c03IRAmWYxyXDc0zE4Bx01QvO
// SIG // EfecEVpkcN78Ezep/d0OJLsNC7Js81Gpj5cbsFmN7YoX
// SIG // 7sQzF5mVOJET6+rAC38hw3kctg==
// SIG // End signature block
