// Topic view (jQuery UI widget).
(function ($) {
    $.widget('adsk.topicview', {
        options: {
            caption: "Topic"
        },

        $content: undefined,
        $header: undefined,
        $favorites: undefined,

        goToParentButtonEnabled: false,
        favoritesButtonEnabled: false,
        goBackButtonEnabled: false,

        _create: function() {
            console.log('topicview: _create');

            // Render view.
            this._render();

            // Handle UI events.
            this._addEventHandlers();
        },

        _render: function() {
            console.log('topicview: _render');

            // Create topic view markup.
            this.element.html(
              '<header class="toolbar drop-shadow">' +
                '<div class="column left">' +
                    '<a href="#" id="topic-navigation" class="navigation button icon"/>' +
                    '<a href="#" id="topic-back" class="back button icon disabled"/>' +
                    '<a href="#" id="topic-parent" class="parent button icon disabled"/>' +
                    '<a href="#" id="topic-home" class="home button icon"/>' +
                '</div>' +
                '<div class="column center"></div>' +
                '<div class="column right">' +
                    '<a href="#" id="topic-share" class="share button icon"/>' +
                    '<a href="#" id="topic-favorites" class="favorites button icon disabled"/>' +
                    '<a href="#" id="topic-search" class="search button icon"/>' +
                '</div>' +
              '</header>' +
              '<div class="content"></div>' +
              '<footer class="toolbar">' +
                '<a href="#" class="preceding-topic">' +
                  '<div class="label">Previous topic</div>' +
                  '<div class="name"></div>' +
                  '<div class="path"></div>' +
                '</a>' +
                '<a href="#" class="following-topic">' +
                  '<div class="label">Next topic</div>' +
                  '<div class="name"></div>' +
                  '<div class="path"></div>' +
                '</a>' +
              '</footer>'
            );

            // Store jQuery objects for later use.
            this.$header = this.element.find('header');
            this.$footer = this.element.find('footer');
            this.$content = this.element.find('.content');
            this.$favorites = this.element.find('#topic-favorites');
        },

        _addEventHandlers: function() {
            console.log('topicview: _addEventHandlers');

            // Add look to all tapped buttons.
            this.$header.find('.button')
            .on('touchstart', $.proxy(this._handleToolbarButtonTouchstart, this))
            .on('touchend', $.proxy(this._handleToolbarButtonTouchend, this));

            this.element
            .on('touchmove', function(event) {
                event.preventDefault();
            });

            this.$content
            .on('touchmove', function(event) {
                // Prevent bubbling to enable native scrolling.
                event.stopPropagation();
            });
        },

        _handleToolbarButtonTouchstart: function(event) {
            console.log('topicview: _handleToolbarButtonTouchstart');

            event.preventDefault();
            event.stopPropagation();

            var $target = $(event.target);

            if (!$target.hasClass('disabled')) {
                $target.addClass("tapped");
            }
        },

        _handleToolbarButtonTouchend: function(event) {
            event.preventDefault();
            event.stopPropagation();

            var $target = $(event.target);

            if (!$target.hasClass('disabled')) {
                // Style tapped button.
                $target.removeClass('tapped');

                // Trigger 'buttontap' custom event.
                this._trigger('buttontap', event, $target.attr('id'));
            }
        },

        _setContentHeight: function() {
            console.log('topicview: _setContentHeight');

            var height = $(document).height() - this.$header.height() - this.$footer.height();

            this.$content.css('height', height + 'px');
        },

        _isAbsolutePath: function(url) {
             if ((url.indexOf('http:') == 0) || (url.indexOf('https:') == 0)) {
                 return true;
             }
             return false;
        },

        _changeImageSrc: function(src, base) {
            var changedSrc = src;

            if (src && !this._isAbsolutePath(src)) {
                if (!base) {
                    base = './files/';
                }

                if (src.indexOf('../') == 0) {
                    // ../images/image.png.

                    // Strip "move up to one folder" command.
                    changedSrc = src.substr(1);
                } else {
                    // ./image.png or images.png

                    // Remove './'.
                    if (src.indexOf('./') == 0) {
                        src = src.substr(2);
                    }

                    changedSrc = base.concat(src);
                }

                return changedSrc;
            }
        },

        _changeHyperlinkHref: function(hyperlink, base) {
            var url = hyperlink.getAttribute('href'),
                changedUrl = url,
                target = hyperlink.getAttribute('target');

            if (url && !this._isAbsolutePath(url)) {
                // Not an anchor and not an absolute url.

                if (url.indexOf('../') == 0) {
                    // "Move up one folder" relative path (cases 3, 4 and 5).

                    // Strip "move up to one folder" command.
                    changedUrl = url.substr(1);

                    if (target !== '_blank') {
                         // Add hashbang (case 5).
                         changedUrl = '#!/url='.concat(changedUrl);
                    }
                } else if ((url.charAt(0) != '#') &&
                           (url.indexOf('mailto:') != 0) &&
                           (url.indexOf('javascript') != 0)) {
                    // "Current folder" relative path (topic.htm or ./topic.htm).

                    // Remove './'.
                    if (url.indexOf('./') == 0) {
                        url = url.substr(2);
                    }

                    // Add hashbang and base path (e.g. #!url=./files/topic.htm)
                    changedUrl = '#!/url='.concat(base, url);
                } else if (url == '#') {
                    changedUrl = location.hash;
                }

                hyperlink.setAttribute('href', changedUrl);
            }
        },

        /* Public members. */

        getShareButtonOffset: function() {
            console.log('topicview: getShareButtonOffset');

            var $page = this.element,
                offset = $page.find('#topic-share').offset();

            return offset;
        },

        loadPage: function(href, title, base) {
            console.log('topicview: loadPage, href = ' + href);

            var self = this;

            $container = this.element.find('.content');

            // TODO: find robust way.
            $container.html('');

            var xhr = $
            .get(href)
            .done(function(response) {
                // Replace src attribute with data-src to prevent jQuery html()
                // from triggering the browser request images.
                response = response.replace(/ src=/g, ' data-src=');

                var $bodyContent = $(response).filter('#body-content');

                if (!$bodyContent.length) {
                    $bodyContent = $(response.substring(response.indexOf("<body>"), response.indexOf("</body>") + 7));
                }

                if ($bodyContent.length) {
                    // Replace <a> elements href attribute value.
                    $bodyContent.find('a, area').each(function() {
                        self._changeHyperlinkHref(this, base);
                    });

                    // Add src attributes to <img> elements with slightly changed value of data-src attribute.
                    var images = $bodyContent.find('img');
                    images.each(function() {
                        this.setAttribute('src', self._changeImageSrc(this.getAttribute('data-src')));
                    });

                    // Add collapsible section click listener.
                    images.filter('.collapsible').click(function(event) {
                        var img = $(this);

                        img.toggleClass('opened');

                        // Show/hide collapsible section.
                        img.parents('.collapsible').find('.collapsible-section').toggleClass('hidden');
                    });

                    // Place topic content into container.
                    $container.html($bodyContent);

                    // Scroll to anchor.
                    var fragment = '';
                    if (href.lastIndexOf('#') != -1) {
                        fragment = href.substring(href.lastIndexOf('#') + 1);

                        if (fragment !== undefined && fragment !== '') {
                            var $anchor = $('a[name=' + fragment + ']');

                            console.log('scroll to fragment: ', fragment);
                            $container.scrollTo($anchor, 800);
                        }
                    }

                } else {
                    $container.html(response);
                }

                // Get topic base url.
                var splittedHref = href.split('/'),
                    baseUrl = splittedHref.slice(0, splittedHref.length - 1).join('/');

                    // Override content links and add swipe handlers.
                    self.addBodyContentHandlers(baseUrl);
                })
            .fail(function(response) {
                $container.html(response);
            })
            .always(function() {

            });
        },

        initGoToParentButton: function(enabled) {
            this.goToParentButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-parent').removeClass('disabled');
            } else {
                this.$header.find('#topic-parent').addClass('disabled');
            }
        },

        initFavoritesButton: function(enabled) {
            this.favoritesButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-favorites').removeClass('disabled');
            } else {
                this.$header.find('#topic-favorites').addClass('disabled');
            }
        },

        initGoBackButton: function(enabled) {
            this.goBackButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-back').removeClass('disabled');
            } else {
                this.$header.find('#topic-back').addClass('disabled');
            }
        },

        resize: function() {
            console.log('topicview: resize');

            // Set content container height.
            this._setContentHeight();
        },

        // Flag if topic is in Favorites or not.
        flag: function(addedToFavorites) {
            console.log('topicview: flag');

            if (addedToFavorites) {
                this.$favorites.addClass('flagged');
            } else {
                this.$favorites.removeClass('flagged');
            }
        },

        addBodyContentHandlers: function(baseUrl) {
            console.log('topicview: addBodyContentHandlers');

            // Listen for ALL links at the top level of topic content.
            /*
            $bodyContent
            .on("click", "a", $.proxy(function(event) {
                var $target = $(event.target),
                    targetAttr = $target.attr('target');

                // For some browsers, target is undefined; for others,
                // target is false. Check for both.
                if (typeof targetAttr !== 'undefined' && targetAttr !== false) {
                    // Use default browser action.
                } else {
                    var parser = document.createElement('a');
                    parser.href = $target.attr('href');

                    var href = $target.attr('href');

                    if (location.host == parser.host) {
                        // Stop the default behavior of the browser, which
                        // is to change the URL of the page.
                        event.preventDefault();

                        // Fire event to change location hash.
                        this._trigger('opentopic', {}, {
                            href: baseUrl + '/' + href // resolve
                        });
                    } else {
                        // Use default browser action.
                    }
                }
            }, this));
            */

            this._runRetinaJS();
        },

        _runRetinaJS: function() {
            $('#body-content').find('img').retina('--2x');
        }
    });
})(jQuery);

// SIG // Begin signature block
// SIG // MIIbQgYJKoZIhvcNAQcCoIIbMzCCGy8CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // V8IYNt/8yREf0o2EzHKm2QFjZGG3Ptp6R7oYAsYjIKqg
// SIG // ggoWMIIExzCCA6+gAwIBAgIQANMDPwr2vEKYUg3AWz9B
// SIG // yzANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDEm0ybXlDjakGjfPJQOz8JJyQPZ4frwCIk
// SIG // YuGOWfv+3NZI9Snuy2rQ00G3NuUtmIl0Y0MeypzK5A8s
// SIG // nDGR+bkcRvGn2OmMHS50aggKjsao+rCNMiC8btSwxojg
// SIG // ekzX093J9+/kauZtUESeku1KV2xsBhQ+KTc5TliNgJDJ
// SIG // kB8VW+i2bK0oVx4aMPjX8pivLnbZDYo48U5lQNJtKVBC
// SIG // tnfv0wz2QfRAvXARUxGAnn7xsdgQzYzV6wn+i6N/fMDl
// SIG // e+qWfumXUFSnueYpP85Yi3oNu5kFydgeu34/TTkF1+gD
// SIG // OXfEKLP3cInMUgL7EGTIzHlXaumXFVZobx75J77kq721
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQApMpNskUmvqk2ygWaCDz+3
// SIG // PTZOZl8Q1FKIoGnv2+iq6wblFUCZt+KgKKyoZoHX6GMd
// SIG // Z/YKeTi5PO4QpKQBgm82kOtKVOdUnRXhUderqaAGrX8W
// SIG // qmXjggda1kRud5e+mdcql+RV1A+RVjjVmSATbeXCC0H5
// SIG // mfvO4o5lnBOfkOQeqKxRjWdEhklOszd+1pQVFX761VyA
// SIG // GfXgr0Jtm9dptQBU1TPybl3+ypIV00IldfMGj1VOKZtd
// SIG // ZrgMiXrdaIWOqRhSEyDdQWvqGzTZm7x5elhF3vcGkRZb
// SIG // 1XqtS7OgDJ7wW0z28NMLA9yfFsPFfOQfMBEEgoCc01P9
// SIG // MBPyiz1XO28kMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCEMIIQgAIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQANMD
// SIG // Pwr2vEKYUg3AWz9ByzANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCD41PVU56OicB16
// SIG // bDzBqn16ggckr80wTFg1dyWiZoLlsjANBgkqhkiG9w0B
// SIG // AQEFAASCAQCapsxMbMcVpJa+YF/nWNcE8Qu+QrMzY4/l
// SIG // On3tTNmGOoOXTuHX6SBDNxdp8g6MzoEml4tWFJIthV98
// SIG // qslSLBdpExker32Gb9znrB+KBjZbfqA5bschzCSbKcn6
// SIG // 3f0+pwluHYvQuapm7V7wlzl5QMRduLTSstaSVd3cERiG
// SIG // d+Wpl5MaLhZvdg8jcLpxk/xslNMqJSgo5PB37a4kWU/E
// SIG // omyN6dCzPh++E0tv2jRH5zxsFkNLq9ZsnTPjbDA4I8Xr
// SIG // VS4Tp4jbjygG9+erorzlxNU1G/DdmzYl8rDkhj60lZn9
// SIG // OP3eVpefxg3dRoRjrRjdYFnSPgmIY/L/JI7swi/ltWka
// SIG // oYIOPTCCDjkGCisGAQQBgjcDAwExgg4pMIIOJQYJKoZI
// SIG // hvcNAQcCoIIOFjCCDhICAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEPBgsqhkiG9w0BCRABBKCB/wSB/DCB+QIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgvlc4K/T+
// SIG // XIE7BUbuWc+NrI3toyxRIQCLqL3rbnKp/4kCFQDit+Af
// SIG // icJdIRrsAiwsjFeNDVL4DxgPMjAxODAxMTYwMzAzMzRa
// SIG // MAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UE
// SIG // CxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UE
// SIG // AxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBT
// SIG // aWduZXIgLSBHMqCCCoswggU4MIIEIKADAgECAhB7BbHU
// SIG // SWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9MQsw
// SIG // CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIElu
// SIG // Yy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdv
// SIG // cmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWduLCBJ
// SIG // bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxODA2
// SIG // BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290IENl
// SIG // cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDExMjAw
// SIG // MDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
// SIG // MIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxxrDKP
// SIG // BWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ+GIb
// SIG // fuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/DubPit
// SIG // ljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmdw/Sa
// SIG // qPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o71PWy
// SIG // m0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J9ZM3
// SIG // vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEbWQ6p
// SIG // PrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeGeMWh
// SIG // NwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEGMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBbBgtg
// SIG // hkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRwczov
// SIG // L2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZGhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEFBQcB
// SIG // AQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5bWNk
// SIG // LmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5z
// SIG // eW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1Ud
// SIG // JQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAbMRkw
// SIG // FwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1UdDgQW
// SIG // BBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSMEGDAW
// SIG // gBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG9w0B
// SIG // AQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq3dxP
// SIG // 86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2YgVgaY
// SIG // GY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0k8hM
// SIG // kGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+EeTU7c
// SIG // yhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYDqA/j
// SIG // U/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q54zoA
// SIG // v86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+XQOG/
// SIG // mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/rqlh
// SIG // gTCCBUswggQzoAMCAQICEFRY8qrXQdZEvISpe6CWUuYw
// SIG // DQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMxHTAb
// SIG // BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYD
// SIG // VQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgwJgYD
// SIG // VQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5n
// SIG // IENBMB4XDTE3MDEwMjAwMDAwMFoXDTI4MDQwMTIzNTk1
// SIG // OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1h
// SIG // bnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50
// SIG // ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3ltYW50
// SIG // ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIgLSBH
// SIG // MjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
// SIG // AJnz/NgECQOG+ddcppPAQnzqfGPPXQDijvPAkN+PKfUY
// SIG // 6pS3kuXXsKBzgejpCptKfAH/nY+kOacO6kX0Igw6cO05
// SIG // RYvkxRtc8EVoRiQFY3abHPyebCqxVuWKf1JxrvI11UYj
// SIG // BhzPSC0dtM242XYjjhz/Pr+7BlxpB6ZlDvhern0u7U2u
// SIG // Ne/J1wBC/SiVDp9dckIJvMPaRNLtzEeE5PzKLaxYvq73
// SIG // rtlEDQi3wnfWGkNw0W4D3lKSxBAIcdm6IlXyH7ztm507
// SIG // 4l4dTIP/lw97C+dVg07SDeu+1+yubke5n9+l1lG8BFXt
// SIG // /ydwTMntKksT4bG5TA/JAe5VZV9pAnhmyz8CAwEAAaOC
// SIG // AccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNVHR8E
// SIG // OTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNVHSUB
// SIG // Af8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMCB4Aw
// SIG // dwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5odHRw
// SIG // Oi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYIKwYB
// SIG // BQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50ZWMu
// SIG // Y29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQhMB+k
// SIG // HTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC01MB0G
// SIG // A1UdDgQWBBQJtcH+lnKXKUOayeACuq74/S+69jAfBgNV
// SIG // HSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjANBgkq
// SIG // hkiG9w0BAQsFAAOCAQEAF7MKiOlcWl4gazsKFbJsxamK
// SIG // MofTsfQcU66Fvj+b/9e8t5SFtMdSfpTove1hstSnmeTD
// SIG // yZPBNT0L6GgKXVaYvbEiO9FEete/8G1RMorVI984ATf2
// SIG // 4lMreisRj7dNbHozAxt8awmUF7vk21jUIRNl5+zRJcos
// SIG // dZqcf/zJuypoq8R9tM+jyWyn2cQAnIkKd5H0TaL7MTuG
// SIG // bvbmH1ADhpu/y0Kr5nabcloRAYrG76VvlefdrrrmImXw
// SIG // GFkbEcnNgLfYl0cfQgj4rHEfsEZTs9Sy1aOrUHVIEheC
// SIG // rc/gQU8yfs2VHL+Rigg9pKdnApbfJEyl0EHAgmCjihcy
// SIG // S9O8z6S0jDGCAlowggJWAgEBMIGLMHcxCzAJBgNVBAYT
// SIG // AlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlv
// SIG // bjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29y
// SIG // azEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVT
// SIG // dGFtcGluZyBDQQIQVFjyqtdB1kS8hKl7oJZS5jALBglg
// SIG // hkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0xODAxMTYwMzAz
// SIG // MzRaMC8GCSqGSIb3DQEJBDEiBCD3njOVIPPyA9G3VXJb
// SIG // DWy/5pIVJlJuGGkmU5hQf9trCDA3BgsqhkiG9w0BCRAC
// SIG // LzEoMCYwJDAiBCDPesF60Efs1f3DaCIDGxLU7weLbytM
// SIG // XmukH4/yz0utZzALBgkqhkiG9w0BAQEEggEAiwhAu+UG
// SIG // trWXsa8lVI8U9329sFO5jUDD2Y9Wc/U1/v0ZtS/huQnu
// SIG // p1Eh/KN1FYqjHOGdZ3rUqzw9omoTtTg2/UoTIqPIBaHC
// SIG // tYnfZqhEgkg0nd9l8YD19IsA4LuvjGuwuA9GS8boNKXQ
// SIG // DZDAuK79eCG27J3o4l3hcz3eYTuwl2UuWz9EloUidt9b
// SIG // DsPE0Z1IpIul2hgv7iHMuHuQRqGvn37wh/mJV2zo8cip
// SIG // Ageb9MtOU2UsqchtyIakG2zYN63GTVnwc6ylIeLMp+6h
// SIG // G+3ygxsQ2xFJXcHMlHqdywuQ5plzzv5Y/wRrEtu7/JyH
// SIG // P6aCD02RJEgE1Uqj7OxPKJ0smA==
// SIG // End signature block
