/*

jQuery highlight plugin

Highlights arbitrary terms.

<http://www.frightanic.com/projects/lenient-jquery-highlight-plugin-javascript/>

Based on work by Johann Burkhard
<http://johannburkard.de/blog/programming/javascript/dynacloud-a-dynamic-javascript-tag-keyword-cloud-with-jquery.html>

MIT license.

Marcel StÃ¶r
<http://www.frightanic.com>
*/

/*

    Changes to original code by Autodesk:
    should be case sensitive for lenient -- false.

*/

/*
 * Highlights the given term in all text nodes (transitive) for which this
 * function is called. If lenient == true the pattern matching will be case- and
 * accent-insensitive. Otherwise it will simply be case-insensitive.
 */
jQuery.fn.highlight = function(searchString, lenient) {
  var input = "";
  if (lenient) {
    input = createAccentRegexp(searchString);
  } else {
    //input = searchString.toUpperCase();
    input = searchString;
  }
  return this.each(function() {
    setHighlight(this, input);
  });

  function setHighlight(node, pattern) {
    var skip = 0;
    // Do this only for text nodes. Else go find child nodes...
    if (node.nodeType == 3) {
      var index = 0;
      // If lenient then the pattern is expected to be a regexp.
      if (lenient) {
        index = node.data.search(pattern);
      } else {
        //index = node.data.toUpperCase().indexOf(pattern);
        index = node.data.indexOf(pattern);
      }
      if (index >= 0) {
        var spanNode = document.createElement("span");
        spanNode.className = highlightClass;
        var nodeStart = node.splitText(index);
        var nodeEnd = nodeStart.splitText(searchString.length);
        var nodeHighlight = nodeStart.cloneNode(true);
        spanNode.appendChild(nodeHighlight);
        nodeStart.parentNode.replaceChild(spanNode, nodeStart);
        skip = 1;
      }
    } else {
      if (node.nodeType == 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {
        for (var i = 0; i < node.childNodes.length; ++i) {
          i += setHighlight(node.childNodes[i], pattern);
        }
      }
    }
    return skip;
  }

  /*
   * Creates a regexp for case- and accent-insensitive matching of a regular
   * alphabetic string. For each character in the original string the output
   * contains a regexp character class that matches the character itself and all
   * unicode variations. So, if the input is "Foo" the function returns
   * something like [Ff...][OoÃ–Ã¶Ã’Ã²..][OoÃ–Ã¶Ã’Ã²..].
   * Inspiration:
   * http://stackoverflow.com/questions/227950/programatic-accent-reduction-in-javascript-aka-text-normalization-or-unaccenting
   */
  function createAccentRegexp(characters) {
    // Replaces all accented characters.
    var deaccentedString = deaccent(characters);
    // Escapes all regexp meta characters.
    var cleanString = deaccentedString.replace(/([|()[{.+*?^$\\])/g,"\\$1");
    var accentReplacer = function(character) {
      return charToAccentedCharClassMap[character] || character;
    };
    // Matches anything *but* a whitespace and replaces it.
    var regexp = cleanString.replace(/\S/g, accentReplacer);
    return new RegExp(regexp, "g");
  }

  /*
   * Returns a string in which each accented and lower-case character from the
   * input is replaced with the respective upper-case base character in the A-Z
   * range (e.g. Ã¤->A, Ã¨->E, Ã¥->A, Ã«->E). Hence, the return value for
   * "sÃ©lÃ©ction" is "SELECTION".
   */
  function deaccent(accentedString) {
    var result = accentedString;
    for (var key in charToAccentedCharClassMap) {
      result = result.replace(new RegExp(charToAccentedCharClassMap[key], "g"), key);
    }
    return result;
  }
};

jQuery.fn.removeHighlight = function() {
  return this.find("span.".concat(highlightClass)).each(function() {
    this.parentNode.firstChild.nodeName;
    with (this.parentNode) {
      replaceChild(this.firstChild, this);
      normalize();
    }
  }).end();
};

/*
 * Map generated from ftp.unicode.org/Public/UNIDATA/UnicodeData.txt. Maps each
 * upper-case basic alphabet character in the A-Z range to a regex character
 * class that contains all variations (accented, unaccented, upper-case,
 * lower-case) of this character (e.g. A->[AaÃ„Ã¤Ã¥....]).
 */
var charToAccentedCharClassMap = {
  'A': '[Aa\xaa\xc0-\xc5\xe0-\xe5\u0100-\u0105\u01cd\u01ce\u0200-\u0203\u0226\u0227\u1d2c\u1d43\u1e00\u1e01\u1e9a\u1ea0-\u1ea3\u2090\u2100\u2101\u213b\u249c\u24b6\u24d0\u3371-\u3374\u3380-\u3384\u3388\u3389\u33a9-\u33af\u33c2\u33ca\u33df\u33ff\uff21\uff41]',
  'B': '[Bb\u1d2e\u1d47\u1e02-\u1e07\u212c\u249d\u24b7\u24d1\u3374\u3385-\u3387\u33c3\u33c8\u33d4\u33dd\uff22\uff42]',
  'C': '[Cc\xc7\xe7\u0106-\u010d\u1d9c\u2100\u2102\u2103\u2105\u2106\u212d\u216d\u217d\u249e\u24b8\u24d2\u3376\u3388\u3389\u339d\u33a0\u33a4\u33c4-\u33c7\uff23\uff43]',
  'D': '[Dd\u010e\u010f\u01c4-\u01c6\u01f1-\u01f3\u1d30\u1d48\u1e0a-\u1e13\u2145\u2146\u216e\u217e\u249f\u24b9\u24d3\u32cf\u3372\u3377-\u3379\u3397\u33ad-\u33af\u33c5\u33c8\uff24\uff44]',
  'E': '[Ee\xc8-\xcb\xe8-\xeb\u0112-\u011b\u0204-\u0207\u0228\u0229\u1d31\u1d49\u1e18-\u1e1b\u1eb8-\u1ebd\u2091\u2121\u212f\u2130\u2147\u24a0\u24ba\u24d4\u3250\u32cd\u32ce\uff25\uff45]',
  'F': '[Ff\u1da0\u1e1e\u1e1f\u2109\u2131\u213b\u24a1\u24bb\u24d5\u338a-\u338c\u3399\ufb00-\ufb04\uff26\uff46]',
  'G': '[Gg\u011c-\u0123\u01e6\u01e7\u01f4\u01f5\u1d33\u1d4d\u1e20\u1e21\u210a\u24a2\u24bc\u24d6\u32cc\u32cd\u3387\u338d-\u338f\u3393\u33ac\u33c6\u33c9\u33d2\u33ff\uff27\uff47]',
  'H': '[Hh\u0124\u0125\u021e\u021f\u02b0\u1d34\u1e22-\u1e2b\u1e96\u210b-\u210e\u24a3\u24bd\u24d7\u32cc\u3371\u3390-\u3394\u33ca\u33cb\u33d7\uff28\uff48]',
  'I': '[Ii\xcc-\xcf\xec-\xef\u0128-\u0130\u0132\u0133\u01cf\u01d0\u0208-\u020b\u1d35\u1d62\u1e2c\u1e2d\u1ec8-\u1ecb\u2071\u2110\u2111\u2139\u2148\u2160-\u2163\u2165-\u2168\u216a\u216b\u2170-\u2173\u2175-\u2178\u217a\u217b\u24a4\u24be\u24d8\u337a\u33cc\u33d5\ufb01\ufb03\uff29\uff49]',
  'J': '[Jj\u0132-\u0135\u01c7-\u01cc\u01f0\u02b2\u1d36\u2149\u24a5\u24bf\u24d9\u2c7c\uff2a\uff4a]',
  'K': '[Kk\u0136\u0137\u01e8\u01e9\u1d37\u1d4f\u1e30-\u1e35\u212a\u24a6\u24c0\u24da\u3384\u3385\u3389\u338f\u3391\u3398\u339e\u33a2\u33a6\u33aa\u33b8\u33be\u33c0\u33c6\u33cd-\u33cf\uff2b\uff4b]',
  'L': '[Ll\u0139-\u0140\u01c7-\u01c9\u02e1\u1d38\u1e36\u1e37\u1e3a-\u1e3d\u2112\u2113\u2121\u216c\u217c\u24a7\u24c1\u24db\u32cf\u3388\u3389\u33d0-\u33d3\u33d5\u33d6\u33ff\ufb02\ufb04\uff2c\uff4c]',
  'M': '[Mm\u1d39\u1d50\u1e3e-\u1e43\u2120\u2122\u2133\u216f\u217f\u24a8\u24c2\u24dc\u3377-\u3379\u3383\u3386\u338e\u3392\u3396\u3399-\u33a8\u33ab\u33b3\u33b7\u33b9\u33bd\u33bf\u33c1\u33c2\u33ce\u33d0\u33d4-\u33d6\u33d8\u33d9\u33de\u33df\uff2d\uff4d]',
  'N': '[Nn\xd1\xf1\u0143-\u0149\u01ca-\u01cc\u01f8\u01f9\u1d3a\u1e44-\u1e4b\u207f\u2115\u2116\u24a9\u24c3\u24dd\u3381\u338b\u339a\u33b1\u33b5\u33bb\u33cc\u33d1\uff2e\uff4e]',
  'O': '[Oo\xba\xd2-\xd6\xf2-\xf6\u014c-\u0151\u01a0\u01a1\u01d1\u01d2\u01ea\u01eb\u020c-\u020f\u022e\u022f\u1d3c\u1d52\u1ecc-\u1ecf\u2092\u2105\u2116\u2134\u24aa\u24c4\u24de\u3375\u33c7\u33d2\u33d6\uff2f\uff4f]',
  'P': '[Pp\u1d3e\u1d56\u1e54-\u1e57\u2119\u24ab\u24c5\u24df\u3250\u3371\u3376\u3380\u338a\u33a9-\u33ac\u33b0\u33b4\u33ba\u33cb\u33d7-\u33da\uff30\uff50]',
  'Q': '[Qq\u211a\u24ac\u24c6\u24e0\u33c3\uff31\uff51]',
  'R': '[Rr\u0154-\u0159\u0210-\u0213\u02b3\u1d3f\u1d63\u1e58-\u1e5b\u1e5e\u1e5f\u20a8\u211b-\u211d\u24ad\u24c7\u24e1\u32cd\u3374\u33ad-\u33af\u33da\u33db\uff32\uff52]',
  'S': '[Ss\u015a-\u0161\u017f\u0218\u0219\u02e2\u1e60-\u1e63\u20a8\u2101\u2120\u24ae\u24c8\u24e2\u33a7\u33a8\u33ae-\u33b3\u33db\u33dc\ufb06\uff33\uff53]',
  'T': '[Tt\u0162-\u0165\u021a\u021b\u1d40\u1d57\u1e6a-\u1e71\u1e97\u2121\u2122\u24af\u24c9\u24e3\u3250\u32cf\u3394\u33cf\ufb05\ufb06\uff34\uff54]',
  'U': '[Uu\xd9-\xdc\xf9-\xfc\u0168-\u0173\u01af\u01b0\u01d3\u01d4\u0214-\u0217\u1d41\u1d58\u1d64\u1e72-\u1e77\u1ee4-\u1ee7\u2106\u24b0\u24ca\u24e4\u3373\u337a\uff35\uff55]',
  'V': '[Vv\u1d5b\u1d65\u1e7c-\u1e7f\u2163-\u2167\u2173-\u2177\u24b1\u24cb\u24e5\u2c7d\u32ce\u3375\u33b4-\u33b9\u33dc\u33de\uff36\uff56]',
  'W': '[Ww\u0174\u0175\u02b7\u1d42\u1e80-\u1e89\u1e98\u24b2\u24cc\u24e6\u33ba-\u33bf\u33dd\uff37\uff57]',
  'X': '[Xx\u02e3\u1e8a-\u1e8d\u2093\u213b\u2168-\u216b\u2178-\u217b\u24b3\u24cd\u24e7\u33d3\uff38\uff58]',
  'Y': '[Yy\xdd\xfd\xff\u0176-\u0178\u0232\u0233\u02b8\u1e8e\u1e8f\u1e99\u1ef2-\u1ef9\u24b4\u24ce\u24e8\u33c9\uff39\uff59]',
  'Z': '[Zz\u0179-\u017e\u01f1-\u01f3\u1dbb\u1e90-\u1e95\u2124\u2128\u24b5\u24cf\u24e9\u3390-\u3394\uff3a\uff5a]'
};

var highlightClass = "search-word-highlight";
// SIG // Begin signature block
// SIG // MIIbQgYJKoZIhvcNAQcCoIIbMzCCGy8CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // si12xzCnrGFB6tYk+MUaeYif/6ydH4oGBudj7uDDsEig
// SIG // ggoWMIIExzCCA6+gAwIBAgIQANMDPwr2vEKYUg3AWz9B
// SIG // yzANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQDEm0ybXlDjakGjfPJQOz8JJyQPZ4frwCIk
// SIG // YuGOWfv+3NZI9Snuy2rQ00G3NuUtmIl0Y0MeypzK5A8s
// SIG // nDGR+bkcRvGn2OmMHS50aggKjsao+rCNMiC8btSwxojg
// SIG // ekzX093J9+/kauZtUESeku1KV2xsBhQ+KTc5TliNgJDJ
// SIG // kB8VW+i2bK0oVx4aMPjX8pivLnbZDYo48U5lQNJtKVBC
// SIG // tnfv0wz2QfRAvXARUxGAnn7xsdgQzYzV6wn+i6N/fMDl
// SIG // e+qWfumXUFSnueYpP85Yi3oNu5kFydgeu34/TTkF1+gD
// SIG // OXfEKLP3cInMUgL7EGTIzHlXaumXFVZobx75J77kq721
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQApMpNskUmvqk2ygWaCDz+3
// SIG // PTZOZl8Q1FKIoGnv2+iq6wblFUCZt+KgKKyoZoHX6GMd
// SIG // Z/YKeTi5PO4QpKQBgm82kOtKVOdUnRXhUderqaAGrX8W
// SIG // qmXjggda1kRud5e+mdcql+RV1A+RVjjVmSATbeXCC0H5
// SIG // mfvO4o5lnBOfkOQeqKxRjWdEhklOszd+1pQVFX761VyA
// SIG // GfXgr0Jtm9dptQBU1TPybl3+ypIV00IldfMGj1VOKZtd
// SIG // ZrgMiXrdaIWOqRhSEyDdQWvqGzTZm7x5elhF3vcGkRZb
// SIG // 1XqtS7OgDJ7wW0z28NMLA9yfFsPFfOQfMBEEgoCc01P9
// SIG // MBPyiz1XO28kMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCEMIIQgAIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQANMD
// SIG // Pwr2vEKYUg3AWz9ByzANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCCK5NqJ4tnzc6Lr
// SIG // UeD5yFynpdlvFjwCsz6lD2y0kj/IaDANBgkqhkiG9w0B
// SIG // AQEFAASCAQBxMrqnKg5HJOoLMzOs7AWReOkkOXkNt91j
// SIG // cgj/j1/2ag+yY6eV1SBtV/qrZi4aqN/jChtwRMPivHqE
// SIG // c//0iHCipZmHxZcHoJEJ41z9O77gLbAk4wRP9Dk618Gb
// SIG // H3aX+CJF0kZVMYn+MXVNDtfGeJ1z6oq6y/BBSNCqYNyS
// SIG // NaX2UuHgm20vHezs7xDIZY5g5sLuTR7VizMguaJZrrEH
// SIG // 4x1erOLh10+SB70LnPiB8DFcA0OM8kH7WF0V28+fV2hA
// SIG // nQiib0U103ET/hpCPGlrqJY3ta0IEDNRFxlh0fKlrP1g
// SIG // 4PtwP/bAtZYjtbfud1bdFEkUz3bAXGZLOu/7FLxz3YNk
// SIG // oYIOPTCCDjkGCisGAQQBgjcDAwExgg4pMIIOJQYJKoZI
// SIG // hvcNAQcCoIIOFjCCDhICAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEPBgsqhkiG9w0BCRABBKCB/wSB/DCB+QIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgJPH97U0m
// SIG // W5AbZr/vUOcv/CR+ru9R4HNAHaE3J6pxARACFQD7lq8K
// SIG // 7oxgEMdxEznkRZPTJbnX1xgPMjAxODAxMTYwMzAzMzRa
// SIG // MAMCAR6ggYakgYMwgYAxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UE
// SIG // CxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UE
// SIG // AxMoU3ltYW50ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBT
// SIG // aWduZXIgLSBHMqCCCoswggU4MIIEIKADAgECAhB7BbHU
// SIG // SWhRRPfJidKcGZ0SMA0GCSqGSIb3DQEBCwUAMIG9MQsw
// SIG // CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIElu
// SIG // Yy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdv
// SIG // cmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWduLCBJ
// SIG // bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxODA2
// SIG // BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNhbCBSb290IENl
// SIG // cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE2MDExMjAw
// SIG // MDAwMFoXDTMxMDExMTIzNTk1OVowdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
// SIG // MIIBCgKCAQEAu1mdWVVPnYxyXRqBoutV87ABrTxxrDKP
// SIG // BWuGmicAMpdqTclkFEspu8LZKbku7GOz4c8/C1aQ+GIb
// SIG // fuumB+Lef15tQDjUkQbnQXx5HMvLrRu/2JWR8/DubPit
// SIG // ljkuf8EnuHg5xYSl7e2vh47Ojcdt6tKYtTofHjmdw/Sa
// SIG // qPSE4cTRfHHGBim0P+SDDSbDewg+TfkKtzNJ/8o71PWy
// SIG // m0vhiJka9cDpMxTW38eA25Hu/rySV3J39M2ozP4J9ZM3
// SIG // vpWIasXc9LFL1M7oCZFftYR5NYp4rBkyjyPBMkEbWQ6p
// SIG // PrHM+dYr77fY5NUdbRE6kvaTyZzjSO67Uw7UNpeGeMWh
// SIG // NwIDAQABo4IBdzCCAXMwDgYDVR0PAQH/BAQDAgEGMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBbBgtg
// SIG // hkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRwczov
// SIG // L2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZGhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL3JwYTAuBggrBgEFBQcB
// SIG // AQQiMCAwHgYIKwYBBQUHMAGGEmh0dHA6Ly9zLnN5bWNk
// SIG // LmNvbTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5z
// SIG // eW1jYi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1Ud
// SIG // JQQMMAoGCCsGAQUFBwMIMCgGA1UdEQQhMB+kHTAbMRkw
// SIG // FwYDVQQDExBUaW1lU3RhbXAtMjA0OC0zMB0GA1UdDgQW
// SIG // BBSvY9bKo06FcuCnvEHzKaI4f4B1YjAfBgNVHSMEGDAW
// SIG // gBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG9w0B
// SIG // AQsFAAOCAQEAdeqwLdU0GVwyRf4O4dRPpnjBb9fq3dxP
// SIG // 86HIgYj3p48V5kApreZd9KLZVmSEcTAq3R5hF2YgVgaY
// SIG // GY1dcfL4l7wJ/RyRR8ni6I0D+8yQL9YKbE4z7Na0k8hM
// SIG // kGNIOUAhxN3WbomYPLWYl+ipBrcJyY9TV0GQL+EeTU7c
// SIG // yhB4bEJu8LbF+GFcUvVO9muN90p6vvPN/QPX2fYDqA/j
// SIG // U/cKdezGdS6qZoUEmbf4Blfhxg726K/a7JsYH6q54zoA
// SIG // v86KlMsB257HOLsPUqvR45QDYApNoP4nbRQy/D+XQOG/
// SIG // mYnb5DkUvdrk08PqK1qzlVhVBH3HmuwjA42FKtL/rqlh
// SIG // gTCCBUswggQzoAMCAQICEFRY8qrXQdZEvISpe6CWUuYw
// SIG // DQYJKoZIhvcNAQELBQAwdzELMAkGA1UEBhMCVVMxHTAb
// SIG // BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYD
// SIG // VQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMSgwJgYD
// SIG // VQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5n
// SIG // IENBMB4XDTE3MDEwMjAwMDAwMFoXDTI4MDQwMTIzNTk1
// SIG // OVowgYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1h
// SIG // bnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50
// SIG // ZWMgVHJ1c3QgTmV0d29yazExMC8GA1UEAxMoU3ltYW50
// SIG // ZWMgU0hBMjU2IFRpbWVTdGFtcGluZyBTaWduZXIgLSBH
// SIG // MjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
// SIG // AJnz/NgECQOG+ddcppPAQnzqfGPPXQDijvPAkN+PKfUY
// SIG // 6pS3kuXXsKBzgejpCptKfAH/nY+kOacO6kX0Igw6cO05
// SIG // RYvkxRtc8EVoRiQFY3abHPyebCqxVuWKf1JxrvI11UYj
// SIG // BhzPSC0dtM242XYjjhz/Pr+7BlxpB6ZlDvhern0u7U2u
// SIG // Ne/J1wBC/SiVDp9dckIJvMPaRNLtzEeE5PzKLaxYvq73
// SIG // rtlEDQi3wnfWGkNw0W4D3lKSxBAIcdm6IlXyH7ztm507
// SIG // 4l4dTIP/lw97C+dVg07SDeu+1+yubke5n9+l1lG8BFXt
// SIG // /ydwTMntKksT4bG5TA/JAe5VZV9pAnhmyz8CAwEAAaOC
// SIG // AccwggHDMAwGA1UdEwEB/wQCMAAwZgYDVR0gBF8wXTBb
// SIG // BgtghkgBhvhFAQcXAzBMMCMGCCsGAQUFBwIBFhdodHRw
// SIG // czovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcCAjAZ
// SIG // GhdodHRwczovL2Quc3ltY2IuY29tL3JwYTBABgNVHR8E
// SIG // OTA3MDWgM6Axhi9odHRwOi8vdHMtY3JsLndzLnN5bWFu
// SIG // dGVjLmNvbS9zaGEyNTYtdHNzLWNhLmNybDAWBgNVHSUB
// SIG // Af8EDDAKBggrBgEFBQcDCDAOBgNVHQ8BAf8EBAMCB4Aw
// SIG // dwYIKwYBBQUHAQEEazBpMCoGCCsGAQUFBzABhh5odHRw
// SIG // Oi8vdHMtb2NzcC53cy5zeW1hbnRlYy5jb20wOwYIKwYB
// SIG // BQUHMAKGL2h0dHA6Ly90cy1haWEud3Muc3ltYW50ZWMu
// SIG // Y29tL3NoYTI1Ni10c3MtY2EuY2VyMCgGA1UdEQQhMB+k
// SIG // HTAbMRkwFwYDVQQDExBUaW1lU3RhbXAtMjA0OC01MB0G
// SIG // A1UdDgQWBBQJtcH+lnKXKUOayeACuq74/S+69jAfBgNV
// SIG // HSMEGDAWgBSvY9bKo06FcuCnvEHzKaI4f4B1YjANBgkq
// SIG // hkiG9w0BAQsFAAOCAQEAF7MKiOlcWl4gazsKFbJsxamK
// SIG // MofTsfQcU66Fvj+b/9e8t5SFtMdSfpTove1hstSnmeTD
// SIG // yZPBNT0L6GgKXVaYvbEiO9FEete/8G1RMorVI984ATf2
// SIG // 4lMreisRj7dNbHozAxt8awmUF7vk21jUIRNl5+zRJcos
// SIG // dZqcf/zJuypoq8R9tM+jyWyn2cQAnIkKd5H0TaL7MTuG
// SIG // bvbmH1ADhpu/y0Kr5nabcloRAYrG76VvlefdrrrmImXw
// SIG // GFkbEcnNgLfYl0cfQgj4rHEfsEZTs9Sy1aOrUHVIEheC
// SIG // rc/gQU8yfs2VHL+Rigg9pKdnApbfJEyl0EHAgmCjihcy
// SIG // S9O8z6S0jDGCAlowggJWAgEBMIGLMHcxCzAJBgNVBAYT
// SIG // AlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlv
// SIG // bjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29y
// SIG // azEoMCYGA1UEAxMfU3ltYW50ZWMgU0hBMjU2IFRpbWVT
// SIG // dGFtcGluZyBDQQIQVFjyqtdB1kS8hKl7oJZS5jALBglg
// SIG // hkgBZQMEAgGggaQwGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0xODAxMTYwMzAz
// SIG // MzRaMC8GCSqGSIb3DQEJBDEiBCAvYnRELwma14ldhTaJ
// SIG // eOUB0gnar4FWAS7HbSKSUR/pPTA3BgsqhkiG9w0BCRAC
// SIG // LzEoMCYwJDAiBCDPesF60Efs1f3DaCIDGxLU7weLbytM
// SIG // XmukH4/yz0utZzALBgkqhkiG9w0BAQEEggEAME4FYsq/
// SIG // R7fPXzaB9GM+ggaRxivOoiyNJmymCacGlxIgjINoDNz4
// SIG // vl7jglPFYXdezRVdMiME2VWUV2u9rN/vXkMEERjdzzL9
// SIG // hev0v3dqlRxBtMmuCU7hJl2E15VHmtYoAZfiYqhequAs
// SIG // S4Ikh5qrNP6LOeAbz1uy1koGYoONWnq1LpQwNWX1ZcFY
// SIG // u0tjP358BFLXwzcm0FvrVM9OcRRMI7LbdMLfgs3gk+Lm
// SIG // hPs89dgZkkeXOhWJDmPVDA/YQhhRULol4EoW9AYXivqd
// SIG // XyByAajtdiBp8i7GFrAaMRFYY4BIBgbHmfyFg1yLg0FH
// SIG // j8ZJn7GeJ2loKFTwYgrdfB+dtA==
// SIG // End signature block
