#!/usr/bin/perl

require './filemin-lib.pl';
use Cwd 'abs_path';

&ReadParse(\%in, "GET");

get_paths();

my @errors;
$line = "";

# Use Webmin's callback function to track progress
$cbfunc = \&read_parse_mime_callback;

# Get multipart form boundary
$ENV{'CONTENT_TYPE'} =~ /boundary=(.*)$/ || &error($text{'readparse_enc'});
$boundary = $1;

# Comment right now
#if ($ENV{'CONTENT_LENGTH'} && $max && $ENV{'CONTENT_LENGTH'} > $max) {
#  	&error($err);
#}

# Initialize progress tracker
&$cbfunc(0, $ENV{'CONTENT_LENGTH'}, undef, $in{'id'});

#Read the data
while(index($line,"$boundary--") == -1) {
    #reset vars on each loop
    $file = undef;
    $rest = undef;
    $prevline = undef;
    $header = undef;
    $line = <STDIN>;
    $got += length($line);
  	&$cbfunc($got, $ENV{'CONTENT_LENGTH'}, undef, $in{'id'});
    if ($line =~ /(\S+):\s*form-data(.*)$/) {
    		$rest = $2; # We found form data definition, let`s check it
    } else {
        next;
    }
    # Check if current form data part is file
		while ($rest =~ /([a-zA-Z]*)=\"([^\"]*)\"(.*)/) {
		    if ($1 eq 'filename') {
				    $file = $2;
				}
		    $rest = $3;
    }
    
    if(defined($file)){
        # OK, we have a file, let`s save it
        if (-e "$cwd/$file") {
            push @errors, "$path/$file $text{'error_exists'}";
            next;
        } else {
            if (!open(OUTFILE, ">$cwd/$file")) {
                push @errors, "$text{'error_opening_file_for_writing'} $path/$file - $!"; #die "Can't open $cwd/$file for writing - $!";
                next;        
            } else {
              binmode(OUTFILE);
              # Skip "content-type" as we work in binmode anyway and skip empty line
              <STDIN>; <STDIN>;
              # Read all lines until next boundary or form data end
              while(1) {
                  $line = <STDIN>;
                  # Inform progress tracker about our actions
                  $got += length($line);
       	          &$cbfunc($got, $ENV{'CONTENT_LENGTH'}, $file, $in{'id'});
                  # Some brainf###ing to deal with last CRLF
                  if(index($line,"$boundary") != -1 || index($line,"$boundary--") != -1) {
                      chop($prevline);
                      chop($prevline);
                      if (!print OUTFILE $prevline) {
                          push errors, "text{'error_writing_file'} $path/$file";
                          last;
                      }
                      last;
                  } else {
                      if (!print OUTFILE $prevline) {
                          push errors, "text{'error_writing_file'} $path/$file";
                          last;
                      }
                      $prevline = $line;
                  }
              }
              # File saved, let`s go further
              close(OUTFILE);
            }
        }
    } else {
        # Just skip everything until next boundary or form data end
        while(index($line,"$boundary") == -1 or index($line,"$boundary--") == -1) {
            $line = <STDIN>;
        }        
    }
}
# Everything finished, inform progress tracker
&$cbfunc(-1, $ENV{'CONTENT_LENGTH'}, undef, $in{'id'});
#&ui_print_footer("index.cgi?path=$path", $text{'previous_page'});
if (scalar(@errors) > 0) {
    print_errors(@errors);
} else {
    &redirect("index.cgi?path=$path");
}